/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.wso2.andes.transport.Binary;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionClose;
import org.wso2.andes.transport.DeliveryProperties;
import org.wso2.andes.transport.ExecutionException;
import org.wso2.andes.transport.ExecutionSync;
import org.wso2.andes.transport.Future;
import org.wso2.andes.transport.Header;
import org.wso2.andes.transport.MessageAcceptMode;
import org.wso2.andes.transport.MessageAcquireMode;
import org.wso2.andes.transport.MessageTransfer;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.Range;
import org.wso2.andes.transport.RangeSet;
import org.wso2.andes.transport.SenderException;
import org.wso2.andes.transport.SessionClosedException;
import org.wso2.andes.transport.SessionDelegate;
import org.wso2.andes.transport.SessionDetachCode;
import org.wso2.andes.transport.SessionException;
import org.wso2.andes.transport.SessionInvoker;
import org.wso2.andes.transport.SessionListener;
import org.wso2.andes.transport.Struct;
import org.wso2.andes.transport.util.Functions;
import org.wso2.andes.transport.util.Logger;
import org.wso2.andes.transport.util.Waiter;
import org.wso2.andes.util.Serial;
import org.wso2.andes.util.Strings;

public class Session
extends SessionInvoker {
    private static final Logger log = Logger.get(Session.class);
    public static final int UNLIMITED_CREDIT = -1;
    private Connection connection;
    private Binary name;
    private long expiry;
    private boolean closing;
    private int channel;
    private SessionDelegate delegate;
    private SessionListener listener = new DefaultSessionListener();
    private long timeout = 60000L;
    private boolean autoSync = false;
    private boolean incomingInit;
    private int commandsIn;
    private final Object processedLock = new Object();
    private RangeSet processed;
    private int maxProcessed;
    private int syncPoint;
    private int commandsOut = 0;
    private Method[] commands = new Method[Integer.getInteger("qpid.session.command_limit", 65536).intValue()];
    private int commandBytes = 0;
    private int byteLimit = Integer.getInteger("qpid.session.byte_limit", 0x100000);
    private int maxComplete = this.commandsOut - 1;
    private boolean needSync = false;
    private State state = State.NEW;
    private volatile boolean flowControl = false;
    private Semaphore credit = new Semaphore(0);
    private Thread resumer = null;
    private boolean transacted = false;
    private SessionDetachCode detachCode;
    private final Object stateLock = new Object();
    private Map<Integer, ResultFuture<?>> results = new HashMap();
    private ExecutionException exception = null;
    private ConnectionClose close = null;

    protected Session(Connection connection, Binary name, long expiry) {
        this(connection, new SessionDelegate(), name, expiry);
    }

    protected Session(Connection connection, SessionDelegate delegate, Binary name, long expiry) {
        this.connection = connection;
        this.delegate = delegate;
        this.name = name;
        this.expiry = expiry;
        this.closing = false;
        this.initReceiver();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Binary getName() {
        return this.name;
    }

    void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    void setClose(boolean close) {
        this.closing = close;
    }

    public int getChannel() {
        return this.channel;
    }

    void setChannel(int channel) {
        this.channel = channel;
    }

    public void setSessionListener(SessionListener listener) {
        this.listener = listener == null ? new DefaultSessionListener() : listener;
    }

    public SessionListener getSessionListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoSync(boolean value) {
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            this.autoSync = value;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(State state) {
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            this.state = state;
            this.commands.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void setFlowControl(boolean value) {
        this.flowControl = value;
    }

    void addCredit(int value) {
        this.credit.release(value);
    }

    void drainCredit() {
        this.credit.drainPermits();
    }

    void acquireCredit() {
        if (this.flowControl) {
            try {
                if (!this.credit.tryAcquire(this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new SessionException("timed out waiting for message credit");
                }
            }
            catch (InterruptedException e) {
                throw new SessionException("interrupted while waiting for credit", null, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReceiver() {
        Object object = this.processedLock;
        synchronized (object) {
            this.incomingInit = false;
            this.processed = new RangeSet();
        }
    }

    void attach() {
        this.initReceiver();
        this.sessionAttach(this.name.getBytes(), new Option[0]);
        this.sessionRequestTimeout(0L, new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            int i = this.maxComplete + 1;
            while (Serial.lt(i, this.commandsOut)) {
                Method m3 = this.commands[Functions.mod(i, this.commands.length)];
                if (m3 == null) {
                    m3 = new ExecutionSync(new Option[0]);
                    m3.setId(i);
                } else if (m3 instanceof MessageTransfer) {
                    MessageTransfer xfr = (MessageTransfer)m3;
                    if (xfr.getHeader() != null) {
                        if (xfr.getHeader().get(DeliveryProperties.class) != null) {
                            xfr.getHeader().get(DeliveryProperties.class).setRedelivered(true);
                        } else {
                            Struct[] structs = xfr.getHeader().getStructs();
                            DeliveryProperties deliveryProps = new DeliveryProperties();
                            deliveryProps.setRedelivered(true);
                            List<Struct> list = Arrays.asList(structs);
                            list.add(deliveryProps);
                            xfr.setHeader(new Header(list));
                        }
                    } else {
                        DeliveryProperties deliveryProps = new DeliveryProperties();
                        deliveryProps.setRedelivered(true);
                        xfr.setHeader(new Header(deliveryProps));
                    }
                }
                this.sessionCommandPoint(m3.getId(), 0L, new Option[0]);
                this.send(m3);
                ++i;
            }
            this.sessionCommandPoint(this.commandsOut, 0L, new Option[0]);
            this.sessionFlush(Option.COMPLETED);
            this.resumer = Thread.currentThread();
            this.state = State.RESUMING;
            this.listener.resumed(this);
            this.resumer = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump() {
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            for (Method m3 : this.commands) {
                if (m3 == null) continue;
                log.debug("%s", m3);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void commandPoint(int id) {
        Object object = this.processedLock;
        synchronized (object) {
            this.commandsIn = id;
            if (!this.incomingInit) {
                this.incomingInit = true;
                this.syncPoint = this.maxProcessed = this.commandsIn - 1;
            }
        }
    }

    public int getCommandsOut() {
        return this.commandsOut;
    }

    public int getCommandsIn() {
        return this.commandsIn;
    }

    public int nextCommandId() {
        return this.commandsIn++;
    }

    final void identify(Method cmd) {
        if (!this.incomingInit) {
            throw new IllegalStateException();
        }
        int id = this.nextCommandId();
        cmd.setId(id);
        if (log.isDebugEnabled()) {
            log.debug("ID: [%s] %s", this.channel, id);
        }
        if ((id & 0xFF) == 0) {
            this.flushProcessed(Option.TIMELY_REPLY);
        }
    }

    public void processed(Method command) {
        this.processed(command.getId());
    }

    public void processed(int command) {
        this.processed(new Range(command, command));
    }

    public void processed(int lower, int upper) {
        this.processed(new Range(lower, upper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processed(Range range) {
        boolean flush;
        log.debug("%s processed(%s) %s %s", this, range, this.syncPoint, this.maxProcessed);
        Object object = this.processedLock;
        synchronized (object) {
            log.debug("%s", this.processed);
            if (Serial.ge(range.getUpper(), this.commandsIn)) {
                throw new IllegalArgumentException("range exceeds max received command-id: " + range);
            }
            this.processed.add(range);
            Range first = this.processed.getFirst();
            int lower = first.getLower();
            int upper = first.getUpper();
            int old = this.maxProcessed;
            if (Serial.le(lower, this.maxProcessed + 1)) {
                this.maxProcessed = Serial.max(this.maxProcessed, upper);
            }
            boolean synced = Serial.ge(this.maxProcessed, this.syncPoint);
            boolean bl = flush = Serial.lt(old, this.syncPoint) && synced;
            if (synced) {
                this.syncPoint = this.maxProcessed;
            }
        }
        if (flush) {
            this.flushProcessed(new Option[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushExpected() {
        RangeSet rs = new RangeSet();
        Object object = this.processedLock;
        synchronized (object) {
            if (this.incomingInit) {
                rs.add(this.commandsIn);
            }
        }
        this.sessionExpected(rs, null, new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushProcessed(Option ... options) {
        Method[] methodArray = this.processedLock;
        synchronized (this.processedLock) {
            RangeSet copy = this.processed.copy();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            methodArray = this.commands;
            synchronized (this.commands) {
                if (this.state == State.DETACHED || this.state == State.CLOSING) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                if (copy.size() > 0) {
                    this.sessionCompleted(copy, options);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void knownComplete(RangeSet kc) {
        Object object = this.processedLock;
        synchronized (object) {
            RangeSet newProcessed = new RangeSet();
            for (Range pr : this.processed) {
                for (Range kr : kc) {
                    for (Range r : pr.subtract(kr)) {
                        newProcessed.add(r);
                    }
                }
            }
            this.processed = newProcessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncPoint() {
        boolean flush;
        int id = this.getCommandsIn() - 1;
        log.debug("%s synced to %d", this, id);
        Object object = this.processedLock;
        synchronized (object) {
            this.syncPoint = id;
            flush = Serial.ge(this.maxProcessed, this.syncPoint);
        }
        if (flush) {
            this.flushProcessed(new Option[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean complete(int lower, int upper) {
        if (log.isDebugEnabled()) {
            log.debug("%s complete(%d, %d)", this, lower, upper);
        }
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            int old = this.maxComplete;
            int id = Serial.max(this.maxComplete, lower);
            while (Serial.le(id, upper)) {
                int idx = Functions.mod(id, this.commands.length);
                Method m3 = this.commands[idx];
                if (m3 != null) {
                    this.commandBytes -= m3.getBodySize();
                    m3.complete();
                    this.commands[idx] = null;
                }
                ++id;
            }
            if (Serial.le(lower, this.maxComplete + 1)) {
                this.maxComplete = Serial.max(this.maxComplete, upper);
            }
            log.debug("%s   commands remaining: %s", this, this.commandsOut - this.maxComplete);
            this.commands.notifyAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Serial.gt(this.maxComplete, old);
        }
    }

    void received(Method m3) {
        m3.delegate(this, this.delegate);
    }

    private void send(Method m3) {
        m3.setChannel(this.channel);
        this.connection.send(m3);
        if (!m3.isBatch()) {
            this.connection.flush();
        }
    }

    protected boolean isFull(int id) {
        return this.isCommandsFull(id) || this.isBytesFull();
    }

    protected boolean isBytesFull() {
        return this.commandBytes >= this.byteLimit;
    }

    protected boolean isCommandsFull(int id) {
        return id - this.maxComplete >= this.commands.length;
    }

    @Override
    public void invoke(Method m3) {
        this.invoke(m3, (Runnable)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Method m3, Runnable postIdSettingAction) {
        if (m3.getEncodedTrack() == 3) {
            if (this.state == State.DETACHED && this.transacted) {
                this.state = State.CLOSED;
                this.delegate.closed(this);
                this.connection.removeSession(this);
                throw new SessionException("Session failed over, possibly in the middle of a transaction. Closing the session. Any Transaction in progress will be rolledback.");
            }
            if (m3.hasPayload()) {
                this.acquireCredit();
            }
            Method[] methodArray = this.commands;
            synchronized (this.commands) {
                boolean replayTransfer;
                ExecutionException exc;
                Waiter w;
                Thread current;
                if (this.state == State.DETACHED && m3.isUnreliable() && !(current = Thread.currentThread()).equals(this.resumer)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                if (this.state != State.OPEN && this.state != State.CLOSED && this.state != State.CLOSING && !(current = Thread.currentThread()).equals(this.resumer)) {
                    w = new Waiter(this.commands, this.timeout);
                    while (w.hasTime() && this.state != State.OPEN && this.state != State.CLOSED) {
                        w.await();
                    }
                }
                switch (this.state) {
                    case OPEN: {
                        break;
                    }
                    case RESUMING: {
                        current = Thread.currentThread();
                        if (current.equals(this.resumer)) break;
                        throw new SessionException("timed out waiting for resume to finish");
                    }
                    case CLOSING: 
                    case CLOSED: {
                        exc = this.getException();
                        if (exc != null) {
                            throw new SessionException(exc);
                        }
                        throw new SessionClosedException();
                    }
                    default: {
                        throw new SessionException(String.format("timed out waiting for session to become open (state=%s)", new Object[]{this.state}));
                    }
                }
                int next = this.commandsOut++;
                m3.setId(next);
                if (postIdSettingAction != null) {
                    postIdSettingAction.run();
                }
                if (this.isFull(next)) {
                    w = new Waiter(this.commands, this.timeout);
                    while (w.hasTime() && this.isFull(next) && this.state != State.CLOSED) {
                        if (this.state == State.OPEN || this.state == State.RESUMING) {
                            try {
                                this.sessionFlush(Option.COMPLETED);
                            }
                            catch (SenderException e) {
                                if (!this.closing) {
                                    log.error(e, "error sending flush (full replay buffer)", new Object[0]);
                                }
                                e.rethrow();
                            }
                        }
                        w.await();
                    }
                }
                if (this.state == State.CLOSED) {
                    exc = this.getException();
                    if (exc != null) {
                        throw new SessionException(exc);
                    }
                    throw new SessionClosedException();
                }
                if (this.isFull(next)) {
                    throw new SessionException("timed out waiting for completion");
                }
                if (next == 0) {
                    this.sessionCommandPoint(0, 0L, new Option[0]);
                }
                boolean bl = replayTransfer = !this.closing && !this.transacted && m3 instanceof MessageTransfer && !m3.isUnreliable();
                if (replayTransfer || m3.hasCompletionListener()) {
                    this.commands[Functions.mod((int)next, (int)this.commands.length)] = m3;
                    this.commandBytes += m3.getBodySize();
                }
                if (this.autoSync) {
                    m3.setSync(true);
                }
                this.needSync = !m3.isSync();
                try {
                    this.send(m3);
                }
                catch (SenderException e) {
                    if (!this.closing) {
                        log.error(e, "error sending command", new Object[0]);
                    }
                    e.rethrow();
                }
                if (this.autoSync) {
                    this.sync();
                }
                if (this.shouldIssueFlush(next)) {
                    try {
                        this.sessionFlush(Option.COMPLETED);
                    }
                    catch (SenderException e) {
                        if (!this.closing) {
                            log.error(e, "error sending flush (periodic)", new Object[0]);
                        }
                        e.rethrow();
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        this.send(m3);
    }

    protected boolean shouldIssueFlush(int next) {
        return next % 65536 == 0;
    }

    public void sync() {
        this.sync(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(long timeout) {
        log.debug("%s sync()", this);
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            int point = this.commandsOut - 1;
            if (this.needSync && Serial.lt(this.maxComplete, point)) {
                this.executionSync(Option.SYNC);
            }
            Waiter w = new Waiter(this.commands, timeout);
            while (w.hasTime() && this.state != State.CLOSED && Serial.lt(this.maxComplete, point)) {
                log.debug("%s   waiting for[%d]: %d, %s", this, point, this.maxComplete, this.commands);
                w.await();
            }
            if (Serial.lt(this.maxComplete, point)) {
                if (this.state != State.CLOSED) {
                    throw new SessionException(String.format("timed out waiting for sync: complete = %s, point = %s", this.maxComplete, point));
                }
                ExecutionException ee = this.getException();
                if (ee != null) {
                    throw new SessionException(ee);
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void result(int command, Struct result) {
        ResultFuture<?> future;
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            future = this.results.remove(command);
        }
        if (future != null) {
            ((ResultFuture)future).set(result);
        } else {
            log.warn("Received a response to a command that's no longer valid on the client side. [ command id : %s , result : %s ]", command, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setException(ExecutionException exc) {
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            if (this.exception != null) {
                throw new IllegalStateException(String.format("too many exceptions: %s, %s", this.exception, exc));
            }
            this.exception = exc;
        }
    }

    void closeCode(ConnectionClose close) {
        this.close = close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionException getException() {
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> Future<T> invoke(Method m3, Class<T> klass) {
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            int command = this.commandsOut;
            ResultFuture future = new ResultFuture(klass);
            Map<Integer, ResultFuture<?>> map = this.results;
            synchronized (map) {
                this.results.put(command, future);
            }
            this.invoke(m3);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return future;
        }
    }

    public final void messageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, byte[] body, Option ... _options) {
        this.messageTransfer(destination, acceptMode, acquireMode, header, ByteBuffer.wrap(body), _options);
    }

    public final void messageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, String body, Option ... _options) {
        this.messageTransfer(destination, acceptMode, acquireMode, header, Strings.toUTF8(body), _options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            this.state = State.CLOSING;
            this.setClose(true);
            this.sessionRequestTimeout(0L, new Option[0]);
            this.sessionDetach(this.name.getBytes(), new Option[0]);
            this.awaitClose();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void awaitClose() {
        Waiter w = new Waiter(this.commands, this.timeout);
        while (w.hasTime() && this.state != State.CLOSED) {
            w.await();
        }
        if (this.state != State.CLOSED) {
            throw new SessionException("close() timed out");
        }
    }

    public void exception(Throwable t) {
        log.error(t, "caught exception", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        Method[] methodArray = this.commands;
        synchronized (this.commands) {
            this.state = this.closing || this.getException() != null ? State.CLOSED : State.DETACHED;
            this.commands.notifyAll();
            Map<Integer, ResultFuture<?>> map = this.results;
            synchronized (map) {
                Iterator<ResultFuture<?>> iterator = this.results.values().iterator();
                while (iterator.hasNext()) {
                    ResultFuture<?> result;
                    ResultFuture<?> resultFuture = result = iterator.next();
                    synchronized (resultFuture) {
                        result.notifyAll();
                    }
                }
            }
            if (this.state == State.CLOSED) {
                this.delegate.closed(this);
            } else {
                this.delegate.detached(this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.state == State.CLOSED) {
                this.connection.removeSession(this);
                this.listener.closed(this);
            }
            return;
        }
    }

    public boolean isClosing() {
        return this.state == State.CLOSED || this.state == State.CLOSING;
    }

    public String toString() {
        return String.format("ssn:%s", this.name);
    }

    public void setTransacted(boolean b) {
        this.transacted = b;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setDetachCode(SessionDetachCode dtc) {
        this.detachCode = dtc;
    }

    public SessionDetachCode getDetachCode() {
        return this.detachCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitOpen() {
        switch (this.state) {
            case NEW: {
                Object object = this.stateLock;
                synchronized (object) {
                    Waiter w = new Waiter(this.stateLock, this.timeout);
                    while (w.hasTime() && this.state == State.NEW) {
                        w.await();
                    }
                }
                if (this.state != State.OPEN) {
                    throw new SessionException("Timed out waiting for Session to open");
                }
            }
            case CLOSING: 
            case CLOSED: 
            case DETACHED: {
                throw new SessionException("Session closed");
            }
        }
    }

    public Object getStateLock() {
        return this.stateLock;
    }

    private class ResultFuture<T>
    implements Future<T> {
        private final Class<T> klass;
        private T result;

        private ResultFuture(Class<T> klass) {
            this.klass = klass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void set(Struct result) {
            ResultFuture resultFuture = this;
            synchronized (resultFuture) {
                this.result = this.klass.cast(result);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get(long timeout) {
            ResultFuture resultFuture = this;
            synchronized (resultFuture) {
                Waiter w = new Waiter(this, timeout);
                while (w.hasTime() && Session.this.state != State.CLOSED && !this.isDone()) {
                    log.debug("%s waiting for result: %s", Session.this, this);
                    w.await();
                }
            }
            if (this.isDone()) {
                return this.result;
            }
            if (Session.this.state == State.CLOSED) {
                throw new SessionException(Session.this.getException());
            }
            throw new SessionException(String.format("%s timed out waiting for result: %s", Session.this, this));
        }

        @Override
        public T get() {
            return this.get(Session.this.timeout);
        }

        @Override
        public boolean isDone() {
            return this.result != null;
        }

        public String toString() {
            return String.format("Future(%s)", this.isDone() ? this.result : this.klass);
        }
    }

    static class DefaultSessionListener
    implements SessionListener {
        DefaultSessionListener() {
        }

        @Override
        public void opened(Session ssn) {
        }

        @Override
        public void resumed(Session ssn) {
        }

        @Override
        public void message(Session ssn, MessageTransfer xfr) {
            log.info("message: %s", xfr);
        }

        @Override
        public void exception(Session ssn, SessionException exc) {
            log.error(exc, "session exception", new Object[0]);
        }

        @Override
        public void closed(Session ssn) {
        }
    }

    public static enum State {
        NEW,
        DETACHED,
        RESUMING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

