/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.security;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionSettings;
import org.wso2.andes.transport.Receiver;
import org.wso2.andes.transport.Sender;
import org.wso2.andes.transport.TransportException;
import org.wso2.andes.transport.network.security.sasl.SASLReceiver;
import org.wso2.andes.transport.network.security.sasl.SASLSender;
import org.wso2.andes.transport.network.security.ssl.SSLReceiver;
import org.wso2.andes.transport.network.security.ssl.SSLSender;
import org.wso2.andes.transport.network.security.ssl.SSLUtil;

public class SecurityLayer {
    ConnectionSettings settings;
    Connection con;
    SSLSecurityLayer sslLayer;
    SASLSecurityLayer saslLayer;

    public SecurityLayer(Connection con) {
        this.con = con;
        this.settings = con.getConnectionSettings();
        if (this.settings.isUseSSL()) {
            this.sslLayer = new SSLSecurityLayer();
        }
        if (this.settings.isUseSASLEncryption()) {
            this.saslLayer = new SASLSecurityLayer();
        }
    }

    public Sender<ByteBuffer> sender(Sender<ByteBuffer> delegate) {
        Sender<ByteBuffer> sender = delegate;
        if (this.settings.isUseSSL()) {
            sender = this.sslLayer.sender(sender);
        }
        if (this.settings.isUseSASLEncryption()) {
            sender = this.saslLayer.sender(sender);
        }
        return sender;
    }

    public Receiver<ByteBuffer> receiver(Receiver<ByteBuffer> delegate) {
        Receiver<ByteBuffer> receiver = delegate;
        if (this.settings.isUseSSL()) {
            receiver = this.sslLayer.receiver(receiver);
        }
        if (this.settings.isUseSASLEncryption()) {
            receiver = this.saslLayer.receiver(receiver);
        }
        return receiver;
    }

    public String getUserID() {
        if (this.settings.isUseSSL()) {
            return this.sslLayer.getUserID();
        }
        return null;
    }

    class SASLSecurityLayer {
        public SASLSender sender(Sender<ByteBuffer> delegate) {
            SASLSender sender = new SASLSender(delegate);
            SecurityLayer.this.con.addConnectionListener(sender);
            return sender;
        }

        public SASLReceiver receiver(Receiver<ByteBuffer> delegate) {
            SASLReceiver receiver = new SASLReceiver(delegate);
            SecurityLayer.this.con.addConnectionListener(receiver);
            return receiver;
        }
    }

    class SSLSecurityLayer {
        SSLEngine engine;
        SSLSender sender;

        public SSLSecurityLayer() {
            SSLContext sslCtx;
            try {
                sslCtx = SSLUtil.createSSLContext(SecurityLayer.this.settings);
            }
            catch (Exception e) {
                throw new TransportException("Error creating SSL Context", e);
            }
            try {
                this.engine = sslCtx.createSSLEngine();
                this.engine.setUseClientMode(true);
            }
            catch (Exception e) {
                throw new TransportException("Error creating SSL Engine", e);
            }
        }

        public SSLSender sender(Sender<ByteBuffer> delegate) {
            this.sender = new SSLSender(this.engine, delegate);
            this.sender.setConnectionSettings(SecurityLayer.this.settings);
            return this.sender;
        }

        public SSLReceiver receiver(Receiver<ByteBuffer> delegate) {
            if (this.sender == null) {
                throw new IllegalStateException("SecurityLayer.sender method should be invoked before SecurityLayer.receiver");
            }
            SSLReceiver receiver = new SSLReceiver(this.engine, delegate, this.sender);
            receiver.setConnectionSettings(SecurityLayer.this.settings);
            return receiver;
        }

        public String getUserID() {
            return SSLUtil.retriveIdentity(this.engine);
        }
    }
}

