/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.AnalyticsDataProvider;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.RequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.FaultyRequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.SuccessRequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.UnclassifiedRequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.exceptions.AnalyticsException;

public class GenericRequestDataCollector
implements RequestDataCollector {
    private static final Log log = LogFactory.getLog(GenericRequestDataCollector.class);
    private RequestDataCollector successDataCollector;
    private RequestDataCollector faultDataCollector;
    private RequestDataCollector unclassifiedDataCollector;
    private AnalyticsDataProvider provider;

    public GenericRequestDataCollector(AnalyticsDataProvider provider) {
        this.successDataCollector = new SuccessRequestDataCollector(provider);
        this.faultDataCollector = new FaultyRequestDataCollector(provider);
        this.unclassifiedDataCollector = new UnclassifiedRequestDataCollector(provider);
        this.provider = provider;
    }

    @Override
    public void collectData() throws AnalyticsException {
        switch (this.provider.getEventCategory()) {
            case SUCCESS: {
                this.successDataCollector.collectData();
                break;
            }
            case FAULT: {
                this.faultDataCollector.collectData();
                break;
            }
            case INVALID: {
                this.unclassifiedDataCollector.collectData();
            }
        }
    }
}

