/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.fault;

import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.AnalyticsDataProvider;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.FaultDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.CommonRequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.exceptions.InvalidCategoryException;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.RequestDataPublisher;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Error;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Event;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.enums.FaultCategory;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.enums.FaultSubCategories;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.enums.FaultSubCategory;

public abstract class AbstractFaultDataCollector
extends CommonRequestDataCollector
implements FaultDataCollector {
    protected FaultCategory subType;
    private RequestDataPublisher processor;
    private AnalyticsDataProvider provider;

    public AbstractFaultDataCollector(AnalyticsDataProvider provider, FaultCategory subType, RequestDataPublisher processor) {
        super(provider);
        this.provider = provider;
        this.subType = subType;
        this.processor = processor;
    }

    protected final void processRequest(Event faultyEvent) throws InvalidCategoryException {
        Error error = this.provider.getError(this.subType);
        if (!this.isValidSubCategory(error.getErrorMessage())) {
            throw new InvalidCategoryException(this.subType, faultyEvent.getError().getErrorMessage().toString());
        }
        faultyEvent.setErrorType(this.subType.name());
        faultyEvent.setError(error);
        this.processor.publish(faultyEvent);
    }

    private boolean isValidSubCategory(FaultSubCategory subCategory) {
        if (FaultCategory.AUTH == this.subType) {
            return subCategory instanceof FaultSubCategories.Authentication;
        }
        if (FaultCategory.THROTTLED == this.subType) {
            return subCategory instanceof FaultSubCategories.Throttling;
        }
        if (FaultCategory.TARGET_CONNECTIVITY == this.subType) {
            return subCategory instanceof FaultSubCategories.TargetConnectivity;
        }
        if (FaultCategory.OTHER == this.subType) {
            return subCategory instanceof FaultSubCategories.Other;
        }
        return false;
    }
}

