/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.fault;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.AnalyticsDataProvider;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.fault.AbstractFaultDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.exceptions.AnalyticsException;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.RequestDataPublisher;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Application;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Event;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.enums.FaultCategory;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.impl.FaultyRequestDataPublisher;

public class ThrottledFaultDataCollector
extends AbstractFaultDataCollector {
    private static final Log log = LogFactory.getLog(ThrottledFaultDataCollector.class);
    private AnalyticsDataProvider provider;

    public ThrottledFaultDataCollector(AnalyticsDataProvider provider, FaultCategory subType, RequestDataPublisher processor) {
        super(provider, subType, processor);
    }

    public ThrottledFaultDataCollector(AnalyticsDataProvider provider) {
        this(provider, FaultCategory.THROTTLED, new FaultyRequestDataPublisher());
        this.provider = provider;
    }

    @Override
    public void collectFaultData(Event faultyEvent) throws AnalyticsException {
        log.debug("handling throttled failure analytics events");
        Application application = this.provider.isAuthenticated() && this.provider.isAnonymous() ? this.getAnonymousApp() : this.provider.getApplication();
        faultyEvent.setApplication(application);
        this.processRequest(faultyEvent);
    }
}

