/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.analytics.publishers.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.analytics.publisher.exception.MetricCreationException;
import org.wso2.am.analytics.publisher.reporter.CounterMetric;
import org.wso2.am.analytics.publisher.reporter.MetricReporter;
import org.wso2.am.analytics.publisher.reporter.MetricReporterFactory;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.carbon.apimgt.common.gateway.analytics.AnalyticsConfigurationHolder;

public class AnalyticsDataPublisher {
    private static final Log log = LogFactory.getLog(AnalyticsDataPublisher.class);
    private CounterMetric successMetricReporter;
    private CounterMetric faultyMetricReporter;
    private static AnalyticsDataPublisher instance;

    private AnalyticsDataPublisher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyticsDataPublisher getInstance() {
        if (instance != null) return instance;
        Class<AnalyticsDataPublisher> clazz = AnalyticsDataPublisher.class;
        synchronized (AnalyticsDataPublisher.class) {
            if (instance != null) return instance;
            instance = new AnalyticsDataPublisher();
            instance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        Map<String, String> configs = AnalyticsConfigurationHolder.getInstance().getConfigurations();
        String reporterClass = configs.get("publisher.reporter.class");
        try {
            MetricReporter metricReporter = reporterClass != null ? MetricReporterFactory.getInstance().createMetricReporter(reporterClass, configs) : MetricReporterFactory.getInstance().createMetricReporter(configs);
            this.successMetricReporter = metricReporter.createCounterMetric("apim:response", MetricSchema.RESPONSE);
            this.faultyMetricReporter = metricReporter.createCounterMetric("apim:faulty", MetricSchema.ERROR);
        }
        catch (MetricCreationException e) {
            log.error("Error initializing event publisher.", e);
        }
    }

    public CounterMetric getSuccessMetricReporter() {
        return this.successMetricReporter;
    }

    public CounterMetric getFaultyMetricReporter() {
        return this.faultyMetricReporter;
    }
}

