/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.jwtgenerator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTConfigurationDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTInfoDto;
import org.wso2.carbon.apimgt.common.gateway.jwtgenerator.AbstractAPIMgtGatewayJWTGenerator;

public class APIMgtGatewayJWTGeneratorImpl
extends AbstractAPIMgtGatewayJWTGenerator {
    @Override
    public Map<String, Object> populateStandardClaims(JWTInfoDto jwtInfoDto) {
        long currentTime = System.currentTimeMillis();
        long expireIn = currentTime + this.jwtConfigurationDto.getTTL() * 1000L;
        String dialect = this.getDialectURI();
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("iss", "wso2.org/products/am");
        claims.put("exp", String.valueOf(expireIn));
        claims.put("iat", String.valueOf(currentTime));
        if (!"".equals(dialect) && !"/".equals(dialect)) {
            dialect = dialect + "/";
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getSubscriber())) {
            claims.put(dialect + "subscriber", jwtInfoDto.getSubscriber());
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getApplicationid())) {
            claims.put(dialect + "applicationid", jwtInfoDto.getApplicationid());
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getApplicationname())) {
            claims.put(dialect + "applicationname", jwtInfoDto.getApplicationname());
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getApplicationtier())) {
            claims.put(dialect + "applicationtier", jwtInfoDto.getApplicationtier());
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getApiName())) {
            claims.put(dialect + "apiname", jwtInfoDto.getApiName());
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getApicontext())) {
            claims.put(dialect + "apicontext", jwtInfoDto.getApicontext());
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getVersion())) {
            claims.put(dialect + "version", jwtInfoDto.getVersion());
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getSubscriptionTier())) {
            claims.put(dialect + "tier", jwtInfoDto.getSubscriptionTier());
        }
        if (StringUtils.isNotEmpty(jwtInfoDto.getKeytype())) {
            claims.put(dialect + "keytype", jwtInfoDto.getKeytype());
        } else {
            claims.put(dialect + "keytype", "PRODUCTION");
        }
        claims.put(dialect + "usertype", "Application_User");
        claims.put(dialect + "enduser", jwtInfoDto.getEnduser());
        claims.put(dialect + "enduserTenantId", String.valueOf(jwtInfoDto.getEndusertenantid()));
        claims.put(dialect + "applicationUUId", jwtInfoDto.getApplicationuuid());
        Map<String, String> appAttributes = jwtInfoDto.getAppAttributes();
        if (appAttributes != null && !appAttributes.isEmpty()) {
            claims.put(dialect + "applicationAttributes", appAttributes);
        }
        return claims;
    }

    @Override
    public Map<String, Object> populateCustomClaims(JWTInfoDto jwtInfoDto) {
        String[] restrictedClaims = new String[]{"iss", "sub", "aud", "exp", "nbf", "iat", "jti", "application", "tierInfo", "subscribedAPIs"};
        JWTConfigurationDto jwtConfigurationDto = this.jwtConfigurationDto;
        HashMap<String, Object> claims = new HashMap<String, Object>();
        Set<String> jwtExcludedClaims = jwtConfigurationDto.getJWTExcludedClaims();
        jwtExcludedClaims.addAll(Arrays.asList(restrictedClaims));
        Map<String, Object> jwtToken = jwtInfoDto.getJwtValidationInfo().getClaims();
        if (jwtToken != null) {
            for (Map.Entry<String, Object> jwtClaimEntry : jwtToken.entrySet()) {
                if (jwtExcludedClaims.contains(jwtClaimEntry.getKey())) continue;
                claims.put(jwtClaimEntry.getKey(), jwtClaimEntry.getValue());
            }
        }
        return claims;
    }
}

