/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.jwtgenerator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTConfigurationDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTInfoDto;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.carbon.apimgt.common.gateway.util.JWTUtil;

public abstract class AbstractAPIMgtGatewayJWTGenerator {
    private static final Log log = LogFactory.getLog(AbstractAPIMgtGatewayJWTGenerator.class);
    public static final String NONE = "NONE";
    public static final String SHA256_WITH_RSA = "SHA256withRSA";
    public static final String API_GATEWAY_ID = "wso2.org/products/am";
    public JWTConfigurationDto jwtConfigurationDto;
    private static volatile long ttl = -1L;
    public String dialectURI;
    public String signatureAlgorithm;

    public void setJWTConfigurationDto(JWTConfigurationDto jwtConfigurationDto) {
        this.jwtConfigurationDto = jwtConfigurationDto;
        this.dialectURI = jwtConfigurationDto.getConsumerDialectUri();
        if (this.dialectURI == null) {
            this.dialectURI = "http://wso2.org/claims";
        }
        this.signatureAlgorithm = jwtConfigurationDto.getSignatureAlgorithm();
        if (this.signatureAlgorithm == null || !NONE.equals(this.signatureAlgorithm) && !SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            this.signatureAlgorithm = SHA256_WITH_RSA;
        }
    }

    public String generateToken(JWTInfoDto jwtInfoDto) throws JWTGeneratorException {
        String jwtHeader = this.buildHeader();
        String jwtBody = this.buildBody(jwtInfoDto);
        String base64UrlEncodedHeader = "";
        if (jwtHeader != null) {
            base64UrlEncodedHeader = this.encode(jwtHeader.getBytes(Charset.defaultCharset()));
        }
        String base64UrlEncodedBody = "";
        try {
            base64UrlEncodedBody = this.encode(jwtBody.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Error in encoding jwt body", e);
        }
        if (SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            String assertion = base64UrlEncodedHeader + '.' + base64UrlEncodedBody;
            byte[] signedAssertion = this.signJWT(assertion);
            if (log.isDebugEnabled()) {
                log.debug("signed assertion value : " + new String(signedAssertion, Charset.defaultCharset()));
            }
            String base64UrlEncodedAssertion = this.encode(signedAssertion);
            return base64UrlEncodedHeader + '.' + base64UrlEncodedBody + '.' + base64UrlEncodedAssertion;
        }
        return base64UrlEncodedHeader + '.' + base64UrlEncodedBody + '.';
    }

    public String buildHeader() throws JWTGeneratorException {
        String jwtHeader = null;
        if (NONE.equals(this.signatureAlgorithm)) {
            StringBuilder jwtHeaderBuilder = new StringBuilder();
            jwtHeaderBuilder.append("{\"typ\":\"JWT\",");
            jwtHeaderBuilder.append("\"alg\":\"");
            jwtHeaderBuilder.append(JWTUtil.getJWSCompliantAlgorithmCode(NONE));
            jwtHeaderBuilder.append('\"');
            jwtHeaderBuilder.append('}');
            jwtHeader = jwtHeaderBuilder.toString();
        } else if (SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            jwtHeader = this.addCertToHeader();
        }
        return jwtHeader;
    }

    public byte[] signJWT(String assertion) throws JWTGeneratorException {
        try {
            PrivateKey privateKey = this.jwtConfigurationDto.getPrivateKey();
            return JWTUtil.signJwt(assertion, privateKey, this.signatureAlgorithm);
        }
        catch (Exception e) {
            throw new JWTGeneratorException(e);
        }
    }

    protected String addCertToHeader() throws JWTGeneratorException {
        try {
            Certificate publicCert = this.jwtConfigurationDto.getPublicCert();
            return JWTUtil.generateHeader(publicCert, this.signatureAlgorithm);
        }
        catch (Exception e) {
            String error = "Error in obtaining keystore";
            throw new JWTGeneratorException(error, e);
        }
    }

    public String buildBody(JWTInfoDto jwtInfoDto) {
        JWTClaimsSet.Builder jwtClaimSetBuilder = new JWTClaimsSet.Builder();
        Map<String, Object> claims = this.populateStandardClaims(jwtInfoDto);
        Map<String, Object> customClaims = this.populateCustomClaims(jwtInfoDto);
        for (Map.Entry<String, Object> claimEntry : customClaims.entrySet()) {
            if (!claims.containsKey(claimEntry.getKey())) {
                claims.put((String)claimEntry.getKey(), claimEntry.getValue());
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Claim key " + (String)claimEntry.getKey() + " already exist");
        }
        ObjectMapper mapper = new ObjectMapper();
        for (Map.Entry entry : claims.entrySet()) {
            Object claimVal = entry.getValue();
            if (claimVal instanceof String && entry.toString().contains("{")) {
                try {
                    Map map = mapper.readValue(claimVal.toString(), Map.class);
                    jwtClaimSetBuilder.claim((String)entry.getKey(), map);
                }
                catch (IOException e) {
                    log.error(String.format("Error while reading claim values for %s", claimVal), e);
                }
                continue;
            }
            if (claimVal instanceof String && claimVal.toString().contains("[\"") && claimVal.toString().contains("\"]")) {
                try {
                    List arrayList = mapper.readValue(claimVal.toString(), List.class);
                    jwtClaimSetBuilder.claim((String)entry.getKey(), arrayList);
                }
                catch (IOException e) {
                    log.error("Error while reading claim values", e);
                }
                continue;
            }
            if ("exp".equals(entry.getKey())) {
                jwtClaimSetBuilder.claim((String)entry.getKey(), new Date(Long.parseLong((String)entry.getValue())));
                continue;
            }
            if ("iat".equals(entry.getKey())) {
                jwtClaimSetBuilder.claim((String)entry.getKey(), new Date(Long.parseLong((String)entry.getValue())));
                continue;
            }
            jwtClaimSetBuilder.claim((String)entry.getKey(), entry.getValue());
        }
        jwtClaimSetBuilder.jwtID(UUID.randomUUID().toString());
        JWTClaimsSet jwtClaimsSet = jwtClaimSetBuilder.build();
        return jwtClaimsSet.toJSONObject().toString();
    }

    public String encode(byte[] stringToBeEncoded) throws JWTGeneratorException {
        return Base64.getUrlEncoder().encodeToString(stringToBeEncoded);
    }

    public String getDialectURI() {
        return this.dialectURI;
    }

    public abstract Map<String, Object> populateStandardClaims(JWTInfoDto var1);

    public abstract Map<String, Object> populateCustomClaims(JWTInfoDto var1);
}

