/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.carbon.apimgt.common.gateway.jwtgenerator.JWTSignatureAlg;

public final class JWTUtil {
    private static final String NONE = "NONE";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";

    public static String getJWSCompliantAlgorithmCode(String signatureAlgorithm) {
        if (signatureAlgorithm == null || NONE.equals(signatureAlgorithm)) {
            return JWTSignatureAlg.NONE.getJwsCompliantCode();
        }
        if (SHA256_WITH_RSA.equals(signatureAlgorithm)) {
            return JWTSignatureAlg.SHA256_WITH_RSA.getJwsCompliantCode();
        }
        return signatureAlgorithm;
    }

    public static String generateHeader(Certificate publicCert, String signatureAlgorithm) throws JWTGeneratorException {
        try {
            MessageDigest digestValue = MessageDigest.getInstance("SHA-1");
            byte[] der = publicCert.getEncoded();
            digestValue.update(der);
            byte[] digestInBytes = digestValue.digest();
            String publicCertThumbprint = JWTUtil.hexify(digestInBytes);
            String base64UrlEncodedThumbPrint = Base64.getUrlEncoder().encodeToString(publicCertThumbprint.getBytes("UTF-8"));
            StringBuilder jwtHeader = new StringBuilder();
            jwtHeader.append("{\"typ\":\"JWT\",");
            jwtHeader.append("\"alg\":\"");
            jwtHeader.append(JWTUtil.getJWSCompliantAlgorithmCode(signatureAlgorithm));
            jwtHeader.append("\",");
            jwtHeader.append("\"x5t\":\"");
            jwtHeader.append(base64UrlEncodedThumbPrint);
            jwtHeader.append("\",");
            jwtHeader.append("\"kid\":\"");
            jwtHeader.append(JWTUtil.getKID(base64UrlEncodedThumbPrint, JWTUtil.getJWSCompliantAlgorithmCode(signatureAlgorithm)));
            jwtHeader.append("\"");
            jwtHeader.append("}");
            return jwtHeader.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new JWTGeneratorException("Error in generating public certificate thumbprint", e);
        }
    }

    public static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            buf.append(hexDigits[(aByte & 0xF0) >> 4]);
            buf.append(hexDigits[aByte & 0xF]);
        }
        return buf.toString();
    }

    private static String getKID(String certThumbprint, String signatureAlgorithm) {
        return certThumbprint + "_" + signatureAlgorithm;
    }

    public static byte[] signJwt(String assertion, PrivateKey privateKey, String signatureAlgorithm) throws JWTGeneratorException {
        try {
            Signature signature = Signature.getInstance(signatureAlgorithm);
            signature.initSign(privateKey);
            byte[] dataInBytes = assertion.getBytes(Charset.defaultCharset());
            signature.update(dataInBytes);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new JWTGeneratorException("Signature algorithm not found", e);
        }
        catch (InvalidKeyException e) {
            throw new JWTGeneratorException("Invalid private key provided for signing", e);
        }
        catch (SignatureException e) {
            throw new JWTGeneratorException("Error while signing JWT", e);
        }
    }
}

