/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.api;

import io.envoyproxy.envoy.service.auth.v3.CheckRequest;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.api.Api;
import org.wso2.micro.gateway.enforcer.api.API;
import org.wso2.micro.gateway.enforcer.api.RestAPI;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;
import org.wso2.micro.gateway.enforcer.discovery.ApiDiscoveryClient;

public class APIFactory {
    private static final Logger logger = LogManager.getLogger(APIFactory.class);
    private static APIFactory apiFactory;
    private ConcurrentHashMap<String, API> apis = new ConcurrentHashMap();

    private APIFactory() {
    }

    public static APIFactory getInstance() {
        if (apiFactory == null) {
            apiFactory = new APIFactory();
        }
        return apiFactory;
    }

    public void init() {
        ApiDiscoveryClient ads = ApiDiscoveryClient.getInstance();
        ads.watchApis();
    }

    public void addApi(API api) {
        String apiKey = this.getApiKey(api);
        this.apis.put(apiKey, api);
    }

    public void addApis(List<Api> apis) {
        ConcurrentHashMap<String, RestAPI> newApis = new ConcurrentHashMap<String, RestAPI>();
        for (Api api : apis) {
            RestAPI enforcerApi = new RestAPI();
            enforcerApi.init(api);
            String apiKey = this.getApiKey(enforcerApi);
            newApis.put(apiKey, enforcerApi);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Total APIs in new cache: {}", (Object)newApis.size());
        }
        this.apis = newApis;
    }

    public void removeApi(API api) {
        String apiKey = this.getApiKey(api);
        this.apis.remove(apiKey);
    }

    public API getMatchedAPI(CheckRequest request) {
        String basePath = request.getAttributes().getContextExtensionsMap().get("basePath");
        String version = request.getAttributes().getContextExtensionsMap().get("version");
        String apiKey = basePath + "/" + version;
        if (logger.isDebugEnabled()) {
            logger.debug("Looking for matching API with basepath: {} and version: {}", (Object)basePath, (Object)version);
        }
        return this.apis.get(apiKey);
    }

    public ResourceConfig getMatchedResource(API api, String matchedResourcePath, String method) {
        List<ResourceConfig> resourceConfigList = api.getAPIConfig().getResources();
        return resourceConfigList.stream().filter(resourceConfig -> resourceConfig.getPath().equals(matchedResourcePath)).filter(resourceConfig -> method == null || resourceConfig.getMethod().equals((Object)ResourceConfig.HttpMethods.valueOf(method))).findFirst().orElse(null);
    }

    private String getApiKey(API api) {
        return api.getAPIConfig().getBasePath() + "/" + api.getAPIConfig().getVersion();
    }
}

