/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.api;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.wso2.micro.gateway.enforcer.api.API;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;
import org.wso2.micro.gateway.enforcer.security.AuthenticationContext;

public class RequestContext {
    private API mathedAPI;
    private String requestPath;
    private String requestMethod;
    private ResourceConfig matchedResourcePath;
    private Map<String, String> headers;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private AuthenticationContext authenticationContext;
    private String requestID;
    private String address;
    private String prodClusterHeader;
    private String sandClusterHeader;
    private boolean clusterHeaderEnabled = false;
    private Map<String, String> responseHeaders;

    private RequestContext() {
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public String getAddress() {
        return this.address;
    }

    public API getMathedAPI() {
        return this.mathedAPI;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public ResourceConfig getMatchedResourcePath() {
        return this.matchedResourcePath;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getProdClusterHeader() {
        return this.prodClusterHeader;
    }

    public String getSandClusterHeader() {
        return this.sandClusterHeader;
    }

    public boolean isClusterHeaderEnabled() {
        return this.clusterHeaderEnabled;
    }

    public void addResponseHeaders(String key, String value) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new TreeMap<String, String>();
        }
        this.responseHeaders.put(key, value);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public static class Builder {
        private API mathedAPI;
        private String requestPath;
        private String requestMethod;
        private ResourceConfig matchedResourceConfig;
        private Map<String, String> headers;
        private String prodClusterHeader;
        private String sandClusterHeader;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private AuthenticationContext authenticationContext = new AuthenticationContext();
        private String requestID;
        private String address;

        public Builder(String requestPath) {
            this.requestPath = requestPath;
        }

        public Builder matchedAPI(API api) {
            this.mathedAPI = api;
            return this;
        }

        public Builder requestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder matchedResourceConfig(ResourceConfig matchedResourcePath) {
            this.matchedResourceConfig = matchedResourcePath;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder prodClusterHeader(String cluster) {
            if (!StringUtils.isEmpty(cluster)) {
                this.prodClusterHeader = cluster;
            }
            return this;
        }

        public Builder sandClusterHeader(String cluster) {
            if (!StringUtils.isEmpty(cluster)) {
                this.sandClusterHeader = cluster;
            }
            return this;
        }

        public Builder authenticationContext(AuthenticationContext authenticationContext) {
            this.authenticationContext = authenticationContext;
            return this;
        }

        public Builder requestID(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public RequestContext build() {
            RequestContext requestContext = new RequestContext();
            requestContext.matchedResourcePath = this.matchedResourceConfig;
            requestContext.mathedAPI = this.mathedAPI;
            requestContext.requestMethod = this.requestMethod;
            requestContext.requestPath = this.requestPath;
            requestContext.headers = this.headers;
            requestContext.prodClusterHeader = this.prodClusterHeader;
            requestContext.sandClusterHeader = this.sandClusterHeader;
            requestContext.properties = this.properties;
            requestContext.authenticationContext = this.authenticationContext;
            requestContext.requestID = this.requestID;
            requestContext.address = this.address;
            if (!StringUtils.isEmpty(this.prodClusterHeader) && !StringUtils.isEmpty(this.sandClusterHeader)) {
                requestContext.clusterHeaderEnabled = true;
            }
            return requestContext;
        }
    }
}

