/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.api.Api;
import org.wso2.gateway.discovery.api.Operation;
import org.wso2.gateway.discovery.api.Resource;
import org.wso2.micro.gateway.enforcer.Filter;
import org.wso2.micro.gateway.enforcer.api.API;
import org.wso2.micro.gateway.enforcer.api.RequestContext;
import org.wso2.micro.gateway.enforcer.api.ResponseObject;
import org.wso2.micro.gateway.enforcer.api.config.APIConfig;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.constants.APIConstants;
import org.wso2.micro.gateway.enforcer.cors.CorsFilter;
import org.wso2.micro.gateway.enforcer.filters.ThrottleFilter;
import org.wso2.micro.gateway.enforcer.security.AuthFilter;

public class RestAPI
implements API {
    private static final Logger logger = LogManager.getLogger(RestAPI.class);
    private APIConfig apiConfig;
    private String apiLifeCycleState;
    private List<Filter> filters = new ArrayList<Filter>();

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public String init(Api api) {
        String basePath = api.getBasePath();
        String name = api.getTitle();
        String version = api.getVersion();
        ArrayList<ResourceConfig> resources = new ArrayList<ResourceConfig>();
        for (Resource res : api.getResourcesList()) {
            for (Operation operation : res.getMethodsList()) {
                ResourceConfig resConfig = this.buildResource(operation, res.getPath());
                resources.add(resConfig);
            }
        }
        this.apiConfig = new APIConfig.Builder(name).basePath(basePath).version(version).resources(resources).apiLifeCycleState(this.apiLifeCycleState).build();
        this.apiLifeCycleState = api.getApiLifeCycleStatus();
        this.initFilters();
        return basePath;
    }

    @Override
    public ResponseObject process(RequestContext requestContext) {
        ResponseObject responseObject = new ResponseObject();
        if (this.executeFilterChain(requestContext)) {
            responseObject.setStatusCode(APIConstants.StatusCodes.OK.getCode());
            if (requestContext.getResponseHeaders() != null) {
                responseObject.setHeaderMap(requestContext.getResponseHeaders());
            }
        } else {
            responseObject.setDirectResponse(true);
            responseObject.setStatusCode(Integer.parseInt(requestContext.getProperties().get("status_code").toString()));
            if (requestContext.getProperties().get("code") != null) {
                responseObject.setErrorCode(requestContext.getProperties().get("code").toString());
            }
            if (requestContext.getProperties().get("error_message") != null) {
                responseObject.setErrorMessage(requestContext.getProperties().get("error_message").toString());
            }
            if (requestContext.getProperties().get("error_description") != null) {
                responseObject.setErrorDescription(requestContext.getProperties().get("error_description").toString());
            }
            if (requestContext.getResponseHeaders() != null && requestContext.getResponseHeaders().size() > 0) {
                responseObject.setHeaderMap(requestContext.getResponseHeaders());
            }
        }
        return responseObject;
    }

    @Override
    public APIConfig getAPIConfig() {
        return this.apiConfig;
    }

    private ResourceConfig buildResource(Operation operation, String resPath) {
        ResourceConfig resource = new ResourceConfig();
        resource.setPath(resPath);
        resource.setMethod(ResourceConfig.HttpMethods.valueOf(operation.getMethod().toUpperCase()));
        HashMap<String, List<String>> securityMap = new HashMap<String, List<String>>();
        operation.getSecurityList().forEach(securityList -> securityList.getScopeListMap().forEach((key, security) -> {
            ArrayList<String> scopeList = new ArrayList<String>();
            if (security != null && security.getScopesList() != null) {
                scopeList.addAll(security.getScopesList());
                securityMap.put((String)key, (List<String>)scopeList);
            }
        }));
        resource.setSecuritySchemas(securityMap);
        return resource;
    }

    private void initFilters() {
        CorsFilter corsFilter = new CorsFilter();
        this.filters.add(corsFilter);
        if (!"PROTOTYPED".equals(this.apiLifeCycleState)) {
            AuthFilter authFilter = new AuthFilter();
            authFilter.init(this.apiConfig);
            this.filters.add(authFilter);
        }
        if (ConfigHolder.getInstance().getConfig().getThrottleConfig().isGlobalPublishingEnabled()) {
            ThrottleFilter throttleFilter = new ThrottleFilter();
            throttleFilter.init(this.apiConfig);
            this.filters.add(throttleFilter);
        }
    }
}

