/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.micro.gateway.enforcer.security.KeyValidator;

public class ReferenceHolder {
    private static final ReferenceHolder instance = new ReferenceHolder();
    private final Map<String, KeyValidator> keyValidationHandlerMap = new ConcurrentHashMap<String, KeyValidator>();

    private ReferenceHolder() {
    }

    public static ReferenceHolder getInstance() {
        return instance;
    }

    public KeyValidator getKeyValidationHandler(String tenantDomain) {
        if (this.keyValidationHandlerMap.containsKey(tenantDomain)) {
            return this.keyValidationHandlerMap.get(tenantDomain);
        }
        KeyValidator defaultKeyValidationHandler = new KeyValidator();
        this.keyValidationHandlerMap.put(tenantDomain, defaultKeyValidationHandler);
        return defaultKeyValidationHandler;
    }
}

