/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.config;

import com.google.protobuf.ProtocolStringList;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.carbon.apimgt.common.gateway.dto.ClaimMappingDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWKSConfigurationDTO;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTConfigurationDto;
import org.wso2.gateway.discovery.config.enforcer.AmCredentials;
import org.wso2.gateway.discovery.config.enforcer.AuthService;
import org.wso2.gateway.discovery.config.enforcer.BinaryPublisher;
import org.wso2.gateway.discovery.config.enforcer.Cache;
import org.wso2.gateway.discovery.config.enforcer.ClaimMapping;
import org.wso2.gateway.discovery.config.enforcer.Config;
import org.wso2.gateway.discovery.config.enforcer.EventHub;
import org.wso2.gateway.discovery.config.enforcer.Issuer;
import org.wso2.gateway.discovery.config.enforcer.JWTGenerator;
import org.wso2.gateway.discovery.config.enforcer.JWTIssuer;
import org.wso2.gateway.discovery.config.enforcer.PublisherPool;
import org.wso2.gateway.discovery.config.enforcer.TMURLGroup;
import org.wso2.gateway.discovery.config.enforcer.ThrottleAgent;
import org.wso2.gateway.discovery.config.enforcer.Throttling;
import org.wso2.micro.gateway.enforcer.config.EnforcerConfig;
import org.wso2.micro.gateway.enforcer.config.EnvVarConfig;
import org.wso2.micro.gateway.enforcer.config.dto.AuthServiceConfigurationDto;
import org.wso2.micro.gateway.enforcer.config.dto.CacheDto;
import org.wso2.micro.gateway.enforcer.config.dto.CredentialDto;
import org.wso2.micro.gateway.enforcer.config.dto.EventHubConfigurationDto;
import org.wso2.micro.gateway.enforcer.config.dto.ExtendedTokenIssuerDto;
import org.wso2.micro.gateway.enforcer.config.dto.JWTIssuerConfigurationDto;
import org.wso2.micro.gateway.enforcer.config.dto.ThrottleAgentConfigDto;
import org.wso2.micro.gateway.enforcer.config.dto.ThrottleConfigDto;
import org.wso2.micro.gateway.enforcer.discovery.ConfigDiscoveryClient;
import org.wso2.micro.gateway.enforcer.exception.DiscoveryException;
import org.wso2.micro.gateway.enforcer.exception.MGWException;
import org.wso2.micro.gateway.enforcer.security.jwt.JWTUtil;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.conf.AgentConfiguration;
import org.wso2.micro.gateway.enforcer.throttle.databridge.publisher.PublisherConfiguration;
import org.wso2.micro.gateway.enforcer.util.TLSUtils;

public class ConfigHolder {
    private static final Logger logger = LogManager.getLogger(ConfigHolder.class);
    private static ConfigHolder configHolder;
    private EnvVarConfig envVarConfig = new EnvVarConfig();
    EnforcerConfig config = new EnforcerConfig();
    private KeyStore trustStore = null;
    private KeyStore trustStoreForJWT = null;
    private TrustManagerFactory trustManagerFactory = null;
    private ArrayList<ExtendedTokenIssuerDto> configIssuerList;

    private ConfigHolder() {
        this.init();
    }

    public static ConfigHolder getInstance() {
        if (configHolder != null) {
            return configHolder;
        }
        configHolder = new ConfigHolder();
        return configHolder;
    }

    private void init() {
        this.loadTrustStore();
        ConfigDiscoveryClient cds = new ConfigDiscoveryClient(this.envVarConfig, this.trustManagerFactory);
        try {
            Config cdsConfig = cds.requestInitConfig();
            this.parseConfigs(cdsConfig);
        }
        catch (DiscoveryException e) {
            logger.error("Error in loading configurations from Adapter", (Throwable)e);
            System.exit(1);
        }
    }

    private void parseConfigs(Config config) {
        this.populateEventHub(config.getEventhub());
        this.populateAuthService(config.getAuthService());
        this.populateJWTIssuerConfiguration(config.getJwtTokenConfigList());
        this.populateAPIMCredentials(config.getApimCredentials());
        this.populateThrottlingConfig(config.getThrottling());
        this.populateJWTGeneratorConfigurations(config.getJwtGenerator());
        this.populateCacheConfigs(config.getCache());
        this.populateJWTIssuerConfigurations(config.getJwtIssuer());
        this.resolveConfigsWithEnvs(this.config);
    }

    private void populateAuthService(AuthService cdsAuth) {
        AuthServiceConfigurationDto authDto = new AuthServiceConfigurationDto();
        authDto.setKeepAliveTime(cdsAuth.getKeepAliveTime());
        authDto.setPort(cdsAuth.getPort());
        authDto.setMaxHeaderLimit(cdsAuth.getMaxHeaderLimit());
        authDto.setMaxMessageSize(cdsAuth.getMaxMessageSize());
        AuthServiceConfigurationDto.ThreadPoolConfig threadPool = new AuthServiceConfigurationDto.ThreadPoolConfig(authDto);
        threadPool.setCoreSize(cdsAuth.getThreadPool().getCoreSize());
        threadPool.setKeepAliveTime(cdsAuth.getThreadPool().getKeepAliveTime());
        threadPool.setMaxSize(cdsAuth.getThreadPool().getMaxSize());
        threadPool.setQueueSize(cdsAuth.getThreadPool().getQueueSize());
        authDto.setThreadPool(threadPool);
        this.config.setAuthService(authDto);
    }

    private void populateEventHub(EventHub eventhub) {
        EventHubConfigurationDto eventHubDto = new EventHubConfigurationDto();
        eventHubDto.setEnable(eventhub.getEnabled());
        eventHubDto.setServiceUrl(eventhub.getServiceUrl());
        Properties jmsProps = new Properties();
        jmsProps.put("eventListeningEndpoints", eventhub.getJmsConnectionParameters().getEventListeningEndpointsList());
        eventHubDto.setJmsConnectionParameters(jmsProps);
        this.config.setEventHub(eventHubDto);
    }

    private void populateJWTIssuerConfiguration(List<Issuer> cdsIssuers) {
        this.configIssuerList = new ArrayList();
        try {
            this.setTrustStoreForJWT(KeyStore.getInstance(KeyStore.getDefaultType()));
            this.getTrustStoreForJWT().load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Error while initiating the truststore for JWT related public certificates", (Throwable)e);
        }
        for (Issuer jwtIssuer : cdsIssuers) {
            ExtendedTokenIssuerDto issuerDto = new ExtendedTokenIssuerDto(jwtIssuer.getIssuer());
            JWKSConfigurationDTO jwksConfigurationDTO = new JWKSConfigurationDTO();
            jwksConfigurationDTO.setEnabled(StringUtils.isNotEmpty(jwtIssuer.getJwksURL()));
            jwksConfigurationDTO.setUrl(jwtIssuer.getJwksURL());
            issuerDto.setJwksConfigurationDTO(jwksConfigurationDTO);
            List<ClaimMapping> claimMaps = jwtIssuer.getClaimMappingList();
            for (ClaimMapping claimMap : claimMaps) {
                ClaimMappingDto map = new ClaimMappingDto(claimMap.getRemoteClaim(), claimMap.getLocalClaim());
                issuerDto.addClaimMapping(map);
            }
            this.config.setJwtTransformerMap(JWTUtil.loadJWTTransformers());
            String certificateAlias = jwtIssuer.getCertificateAlias();
            if (!certificateAlias.isBlank()) {
                try {
                    Certificate cert = TLSUtils.getCertificateFromFile(jwtIssuer.getCertificateFilePath());
                    this.getTrustStoreForJWT().setCertificateEntry(certificateAlias, cert);
                    TLSUtils.convertCertificate(cert);
                    issuerDto.setCertificate(TLSUtils.convertCertificate(cert));
                }
                catch (IOException | KeyStoreException | CertificateException e) {
                    logger.error("Error while adding certificates to the JWT related Truststore", (Throwable)e);
                    continue;
                }
            }
            issuerDto.setName(jwtIssuer.getName());
            issuerDto.setConsumerKeyClaim(jwtIssuer.getConsumerKeyClaim());
            issuerDto.setValidateSubscriptions(jwtIssuer.getValidateSubscription());
            this.config.getIssuersMap().put(jwtIssuer.getIssuer(), issuerDto);
            this.configIssuerList.add(issuerDto);
        }
    }

    private void populateThrottlingConfig(Throttling throttling) {
        ThrottleConfigDto throttleConfig = new ThrottleConfigDto();
        throttleConfig.setGlobalPublishingEnabled(throttling.getEnableGlobalEventPublishing());
        throttleConfig.setHeaderConditionsEnabled(throttling.getEnableHeaderConditions());
        throttleConfig.setQueryConditionsEnabled(throttling.getEnableQueryParamConditions());
        throttleConfig.setJwtClaimConditionsEnabled(throttling.getEnableJwtClaimConditions());
        throttleConfig.setJmsConnectionInitialContextFactory(throttling.getJmsConnectionInitialContextFactory());
        throttleConfig.setJmsConnectionProviderUrl(throttling.getJmsConnectionProviderUrl());
        this.config.setThrottleConfig(throttleConfig);
        this.populateTMBinaryConfig(throttling.getPublisher());
    }

    private void populateTMBinaryConfig(BinaryPublisher binary) {
        ThrottleAgent binaryAgent = binary.getAgent();
        AgentConfiguration agentConf = AgentConfiguration.getInstance();
        agentConf.setBatchSize(binaryAgent.getBatchSize());
        agentConf.setCiphers(binaryAgent.getCiphers());
        agentConf.setCorePoolSize(binaryAgent.getCorePoolSize());
        agentConf.setEvictionTimePeriod(binaryAgent.getEvictionTimePeriod());
        agentConf.setKeepAliveTimeInPool(binaryAgent.getKeepAliveTimeInPool());
        agentConf.setMaxIdleConnections(binaryAgent.getMaxIdleConnections());
        agentConf.setMaxPoolSize(binaryAgent.getMaxPoolSize());
        agentConf.setMaxTransportPoolSize(binaryAgent.getMaxTransportPoolSize());
        agentConf.setMinIdleTimeInPool(binaryAgent.getMinIdleTimeInPool());
        agentConf.setQueueSize(binaryAgent.getQueueSize());
        agentConf.setReconnectionInterval(binaryAgent.getReconnectionInterval());
        agentConf.setSecureEvictionTimePeriod(binaryAgent.getSecureEvictionTimePeriod());
        agentConf.setSecureMaxIdleConnections(binaryAgent.getSecureMaxIdleConnections());
        agentConf.setSecureMaxTransportPoolSize(binaryAgent.getSecureMaxTransportPoolSize());
        agentConf.setSecureMinIdleTimeInPool(binaryAgent.getSecureMinIdleTimeInPool());
        agentConf.setSslEnabledProtocols(binaryAgent.getSslEnabledProtocols());
        agentConf.setSocketTimeoutMS(binaryAgent.getSocketTimeoutMS());
        agentConf.setTrustStore(this.trustStore);
        PublisherPool pool = binary.getPool();
        PublisherConfiguration pubConf = PublisherConfiguration.getInstance();
        pubConf.setUserName(binary.getUsername());
        pubConf.setPassword(binary.getPassword());
        pubConf.setInitIdleObjectDataPublishingAgents(pool.getInitIdleObjectDataPublishingAgents());
        pubConf.setMaxIdleDataPublishingAgents(pool.getMaxIdleDataPublishingAgents());
        pubConf.setPublisherThreadPoolCoreSize(pool.getPublisherThreadPoolCoreSize());
        pubConf.setPublisherThreadPoolKeepAliveTime(pool.getPublisherThreadPoolKeepAliveTime());
        pubConf.setPublisherThreadPoolMaximumSize(pool.getPublisherThreadPoolMaximumSize());
        this.processTMPublisherURLGroup(binary.getUrlGroupList(), pubConf);
        ThrottleAgentConfigDto throttleAgent = new ThrottleAgentConfigDto();
        throttleAgent.setAgent(agentConf);
        throttleAgent.setUsername(binary.getUsername());
        throttleAgent.setPassword(binary.getPassword());
        throttleAgent.setPublisher(pubConf);
        this.config.getThrottleConfig().setThrottleAgent(throttleAgent);
    }

    private void loadTrustStore() {
        try {
            this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.trustStore.load(null);
            String truststoreFilePath = this.getEnvVarConfig().getTrustedAdapterCertsPath();
            TLSUtils.addCertsToTruststore(this.trustStore, truststoreFilePath);
            this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.trustManagerFactory.init(this.trustStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Error in loading certs to the trust store.", (Throwable)e);
        }
    }

    private void populateAPIMCredentials(AmCredentials cred) {
        String username = cred.getUsername();
        char[] password = cred.getPassword().toCharArray();
        CredentialDto credentialDto = new CredentialDto(username, password);
        this.config.setApimCredentials(credentialDto);
    }

    private void processTMPublisherURLGroup(List<TMURLGroup> urlGroups, PublisherConfiguration pubConfiguration) {
        StringBuilder restructuredReceiverURL = new StringBuilder();
        StringBuilder restructuredAuthURL = new StringBuilder();
        for (TMURLGroup urlGroup : urlGroups) {
            ProtocolStringList receiverUrls = urlGroup.getReceiverURLsList();
            ProtocolStringList authUrls = urlGroup.getAuthURLsList();
            if (receiverUrls.size() == 1 && authUrls.size() == 1) {
                restructuredReceiverURL.append("{").append((String)receiverUrls.get(0)).append("},");
                restructuredAuthURL.append("{").append((String)authUrls.get(0)).append("},");
                continue;
            }
            String urlType = urlGroup.getType();
            if (urlType.isBlank() || !"loadbalance".equalsIgnoreCase(urlType) && !"failover".equalsIgnoreCase(urlType)) {
                logger.warn("Type is not loadbalance or failover. Hence proceeding as a failover configuration.");
                urlType = "failover";
            }
            restructuredReceiverURL.append(this.processSingleURLGroup(receiverUrls, urlType)).append(",");
            restructuredAuthURL.append(this.processSingleURLGroup(authUrls, urlType)).append(",");
        }
        if (!restructuredReceiverURL.toString().isBlank() && !restructuredAuthURL.toString().isBlank()) {
            pubConfiguration.setReceiverUrlGroup(restructuredReceiverURL.substring(0, restructuredReceiverURL.length() - 1));
            pubConfiguration.setAuthUrlGroup(restructuredAuthURL.substring(0, restructuredAuthURL.length() - 1));
        }
    }

    private String processSingleURLGroup(List<String> urlArray, String urlType) {
        StringBuilder concatenatedURLString = new StringBuilder("{");
        for (String url : urlArray) {
            if ("loadbalance".equalsIgnoreCase(urlType)) {
                concatenatedURLString.append(url).append(",");
                continue;
            }
            if ("failover".equalsIgnoreCase(urlType)) {
                concatenatedURLString.append(url).append("|");
                continue;
            }
            concatenatedURLString.append(url).append("|");
        }
        concatenatedURLString = new StringBuilder(concatenatedURLString.substring(0, concatenatedURLString.length() - 1) + "}");
        return concatenatedURLString.toString();
    }

    private void populateJWTGeneratorConfigurations(JWTGenerator jwtGenerator) {
        JWTConfigurationDto jwtConfigurationDto = new JWTConfigurationDto();
        jwtConfigurationDto.setEnabled(jwtGenerator.getEnable());
        jwtConfigurationDto.setJwtHeader(jwtGenerator.getHeader());
        jwtConfigurationDto.setConsumerDialectUri(jwtGenerator.getClaimDialect());
        jwtConfigurationDto.setSignatureAlgorithm(jwtGenerator.getSigningAlgorithm());
        jwtConfigurationDto.setEnableUserClaims(jwtGenerator.getEnableUserClaims());
        jwtConfigurationDto.setGatewayJWTGeneratorImpl(jwtGenerator.getGatewayGeneratorImpl());
        try {
            jwtConfigurationDto.setPublicCert(TLSUtils.getCertificate(jwtGenerator.getPublicCertificatePath()));
            jwtConfigurationDto.setPrivateKey(JWTUtil.getPrivateKey(jwtGenerator.getPrivateKeyPath()));
        }
        catch (IOException | CertificateException | MGWException e) {
            logger.error("Error in loading public cert or private key", (Throwable)e);
        }
        this.config.setJwtConfigurationDto(jwtConfigurationDto);
    }

    private void populateCacheConfigs(Cache cache) {
        CacheDto cacheDto = new CacheDto();
        cacheDto.setEnabled(cache.getEnable());
        cacheDto.setMaximumSize(cache.getMaximumSize());
        cacheDto.setExpiryTime(cache.getExpiryTime());
        this.config.setCacheDto(cacheDto);
    }

    private void resolveConfigsWithEnvs(Object config) {
        String packageName = this.config.getClass().getPackageName();
        for (Field field : config.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (field.getType().isAssignableFrom(String.class) || field.getType().isAssignableFrom(char[].class)) {
                    field.set(config, this.getEnvValue(field.get(config)));
                    continue;
                }
                if (field.getName().contains("this$")) continue;
                if (Map.class.isAssignableFrom(field.getType())) {
                    Map objectMap = (Map)field.get(config);
                    for (Map.Entry entry : objectMap.entrySet()) {
                        if (entry.getValue().getClass().isAssignableFrom(String.class) || entry.getValue().getClass().isAssignableFrom(char[].class)) {
                            field.set(config, this.getEnvValue(field.get(config)));
                            continue;
                        }
                        if (!entry.getValue().getClass().getPackageName().contains(packageName)) continue;
                        this.resolveConfigsWithEnvs(entry.getValue());
                    }
                    continue;
                }
                if (!field.getType().getPackageName().contains(packageName)) continue;
                this.resolveConfigsWithEnvs(field.get(config));
            }
            catch (IllegalAccessException e) {
                logger.error("Error while reading the config value : " + field.getName(), (Throwable)e);
            }
        }
    }

    private Object getEnvValue(Object configValue) {
        String value;
        if (configValue instanceof String) {
            String value2 = (String)configValue;
            if (value2.contains("$env{")) {
                String envName = value2.substring(value2.indexOf("{") + 1, value2.indexOf("}"));
                return System.getenv(envName);
            }
        } else if (configValue instanceof char[] && (value = String.valueOf((char[])configValue)).contains("$env{")) {
            String envName = value.substring(value.indexOf("{") + 1, value.indexOf("}"));
            return System.getenv(envName) != null ? (Object)System.getenv(envName).toCharArray() : configValue;
        }
        return configValue;
    }

    private void populateJWTIssuerConfigurations(JWTIssuer jwtIssuer) {
        JWTIssuerConfigurationDto jwtIssuerConfigurationDto = new JWTIssuerConfigurationDto();
        jwtIssuerConfigurationDto.setEnabled(jwtIssuer.getEnabled());
        jwtIssuerConfigurationDto.setIssuer(jwtIssuer.getIssuer());
        jwtIssuerConfigurationDto.setConsumerDialectUri(jwtIssuer.getClaimDialect());
        jwtIssuerConfigurationDto.setSignatureAlgorithm(jwtIssuer.getSigningAlgorithm());
        try {
            jwtIssuerConfigurationDto.setPrivateKey(JWTUtil.getPrivateKey(jwtIssuer.getPrivateKeyPath()));
            jwtIssuerConfigurationDto.setPublicCert(TLSUtils.getCertificate(jwtIssuer.getPublicCertificatePath()));
        }
        catch (IOException | CertificateException | MGWException e) {
            logger.error("Error in loading public cert or private key", (Throwable)e);
        }
        jwtIssuerConfigurationDto.setTtl(jwtIssuer.getValidityPeriod());
        CredentialDto[] credentialDtos = new CredentialDto[jwtIssuer.getJwtUsersList().size()];
        for (int index = 0; index < jwtIssuer.getJwtUsersList().size(); ++index) {
            CredentialDto credentialDto;
            credentialDtos[index] = credentialDto = new CredentialDto(jwtIssuer.getJwtUsers(index).getUsername(), jwtIssuer.getJwtUsers(index).getPassword().toCharArray());
        }
        this.config.setJwtUsersCredentials(credentialDtos);
        this.config.setJwtIssuerConfigurationDto(jwtIssuerConfigurationDto);
    }

    public EnforcerConfig getConfig() {
        return this.config;
    }

    public void setConfig(EnforcerConfig config) {
        this.config = config;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public KeyStore getTrustStoreForJWT() {
        return this.trustStoreForJWT;
    }

    public void setTrustStoreForJWT(KeyStore trustStoreForJWT) {
        this.trustStoreForJWT = trustStoreForJWT;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
    }

    public EnvVarConfig getEnvVarConfig() {
        return this.envVarConfig;
    }

    public ArrayList<ExtendedTokenIssuerDto> getConfigIssuerList() {
        return this.configIssuerList;
    }

    public void setConfigIssuerList(ArrayList<ExtendedTokenIssuerDto> configIssuerList) {
        this.configIssuerList = configIssuerList;
    }
}

