/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.constants;

public class APIConstants {
    public static final String X_WSO2_BASE_PATH = "x-wso2-basepath";
    public static final String GW_BASE_PATH_PARAM = "basePath";
    public static final String GW_RES_PATH_PARAM = "path";
    public static final String GW_RES_METHOD_PARAM = "method";
    public static final String GW_VERSION_PARAM = "version";
    public static final String GW_API_NAME_PARAM = "name";
    public static final String PROTOTYPED_LIFE_CYCLE_STATUS = "PROTOTYPED";
    public static final String GATEWAY_SIGNED_JWT_CACHE = "SignedJWTParseCache";
    public static final String GATEWAY_PUBLIC_CERTIFICATE_ALIAS = "wso2carbon";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String SUPER_TENANT_DOMAIN_NAME = "carbon.super";
    public static final String BANDWIDTH_TYPE = "bandwidthVolume";
    public static final String INTERNAL_WEB_APP_EP = "/internal/data/v1";
    public static final String AUTHORIZATION_HEADER_DEFAULT = "Authorization";
    public static final String AUTHORIZATION_BASIC = "Basic ";
    public static final String AUTHORIZATION_BEARER = "Bearer ";
    public static final String HEADER_TENANT = "xWSO2Tenant";
    public static final String DEFAULT_VERSION_PREFIX = "_default_";
    public static final String DEFAULT_WEBSOCKET_VERSION = "defaultVersion";
    public static final String DELEM_COLON = ":";
    public static final String API_KEY_TYPE_PRODUCTION = "PRODUCTION";
    public static final String API_KEY_TYPE_SANDBOX = "SANDBOX";
    public static final String BEGIN_CERTIFICATE_STRING = "-----BEGIN CERTIFICATE-----\n";
    public static final String END_CERTIFICATE_STRING = "-----END CERTIFICATE-----";
    public static final String BEGIN_PUBLIC_KEY_STRING = "-----BEGIN PUBLIC KEY-----\n";
    public static final String END_PUBLIC_KEY_STRING = "-----END PUBLIC KEY-----";
    public static final String OAUTH2_DEFAULT_SCOPE = "default";
    public static final String EVENT_TYPE = "eventType";
    public static final String EVENT_TIMESTAMP = "timestamp";
    public static final String EVENT_PAYLOAD = "event";
    public static final String NOT_FOUND_MESSAGE = "Not Found";
    public static final String NOT_FOUND_DESCRIPTION = "The requested resource is not available.";
    public static final String CONTENT_TYPE_HEADER = "Content-type";
    public static final String APPLICATION_JSON = "application/json";
    public static final String API_TRACE_KEY = "X-TRACE-KEY";

    public static enum StatusCodes {
        OK("200", 200),
        UNAUTHENTICATED("401", 401),
        UNAUTHORIZED("403", 403),
        NOTFOUND("404", 404),
        THROTTLED("429", 429);

        private String value;
        private int code;

        private StatusCodes(String value, int code) {
            this.value = value;
            this.code = code;
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class MessageFormat {
        public static final String STATUS_CODE = "status_code";
        public static final String ERROR_CODE = "code";
        public static final String ERROR_MESSAGE = "error_message";
        public static final String ERROR_DESCRIPTION = "error_description";
    }

    public static enum PolicyType {
        API,
        APPLICATION,
        SUBSCRIPTION;

    }

    public static enum EventType {
        API_CREATE,
        API_UPDATE,
        API_DELETE,
        API_LIFECYCLE_CHANGE,
        APPLICATION_CREATE,
        APPLICATION_UPDATE,
        APPLICATION_DELETE,
        APPLICATION_REGISTRATION_CREATE,
        POLICY_CREATE,
        POLICY_UPDATE,
        POLICY_DELETE,
        SUBSCRIPTIONS_CREATE,
        SUBSCRIPTIONS_UPDATE,
        SUBSCRIPTIONS_DELETE,
        SCOPE_CREATE,
        SCOPE_UPDATE,
        SCOPE_DELETE;

    }

    public static class SubscriptionValidationResources {
        public static final String APIS = "/apis";
        public static final String APPLICATIONS = "/applications";
        public static final String SUBSCRIPTIONS = "/subscriptions";
        public static final String SUBSCRIBERS = "/subscribers";
        public static final String APPLICATION_KEY_MAPPINGS = "/application-key-mappings";
        public static final String APPLICATION_POLICIES = "/application-policies";
        public static final String API_POLICIES = "/api-policies";
        public static final String SUBSCRIPTION_POLICIES = "/subscription-policies";

        private SubscriptionValidationResources() {
        }
    }

    public static class KeyManager {
        public static final String SERVICE_URL = "ServiceURL";
        public static final String INIT_DELAY = "InitDelay";
        public static final String INTROSPECTION_ENDPOINT = "introspection_endpoint";
        public static final String CLIENT_REGISTRATION_ENDPOINT = "client_registration_endpoint";
        public static final String KEY_MANAGER_OPERATIONS_DCR_ENDPOINT = "/keymanager-operations/dcr/register";
        public static final String KEY_MANAGER_OPERATIONS_USERINFO_ENDPOINT = "/keymanager-operations/user-info";
        public static final String TOKEN_ENDPOINT = "token_endpoint";
        public static final String REVOKE_ENDPOINT = "revoke_endpoint";
        public static final String WELL_KNOWN_ENDPOINT = "well_known_endpoint";
        public static final String SCOPE_MANAGEMENT_ENDPOINT = "scope_endpoint";
        public static final String AVAILABLE_GRANT_TYPE = "grant_types";
        public static final String ENABLE_TOKEN_GENERATION = "enable_token_generation";
        public static final String ENABLE_TOKEN_HASH = "enable_token_hash";
        public static final String ENABLE_TOKEN_ENCRYPTION = "enable_token_encryption";
        public static final String ENABLE_OAUTH_APP_CREATION = "enable_oauth_app_creation";
        public static final String DEFAULT_KEY_MANAGER = "Resident Key Manager";
        public static final String DEFAULT_KEY_MANAGER_TYPE = "default";
        public static final String DEFAULT_KEY_MANAGER_DESCRIPTION = "This is Resident Key Manager";
        public static final String ISSUER = "issuer";
        public static final String JWKS_ENDPOINT = "jwks_endpoint";
        public static final String USERINFO_ENDPOINT = "userinfo_endpoint";
        public static final String AUTHORIZE_ENDPOINT = "authorize_endpoint";
        public static final String EVENT_HUB_CONFIGURATIONS = "EventHubConfigurations";
        public static final String KEY_MANAGER = "KeyManager";
        public static final String APPLICATION_CONFIGURATIONS = "ApplicationConfigurations";
        public static final String EVENT_RECEIVER_CONFIGURATION = "EventReceiverConfiguration";
        public static final String ENABLE = "Enable";
        public static final String USERNAME = "Username";
        public static final String PASSWORD = "Password";
        public static final String SELF_VALIDATE_JWT = "self_validate_jwt";
        public static final String CLAIM_MAPPING = "claim_mappings";
        public static final String VALIDATION_TYPE = "validation_type";
        public static final String VALIDATION_JWT = "jwt";
        public static final String VALIDATION_REFERENCE = "reference";
        public static final String VALIDATION_CUSTOM = "custom";
        public static final String TOKEN_FORMAT_STRING = "token_format_string";
        public static final String ENABLE_TOKEN_VALIDATION = "validation_enable";
        public static final String VALIDATION_ENTRY_JWT_BODY = "body";
        public static final String API_LEVEL_ALL_KEY_MANAGERS = "all";
        public static final String REGISTERED_TENANT_DOMAIN = "tenantDomain";
        public static final String ENABLE_MAP_OAUTH_CONSUMER_APPS = "enable_map_oauth_consumer_apps";
        public static final String KEY_MANAGER_TYPE = "type";
        public static final String UUID_REGEX = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}";
        public static final String CONSUMER_KEY_CLAIM = "consumer_key_claim";
        public static final String SCOPES_CLAIM = "scopes_claim";
        public static final String CERTIFICATE_TYPE = "certificate_type";
        public static final String CERTIFICATE_VALUE = "certificate_value";
        public static final String CERTIFICATE_TYPE_JWKS_ENDPOINT = "JWKS";
        public static final String CERTIFICATE_TYPE_PEM_FILE = "PEM";
        public static final String EVENT_PUBLISHER_CONFIGURATIONS = "EventPublisherConfiguration";
        public static final String KEY_MANAGER_TYPE_HEADER = "X-WSO2-KEY-MANAGER";
        public static final String ACCESS_TOKEN = "accessToken";
        public static final String AUTH_CODE = "authCode";
        public static final String CLAIM_DIALECT = "dialect";
        public static final String DEFAULT_KEY_MANAGER_OPENID_CONNECT_DISCOVERY_ENDPOINT = "/oauth2/token/.well-known/openid-configuration";
        public static final String DEFAULT_JWKS_ENDPOINT = "/oauth2/jwks";
        public static final String PRODUCTION_TOKEN_ENDPOINT = "production_token_endpoint";
        public static final String SANDBOX_TOKEN_ENDPOINT = "sandbox_token_endpoint";
        public static final String PRODUCTION_REVOKE_ENDPOINT = "production_revoke_endpoint";
        public static final String SANDBOX_REVOKE_ENDPOINT = "sandbox_revoke_endpoint";
        public static final String APPLICATION_ACCESS_TOKEN_EXPIRY_TIME = "application_access_token_expiry_time";
        public static final String USER_ACCESS_TOKEN_EXPIRY_TIME = "user_access_token_expiry_time";
        public static final String REFRESH_TOKEN_EXPIRY_TIME = "refresh_token_expiry_time";
        public static final String ID_TOKEN_EXPIRY_TIME = "id_token_expiry_time";
        public static final String NOT_APPLICABLE_VALUE = "N/A";

        public static class KeyManagerEvent {
            public static final String EVENT_TYPE = "event_type";
            public static final String KEY_MANAGER_CONFIGURATION = "key_manager_configuration";
            public static final String ACTION = "action";
            public static final String NAME = "name";
            public static final String ENABLED = "enabled";
            public static final String VALUE = "value";
            public static final String TENANT_DOMAIN = "tenantDomain";
            public static final String ACTION_ADD = "add";
            public static final String ACTION_UPDATE = "update";
            public static final String ACTION_DELETE = "delete";
            public static final String TYPE = "type";
            public static final String KEY_MANAGER_STREAM_ID = "org.wso2.apimgt.keymgt.stream:1.0.0";
        }
    }

    public static class JwtTokenConstants {
        public static final String APPLICATION = "application";
        public static final String APPLICATION_ID = "id";
        public static final String APPLICATION_UUID = "uuid";
        public static final String APPLICATION_NAME = "name";
        public static final String APPLICATION_TIER = "tier";
        public static final String APPLICATION_OWNER = "owner";
        public static final String KEY_TYPE = "keytype";
        public static final String CONSUMER_KEY = "consumerKey";
        public static final String AUTHORIZED_PARTY = "azp";
        public static final String KEY_ID = "kid";
        public static final String JWT_ID = "jti";
        public static final String SUBSCRIPTION_TIER = "subscriptionTier";
        public static final String SUBSCRIBER_TENANT_DOMAIN = "subscriberTenantDomain";
        public static final String TIER_INFO = "tierInfo";
        public static final String STOP_ON_QUOTA_REACH = "stopOnQuotaReach";
        public static final String SPIKE_ARREST_LIMIT = "spikeArrestLimit";
        public static final String SPIKE_ARREST_UNIT = "spikeArrestUnit";
        public static final String SCOPE = "scope";
        public static final String SCOPE_DELIMITER = " ";
        public static final String ISSUED_TIME = "iat";
        public static final String EXPIRY_TIME = "exp";
        public static final String JWT_KID = "kid";
        public static final String SIGNATURE_ALGORITHM = "alg";
        public static final String TOKEN_TYPE = "typ";
        public static final String BACKEND_TOKEN = "backendJwt";
        public static final String SUBSCRIBED_APIS = "subscribedAPIs";
        public static final String API_CONTEXT = "context";
        public static final String API_VERSION = "version";
        public static final String API_PUBLISHER = "publisher";
        public static final String API_NAME = "name";
        public static final String QUOTA_TYPE = "tierQuotaType";
        public static final String QUOTA_TYPE_BANDWIDTH = "bandwidthVolume";
        public static final String PERMITTED_IP = "permittedIP";
        public static final String PERMITTED_REFERER = "permittedReferer";
        public static final String GRAPHQL_MAX_DEPTH = "graphQLMaxDepth";
        public static final String GRAPHQL_MAX_COMPLEXITY = "graphQLMaxComplexity";
    }

    public static class SubscriptionStatus {
        public static final String BLOCKED = "BLOCKED";
        public static final String PROD_ONLY_BLOCKED = "PROD_ONLY_BLOCKED";
        public static final String UNBLOCKED = "UNBLOCKED";
        public static final String ON_HOLD = "ON_HOLD";
        public static final String TIER_UPDATE_PENDING = "TIER_UPDATE_PENDING";
        public static final String REJECTED = "REJECTED";

        private SubscriptionStatus() {
        }
    }

    public static class KeyValidationStatus {
        public static final int API_AUTH_GENERAL_ERROR = 900900;
        public static final int API_AUTH_INVALID_CREDENTIALS = 900901;
        public static final int API_AUTH_INCORRECT_ACCESS_TOKEN_TYPE = 900905;
        public static final int API_BLOCKED = 900907;
        public static final int API_AUTH_RESOURCE_FORBIDDEN = 900908;
        public static final int SUBSCRIPTION_INACTIVE = 900909;
        public static final int INVALID_SCOPE = 900910;
        public static final int KEY_MANAGER_NOT_AVAILABLE = 900912;

        private KeyValidationStatus() {
        }
    }
}

