/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.discovery;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.api.Api;
import org.wso2.gateway.discovery.service.api.ApiDiscoveryServiceGrpc;
import org.wso2.micro.gateway.enforcer.api.APIFactory;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.exception.DiscoveryException;
import org.wso2.micro.gateway.enforcer.util.GRPCUtils;

public class ApiDiscoveryClient {
    private static ApiDiscoveryClient instance;
    private final ManagedChannel channel;
    private final ApiDiscoveryServiceGrpc.ApiDiscoveryServiceStub stub;
    private final ApiDiscoveryServiceGrpc.ApiDiscoveryServiceBlockingStub blockingStub;
    private static final Logger logger;
    private final APIFactory apiFactory;
    private StreamObserver<DiscoveryRequest> reqObserver;
    private static final Logger log;
    private DiscoveryResponse latestReceived;
    private DiscoveryResponse latestACKed;
    private final String nodeId;

    private ApiDiscoveryClient(String host, int port) {
        this.channel = GRPCUtils.createSecuredChannel(log, host, port);
        this.apiFactory = APIFactory.getInstance();
        this.stub = ApiDiscoveryServiceGrpc.newStub(this.channel);
        this.blockingStub = ApiDiscoveryServiceGrpc.newBlockingStub(this.channel);
        this.nodeId = ConfigHolder.getInstance().getEnvVarConfig().getEnforcerLabel();
        this.latestACKed = DiscoveryResponse.getDefaultInstance();
    }

    public static ApiDiscoveryClient getInstance() {
        if (instance == null) {
            String adsHost = ConfigHolder.getInstance().getEnvVarConfig().getAdapterHost();
            int adsPort = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getAdapterXdsPort());
            instance = new ApiDiscoveryClient(adsHost, adsPort);
        }
        return instance;
    }

    public List<Api> requestInitApis() throws DiscoveryException {
        List<Api> apis;
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setTypeUrl("type.googleapis.com/wso2.discovery.api.Api").build();
        try {
            DiscoveryResponse response = ((ApiDiscoveryServiceGrpc.ApiDiscoveryServiceBlockingStub)this.blockingStub.withDeadlineAfter(60L, TimeUnit.SECONDS)).fetchApis(req);
            this.shutdown();
            apis = this.handleResponse(response);
        }
        catch (Exception e) {
            throw new DiscoveryException("Couldn't fetch init APIs", e);
        }
        return apis;
    }

    public void watchApis() {
        int maxSize = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getXdsMaxMsgSize());
        this.reqObserver = ((ApiDiscoveryServiceGrpc.ApiDiscoveryServiceStub)this.stub.withMaxInboundMessageSize(maxSize)).streamApis(new StreamObserver<DiscoveryResponse>(){

            @Override
            public void onNext(DiscoveryResponse response) {
                logger.debug("Received API discovery response " + response);
                ApiDiscoveryClient.this.latestReceived = response;
                try {
                    List<Api> apis = ApiDiscoveryClient.this.handleResponse(response);
                    ApiDiscoveryClient.this.apiFactory.addApis(apis);
                    ApiDiscoveryClient.this.ack();
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.error("Error occurred during API discovery", throwable);
                ApiDiscoveryClient.this.nack(throwable);
            }

            @Override
            public void onCompleted() {
                logger.info("Completed receiving APIs");
            }
        });
        try {
            DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setTypeUrl("type.googleapis.com/wso2.discovery.api.Api").build();
            this.reqObserver.onNext(req);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in API discovery service", (Throwable)e);
            this.reqObserver.onError(e);
        }
    }

    private void ack() {
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestReceived.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.api.Api").build();
        this.reqObserver.onNext(req);
        this.latestACKed = this.latestReceived;
    }

    private void nack(Throwable e) {
        if (this.latestReceived == null) {
            return;
        }
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.api.Api").setErrorDetail(Status.newBuilder().setMessage(e.getMessage())).build();
        this.reqObserver.onNext(req);
    }

    private List<Api> handleResponse(DiscoveryResponse response) throws InvalidProtocolBufferException {
        ArrayList<Api> apis = new ArrayList<Api>();
        for (Any res : response.getResourcesList()) {
            apis.add(res.unpack(Api.class));
        }
        return apis;
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    static {
        logger = LogManager.getLogger(ApiDiscoveryClient.class);
        log = LogManager.getLogger(ApiDiscoveryClient.class);
    }
}

