/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.discovery;

import com.google.protobuf.Any;
import com.google.rpc.Status;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.service.subscription.ApplicationKeyMappingDiscoveryServiceGrpc;
import org.wso2.gateway.discovery.subscription.ApplicationKeyMapping;
import org.wso2.gateway.discovery.subscription.ApplicationKeyMappingList;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataStoreImpl;
import org.wso2.micro.gateway.enforcer.util.GRPCUtils;

public class ApplicationKeyMappingDiscoveryClient {
    private static final Logger logger = LogManager.getLogger(ApplicationKeyMappingDiscoveryClient.class);
    private static ApplicationKeyMappingDiscoveryClient instance;
    private final ManagedChannel channel;
    private final ApplicationKeyMappingDiscoveryServiceGrpc.ApplicationKeyMappingDiscoveryServiceStub stub;
    private StreamObserver<DiscoveryRequest> reqObserver;
    private SubscriptionDataStoreImpl subscriptionDataStore = SubscriptionDataStoreImpl.getInstance();
    private DiscoveryResponse latestReceived;
    private DiscoveryResponse latestACKed;
    private final String nodeId;

    private ApplicationKeyMappingDiscoveryClient(String host, int port) {
        this.channel = GRPCUtils.createSecuredChannel(logger, host, port);
        this.stub = ApplicationKeyMappingDiscoveryServiceGrpc.newStub(this.channel);
        this.nodeId = "commonEnforcerLabel";
        this.latestACKed = DiscoveryResponse.getDefaultInstance();
    }

    public static ApplicationKeyMappingDiscoveryClient getInstance() {
        if (instance == null) {
            String sdsHost = ConfigHolder.getInstance().getEnvVarConfig().getAdapterHost();
            int sdsPort = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getAdapterXdsPort());
            instance = new ApplicationKeyMappingDiscoveryClient(sdsHost, sdsPort);
        }
        return instance;
    }

    public void watchApplicationKeyMappings() {
        this.reqObserver = this.stub.streamApplicationKeyMappings(new StreamObserver<DiscoveryResponse>(){

            @Override
            public void onNext(DiscoveryResponse response) {
                logger.debug("Received Application Key Mapping discovery response " + response);
                ApplicationKeyMappingDiscoveryClient.this.latestReceived = response;
                try {
                    ArrayList<ApplicationKeyMapping> applicationKeyMappingLis = new ArrayList<ApplicationKeyMapping>();
                    for (Any res : response.getResourcesList()) {
                        applicationKeyMappingLis.addAll(res.unpack(ApplicationKeyMappingList.class).getListList());
                    }
                    ApplicationKeyMappingDiscoveryClient.this.subscriptionDataStore.addApplicationKeyMappings(applicationKeyMappingLis);
                    ApplicationKeyMappingDiscoveryClient.this.ack();
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.error("Error occurred during SubApplication Key Mappingscription discovery", throwable);
                ApplicationKeyMappingDiscoveryClient.this.nack(throwable);
            }

            @Override
            public void onCompleted() {
                logger.info("Completed receiving Application Key Mapping data");
            }
        });
        try {
            DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.ApplicationKeyMappingList").build();
            this.reqObserver.onNext(req);
            logger.debug("Sent Discovery request for type url: type.googleapis.com/wso2.discovery.subscription.ApplicationKeyMappingList");
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in Application Key Mapping discovery service", (Throwable)e);
            this.reqObserver.onError(e);
        }
    }

    private void ack() {
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestReceived.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.ApplicationKeyMappingList").build();
        this.reqObserver.onNext(req);
        this.latestACKed = this.latestReceived;
    }

    private void nack(Throwable e) {
        if (this.latestReceived == null) {
            return;
        }
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.ApplicationKeyMappingList").setErrorDetail(Status.newBuilder().setMessage(e.getMessage())).build();
        this.reqObserver.onNext(req);
    }
}

