/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.discovery;

import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.File;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.config.enforcer.Config;
import org.wso2.gateway.discovery.service.config.ConfigDiscoveryServiceGrpc;
import org.wso2.micro.gateway.enforcer.config.EnvVarConfig;
import org.wso2.micro.gateway.enforcer.exception.DiscoveryException;

public class ConfigDiscoveryClient {
    private static final Logger log = LogManager.getLogger(ConfigDiscoveryClient.class);
    private final ManagedChannel channel;
    private final ConfigDiscoveryServiceGrpc.ConfigDiscoveryServiceBlockingStub blockingStub;
    private String nodeId;

    public ConfigDiscoveryClient(EnvVarConfig envVarConfig, TrustManagerFactory trustManagerFactory) {
        File certFile = Paths.get(envVarConfig.getEnforcerPublicKeyPath(), new String[0]).toFile();
        File keyFile = Paths.get(envVarConfig.getEnforcerPrivateKeyPath(), new String[0]).toFile();
        SslContext sslContext = null;
        try {
            sslContext = GrpcSslContexts.forClient().trustManager(trustManagerFactory).keyManager(certFile, keyFile).build();
        }
        catch (SSLException e) {
            log.error("Error while generating SSL Context.", (Throwable)e);
        }
        this.channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress(envVarConfig.getAdapterHost(), Integer.parseInt(envVarConfig.getAdapterXdsPort())).useTransportSecurity().sslContext(sslContext).overrideAuthority(envVarConfig.getAdapterHostName())).build();
        this.blockingStub = ConfigDiscoveryServiceGrpc.newBlockingStub(this.channel);
        this.nodeId = "commonEnforcerLabel";
    }

    public Config requestInitConfig() throws DiscoveryException {
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setTypeUrl("type.googleapis.com/wso2.discovery.config.enforcer.Config").build();
        DiscoveryResponse res = DiscoveryResponse.getDefaultInstance();
        try {
            res = this.requestConfig(req);
            return res.getResources(0).unpack(Config.class);
        }
        catch (Exception e) {
            throw new DiscoveryException("Couldn't fetch init configs", e);
        }
    }

    private DiscoveryResponse requestConfig(DiscoveryRequest req) throws DiscoveryException {
        Exception e = new Exception();
        for (int retries = 0; retries < 3; ++retries) {
            try {
                DiscoveryResponse res = ((ConfigDiscoveryServiceGrpc.ConfigDiscoveryServiceBlockingStub)this.blockingStub.withDeadlineAfter(10L, TimeUnit.SECONDS)).fetchConfigs(req);
                this.shutdown();
                return res;
            }
            catch (Exception ex) {
                e = ex;
                continue;
            }
        }
        throw new DiscoveryException("Failed 3 retries", e);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }
}

