/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.discovery;

import com.google.protobuf.Any;
import com.google.rpc.Status;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.service.subscription.SubscriptionPolicyDiscoveryServiceGrpc;
import org.wso2.gateway.discovery.subscription.SubscriptionPolicy;
import org.wso2.gateway.discovery.subscription.SubscriptionPolicyList;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataStoreImpl;
import org.wso2.micro.gateway.enforcer.util.GRPCUtils;

public class SubscriptionPolicyDiscoveryClient {
    private static final Logger logger = LogManager.getLogger(SubscriptionPolicyDiscoveryClient.class);
    private static SubscriptionPolicyDiscoveryClient instance;
    private final ManagedChannel channel;
    private final SubscriptionPolicyDiscoveryServiceGrpc.SubscriptionPolicyDiscoveryServiceStub stub;
    private StreamObserver<DiscoveryRequest> reqObserver;
    private SubscriptionDataStoreImpl subscriptionDataStore = SubscriptionDataStoreImpl.getInstance();
    private DiscoveryResponse latestReceived;
    private DiscoveryResponse latestACKed;
    private final String nodeId;

    private SubscriptionPolicyDiscoveryClient(String host, int port) {
        this.channel = GRPCUtils.createSecuredChannel(logger, host, port);
        this.stub = SubscriptionPolicyDiscoveryServiceGrpc.newStub(this.channel);
        this.nodeId = "commonEnforcerLabel";
        this.latestACKed = DiscoveryResponse.getDefaultInstance();
    }

    public static SubscriptionPolicyDiscoveryClient getInstance() {
        if (instance == null) {
            String sdsHost = ConfigHolder.getInstance().getEnvVarConfig().getAdapterHost();
            int sdsPort = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getAdapterXdsPort());
            instance = new SubscriptionPolicyDiscoveryClient(sdsHost, sdsPort);
        }
        return instance;
    }

    public void watchSubscriptionPolicies() {
        this.reqObserver = this.stub.streamSubscriptionPolicies(new StreamObserver<DiscoveryResponse>(){

            @Override
            public void onNext(DiscoveryResponse response) {
                logger.debug("Received Application discovery response " + response);
                SubscriptionPolicyDiscoveryClient.this.latestReceived = response;
                try {
                    ArrayList<SubscriptionPolicy> subscriptionPolicyList = new ArrayList<SubscriptionPolicy>();
                    for (Any res : response.getResourcesList()) {
                        subscriptionPolicyList.addAll(res.unpack(SubscriptionPolicyList.class).getListList());
                    }
                    SubscriptionPolicyDiscoveryClient.this.subscriptionDataStore.addSubscriptionPolicies(subscriptionPolicyList);
                    SubscriptionPolicyDiscoveryClient.this.ack();
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.error("Error occurred during Subscription discovery", throwable);
                SubscriptionPolicyDiscoveryClient.this.nack(throwable);
            }

            @Override
            public void onCompleted() {
                logger.info("Completed receiving Subscription data");
            }
        });
        try {
            DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.SubscriptionPolicyList").build();
            this.reqObserver.onNext(req);
            logger.debug("Sent Discovery request for type url: type.googleapis.com/wso2.discovery.subscription.SubscriptionPolicyList");
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in API discovery service", (Throwable)e);
            this.reqObserver.onError(e);
        }
    }

    private void ack() {
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestReceived.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.SubscriptionPolicyList").build();
        this.reqObserver.onNext(req);
        this.latestACKed = this.latestReceived;
    }

    private void nack(Throwable e) {
        if (this.latestReceived == null) {
            return;
        }
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.SubscriptionPolicyList").setErrorDetail(Status.newBuilder().setMessage(e.getMessage())).build();
        this.reqObserver.onNext(req);
    }
}

