/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.grpc.interceptors;

import io.envoyproxy.envoy.service.auth.v3.CheckRequest;
import io.envoyproxy.envoy.service.auth.v3.CheckResponse;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccessLogInterceptor
implements ServerInterceptor {
    private static final Logger logger = LogManager.getLogger(AccessLogInterceptor.class);

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        if (logger.isDebugEnabled()) {
            final EnforcerServerCall<ReqT, RespT> enforcerServerCall = new EnforcerServerCall<ReqT, RespT>(serverCall);
            ServerCall.Listener<ReqT> listener = serverCallHandler.startCall(enforcerServerCall, metadata);
            return new EnforcerForwardingServerCallListener<ReqT>(serverCall.getMethodDescriptor(), listener){

                @Override
                public void onMessage(ReqT message) {
                    if (message instanceof CheckRequest) {
                        CheckRequest checkRequest = (CheckRequest)message;
                        enforcerServerCall.setStartTime(System.currentTimeMillis());
                        enforcerServerCall.setTraceId(checkRequest.getAttributes().getRequest().getHttp().getId());
                        super.onMessage(message);
                    }
                }
            };
        }
        return serverCallHandler.startCall(serverCall, metadata);
    }

    private class EnforcerForwardingServerCallListener<M>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<M> {
        String methodName;

        protected EnforcerForwardingServerCallListener(MethodDescriptor method, ServerCall.Listener<M> listener) {
            super(listener);
            this.methodName = method.getFullMethodName();
        }
    }

    private class EnforcerServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        ServerCall<ReqT, RespT> serverCall;
        long startTime;
        String traceId;

        protected EnforcerServerCall(ServerCall<ReqT, RespT> serverCall) {
            super(serverCall);
            this.serverCall = serverCall;
        }

        @Override
        public void sendMessage(RespT message) {
            this.serverCall.sendMessage(message);
            if (message instanceof CheckResponse) {
                long responseTimeMillis = System.currentTimeMillis() - this.startTime;
                CheckResponse checkResponse = (CheckResponse)message;
                logger.info(String.format("%s %s %d %d", this.traceId, this.serverCall.getMethodDescriptor().getFullMethodName(), checkResponse.getStatus().getCode(), responseTimeMillis));
            }
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }
    }
}

