/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wso2.micro.gateway.enforcer.Filter;
import org.wso2.micro.gateway.enforcer.api.RequestContext;
import org.wso2.micro.gateway.enforcer.api.config.APIConfig;
import org.wso2.micro.gateway.enforcer.constants.APIConstants;
import org.wso2.micro.gateway.enforcer.exception.APISecurityException;
import org.wso2.micro.gateway.enforcer.security.AuthenticationContext;
import org.wso2.micro.gateway.enforcer.security.Authenticator;
import org.wso2.micro.gateway.enforcer.security.jwt.JWTAuthenticator;
import org.wso2.micro.gateway.enforcer.util.FilterUtils;

public class AuthFilter
implements Filter {
    private List<Authenticator> authenticators = new ArrayList<Authenticator>();

    @Override
    public void init(APIConfig apiConfig) {
        JWTAuthenticator jwtAuthenticator = new JWTAuthenticator();
        this.authenticators.add(jwtAuthenticator);
    }

    @Override
    public boolean handleRequest(RequestContext requestContext) {
        try {
            for (Authenticator authenticator : this.authenticators) {
                AuthenticationContext authenticate;
                if (!authenticator.canAuthenticate(requestContext) || !(authenticate = authenticator.authenticate(requestContext)).isAuthenticated()) continue;
                this.updateClusterHeaderAndCheckEnv(requestContext, authenticate);
                return true;
            }
        }
        catch (APISecurityException e) {
            FilterUtils.setErrorToContext(requestContext, e);
            return false;
        }
        FilterUtils.setUnauthenticatedErrorToContext(requestContext);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateClusterHeaderAndCheckEnv(RequestContext requestContext, AuthenticationContext authContext) throws APISecurityException {
        String keyType = authContext.getKeyType();
        if (StringUtils.isEmpty(authContext.getKeyType())) {
            keyType = "PRODUCTION";
        }
        if (requestContext.isClusterHeaderEnabled()) {
            if (keyType.equalsIgnoreCase("PRODUCTION")) {
                requestContext.addResponseHeaders("x-wso2-cluster-header", requestContext.getProdClusterHeader());
                return;
            }
            if (keyType.equalsIgnoreCase("SANDBOX")) {
                requestContext.addResponseHeaders("x-wso2-cluster-header", requestContext.getSandClusterHeader());
                return;
            }
            if (keyType.equalsIgnoreCase("PRODUCTION")) {
                throw new APISecurityException(APIConstants.StatusCodes.UNAUTHENTICATED.getCode(), 900901, "Production key offered to the API with no production endpoint");
            }
            if (!keyType.equalsIgnoreCase("SANDBOX")) throw new APISecurityException(APIConstants.StatusCodes.UNAUTHENTICATED.getCode(), 900901, "Invalid key type.");
            throw new APISecurityException(APIConstants.StatusCodes.UNAUTHENTICATED.getCode(), 900901, "Sandbox key offered to the API with no sandbox endpoint");
        }
        if (keyType.equalsIgnoreCase("PRODUCTION") && StringUtils.isEmpty(requestContext.getProdClusterHeader())) {
            throw new APISecurityException(APIConstants.StatusCodes.UNAUTHENTICATED.getCode(), 900901, "Production key offered to the API with no production endpoint");
        }
        if (!keyType.equalsIgnoreCase("SANDBOX")) return;
        if (!StringUtils.isEmpty(requestContext.getSandClusterHeader())) return;
        throw new APISecurityException(APIConstants.StatusCodes.UNAUTHENTICATED.getCode(), 900901, "Sandbox key offered to the API with no sandbox endpoint");
    }
}

