/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security.jwt.issuer;

import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.SimpleChannelInboundHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObject;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.config.dto.CredentialDto;
import org.wso2.micro.gateway.enforcer.dto.APIKeyValidationInfoDTO;
import org.wso2.micro.gateway.enforcer.security.TokenValidationContext;
import org.wso2.micro.gateway.enforcer.security.jwt.issuer.JWTIssuerImpl;
import org.wso2.micro.gateway.enforcer.security.jwt.issuer.TokenIssuer;

public class HttpTokenServerHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final String CONTENT_LENGTH = "content-length";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String CONNECTION = "Connection";
    private static final String CLOSE = "close";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC_VALUE = "Basic";
    private static final String BASIC_LOWER = "basic";
    private static TokenIssuer tokenIssuer;
    private static String username;
    private static boolean isAuthorized;
    private static final Logger logger;

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        HttpMessage response = null;
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            boolean keepAlive = HttpUtil.isKeepAlive(req);
            String authHeader = req.headers().get(AUTHORIZATION);
            if (authHeader == null) {
                isAuthorized = false;
                String error = "User is NOT authorized to generate a token. Please provide a valid Authorization header to continue.";
                response = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer(error.getBytes()));
                response.headers().set(CONTENT_TYPE, (Object)TEXT_PLAIN);
                logger.error("User is NOT authorized to generate a token.");
            } else if (authHeader.toLowerCase().startsWith(BASIC_LOWER)) {
                String error;
                try {
                    CredentialDto[] predefinedCredentials;
                    String base64Credentials = authHeader.substring(BASIC_VALUE.length()).trim();
                    byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
                    String credentials = new String(credDecoded, StandardCharsets.UTF_8);
                    String[] values = credentials.split(":", 2);
                    for (CredentialDto cred : predefinedCredentials = ConfigHolder.getInstance().getConfig().getJwtUsersCredentials()) {
                        if (values[0].equals(cred.getUsername()) && values[1].equals(new String(cred.getPwd()))) {
                            username = values[0];
                            isAuthorized = true;
                            continue;
                        }
                        isAuthorized = false;
                        String error2 = "Wrong username or password. Please provide valid credentials.";
                        response = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer(error2.getBytes()));
                        response.headers().set(CONTENT_TYPE, (Object)TEXT_PLAIN);
                        logger.error("Wrong username or password.");
                    }
                }
                catch (IllegalArgumentException e) {
                    error = "Error occurred while processing the request.";
                    response = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer(error.getBytes()));
                    response.headers().set(CONTENT_TYPE, (Object)TEXT_PLAIN);
                    logger.error("Error occurred while processing the request.");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    error = "Error occurred while processing the request.";
                    response = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer(error.getBytes()));
                    response.headers().set(CONTENT_TYPE, (Object)TEXT_PLAIN);
                    logger.error("Error occurred while processing the request.");
                }
            }
            if (isAuthorized) {
                tokenIssuer = new JWTIssuerImpl();
                TokenValidationContext validationContext = new TokenValidationContext();
                validationContext.setValidationInfoDTO(new APIKeyValidationInfoDTO());
                validationContext.getValidationInfoDTO().setEndUserName(username);
                String jwt = tokenIssuer.generateToken(validationContext);
                response = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer(jwt.getBytes()));
                response.headers().set(CONTENT_TYPE, (Object)TEXT_PLAIN).setInt(CONTENT_LENGTH, response.content().readableBytes());
            }
            if (keepAlive) {
                if (!req.protocolVersion().isKeepAliveDefault()) {
                    response.headers().set(CONNECTION, (Object)KEEP_ALIVE);
                }
            } else {
                response.headers().set(CONNECTION, (Object)CLOSE);
            }
            ChannelFuture f = ctx.write(response);
            if (!keepAlive) {
                f.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error(cause);
        ctx.close();
    }

    static {
        username = null;
        isAuthorized = false;
        logger = LogManager.getLogger(HttpTokenServerHandler.class);
    }
}

