/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security.jwt.issuer;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.micro.gateway.enforcer.security.TokenValidationContext;
import org.wso2.micro.gateway.enforcer.security.jwt.issuer.AbstractJWTIssuer;

public class JWTIssuerImpl
extends AbstractJWTIssuer {
    private static final Log log = LogFactory.getLog(JWTIssuerImpl.class);
    private static final String KEY_TYPE = "PRODUCTION";
    private static final String AUD_VALUE = "http://org.wso2.apimgt/gateway";

    @Override
    public Map<String, String> populateStandardClaims(TokenValidationContext validationContext) throws JWTGeneratorException {
        long currentTime = System.currentTimeMillis();
        long expireIn = currentTime + this.jwtIssuerConfigurationDto.getTtl() * 1000L;
        LinkedHashMap<String, String> claims = new LinkedHashMap<String, String>(20);
        Object dialect = this.getDialectURI();
        if (!"".equals(dialect) && !"/".equals(dialect)) {
            dialect = (String)dialect + "/";
        }
        claims.put("iss", this.jwtIssuerConfigurationDto.getIssuer());
        claims.put("exp", String.valueOf(expireIn));
        claims.put("iat", String.valueOf(currentTime));
        claims.put("aud", AUD_VALUE);
        claims.put((String)dialect + "keytype", KEY_TYPE);
        String endUserName = validationContext.getValidationInfoDTO().getEndUserName();
        if (StringUtils.isNotEmpty(endUserName)) {
            claims.put((String)dialect + "sub", endUserName);
        }
        return claims;
    }
}

