/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security.jwt.validator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.discovery.RevokedTokenDiscoveryClient;

public class RevokedJWTDataHolder {
    private static final Logger log = LogManager.getLogger(RevokedJWTDataHolder.class);
    private static Map<String, Long> revokedJWTMap = new ConcurrentHashMap<String, Long>();
    private static RevokedJWTDataHolder instance = new RevokedJWTDataHolder();

    public void init() {
        if (ConfigHolder.getInstance().getConfig().getEventHub().isEnabled()) {
            RevokedTokenDiscoveryClient revokedTokenDs = RevokedTokenDiscoveryClient.getInstance();
            revokedTokenDs.watchRevokedTokens();
        }
    }

    public void addRevokedJWTToMap(String key, Long value) {
        if (key != null && value != null) {
            log.debug("Adding revoked JWT key, value pair to the revoked map :" + key + " , " + value);
            revokedJWTMap.put(key, value);
        }
    }

    public static boolean isJWTTokenSignatureExistsInRevokedMap(String jwtSignature) {
        return revokedJWTMap.containsKey(jwtSignature);
    }

    private RevokedJWTDataHolder() {
    }

    Map<String, Long> getRevokedJWTMap() {
        return revokedJWTMap;
    }

    public static RevokedJWTDataHolder getInstance() {
        return instance;
    }
}

