/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security.oauth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.micro.gateway.enforcer.api.RequestContext;
import org.wso2.micro.gateway.enforcer.security.AccessTokenInfo;
import org.wso2.micro.gateway.enforcer.security.AuthenticationContext;
import org.wso2.micro.gateway.enforcer.security.Authenticator;
import org.wso2.micro.gateway.enforcer.security.jwt.validator.JWTValidator;
import org.wso2.micro.gateway.enforcer.security.oauth.IntrospectInfo;

public class OAuthAuthenticator
implements Authenticator {
    private static final Log log = LogFactory.getLog(OAuthAuthenticator.class);
    private List<String> keyManagerList;
    protected JWTValidator jwtValidator;
    private String kmEndpoint = "https://localhost:9443/oauth2";
    private String securityHeader = "Authorization";
    private String defaultAPIHeader = "WSO2_AM_API_DEFAULT_VERSION";
    private String consumerKeyHeaderSegment = "Bearer";
    private String oauthHeaderSplitter = ",";
    private String consumerKeySegmentDelimiter = " ";
    private String securityContextHeader;
    private boolean removeOAuthHeadersFromOutMessage = true;
    private boolean removeDefaultAPIHeaderFromOutMessage = true;
    private String clientDomainHeader = "referer";
    private String requestOrigin;
    private String remainingAuthHeader;
    private boolean isMandatory;

    public OAuthAuthenticator() {
    }

    public OAuthAuthenticator(String authorizationHeader, boolean isMandatory, boolean removeOAuthHeader, List<String> keyManagerList) {
        this.securityHeader = authorizationHeader;
        this.removeOAuthHeadersFromOutMessage = removeOAuthHeader;
        this.isMandatory = isMandatory;
        this.keyManagerList = keyManagerList;
    }

    @Override
    public boolean canAuthenticate(RequestContext requestContext) {
        String token = requestContext.getHeaders().get("authorization");
        return !token.contains("\\.");
    }

    @Override
    public AuthenticationContext authenticate(RequestContext requestContext) {
        String token = requestContext.getHeaders().get("authorization");
        AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
        if (token.toLowerCase().contains("bearer")) {
            token = token.split("\\s")[1];
        }
        try {
            IntrospectInfo introspectInfo = this.validateToken(token);
            accessTokenInfo.setAccessToken(token);
            accessTokenInfo.setConsumerKey(introspectInfo.getClientId());
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
        return new AuthenticationContext();
    }

    public String extractCustomerKeyFromAuthHeader(Map headersMap) {
        String authHeader = (String)headersMap.get(this.securityHeader);
        if (authHeader == null) {
            if (log.isDebugEnabled()) {
                log.debug("OAuth2 Authentication: Expected authorization header with the name '".concat(this.securityHeader).concat("' was not found."));
            }
            return null;
        }
        ArrayList<String> remainingAuthHeaders = new ArrayList<String>();
        String consumerKey = null;
        boolean consumerkeyFound = false;
        String[] headers = authHeader.split(this.oauthHeaderSplitter);
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                String[] elements = headers[i].split(this.consumerKeySegmentDelimiter);
                if (elements != null && elements.length > 1) {
                    int j = 0;
                    boolean isConsumerKeyHeaderAvailable = false;
                    for (String element : elements) {
                        if (!"".equals(element.trim())) {
                            if (this.consumerKeyHeaderSegment.equals(elements[j].trim())) {
                                isConsumerKeyHeaderAvailable = true;
                            } else if (isConsumerKeyHeaderAvailable) {
                                consumerKey = this.removeLeadingAndTrailing(elements[j].trim());
                                consumerkeyFound = true;
                            }
                        }
                        ++j;
                    }
                }
                if (!consumerkeyFound) {
                    remainingAuthHeaders.add(headers[i]);
                    continue;
                }
                consumerkeyFound = false;
            }
        }
        this.remainingAuthHeader = String.join((CharSequence)this.oauthHeaderSplitter, remainingAuthHeaders);
        return consumerKey;
    }

    private String removeLeadingAndTrailing(String base) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return result.trim();
    }

    public String getChallengeString() {
        return "Bearer realm=\"WSO2 API Manager\"";
    }

    /*
     * Exception decompiling
     */
    private IntrospectInfo validateToken(String accessToken) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

