/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleCondition;

public class ThrottleDataHolder {
    private static final Log log = LogFactory.getLog(ThrottleDataHolder.class);
    private final Map<String, Long> throttleDataMap;
    private static ThrottleDataHolder instance;
    private final Map<String, Map<String, List<ThrottleCondition>>> conditionDtoMap = new ConcurrentHashMap<String, Map<String, List<ThrottleCondition>>>();

    private ThrottleDataHolder() {
        this.throttleDataMap = new ConcurrentHashMap<String, Long>();
    }

    public static ThrottleDataHolder getInstance() {
        if (instance == null) {
            instance = new ThrottleDataHolder();
        }
        return instance;
    }

    public void addThrottledConditions(String key, String conditionKey, List<ThrottleCondition> conditionValue) {
        Map<Object, Object> conditionMap;
        if (this.conditionDtoMap.containsKey(key)) {
            conditionMap = this.conditionDtoMap.get(key);
        } else {
            conditionMap = new ConcurrentHashMap();
            this.conditionDtoMap.put(key, conditionMap);
        }
        if (!conditionMap.containsKey(conditionKey)) {
            conditionMap.put(conditionKey, conditionValue);
        }
    }

    public void removeThrottledConditions(String key, String conditionKey) {
        if (this.conditionDtoMap.containsKey(key)) {
            Map<String, List<ThrottleCondition>> conditionMap = this.conditionDtoMap.get(key);
            conditionMap.remove(conditionKey);
            if (conditionMap.isEmpty()) {
                this.conditionDtoMap.remove(key);
            }
        }
    }

    public void addThrottleData(String key, Long timestamp) {
        this.throttleDataMap.put(key, timestamp);
    }

    public void removeThrottleData(String key) {
        this.throttleDataMap.remove(key);
    }

    public boolean isThrottled(String key) {
        boolean isThrottled = this.throttleDataMap.containsKey(key);
        if (isThrottled) {
            long currentTime = System.currentTimeMillis();
            long timestamp = this.throttleDataMap.get(key);
            if (timestamp < currentTime) {
                this.throttleDataMap.remove(key);
                isThrottled = false;
            }
        }
        return isThrottled;
    }
}

