/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.config.dto.ThrottleConfigDto;
import org.wso2.micro.gateway.enforcer.throttle.APICondition;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleCondition;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleDataHolder;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleUtils;

public class ThrottleEventListener
implements MessageListener {
    private static final Logger log = LogManager.getLogger(ThrottleEventListener.class);
    private final Pattern apiPattern = Pattern.compile("/.*/(.*):\\1_(condition_(\\d*)|default)");
    private static final int API_PATTERN_GROUPS = 3;
    private static final int API_PATTERN_CONDITION_INDEX = 2;
    private final Pattern resourcePattern = Pattern.compile("/.*/(.*)/\\1(.*)?:[A-Z]{0,7}_(condition_(\\d*)|default)");
    public static final int RESOURCE_PATTERN_GROUPS = 4;
    public static final int RESOURCE_PATTERN_CONDITION_INDEX = 3;

    private ThrottleEventListener() {
    }

    public static void init() {
        ThrottleConfigDto throttleConf = ConfigHolder.getInstance().getConfig().getThrottleConfig();
        String initialContextFactory = throttleConf.getJmsConnectionInitialContextFactory();
        String connectionFactoryNamePrefix = "connectionfactory.";
        String connectionFactoryName = "qpidConnectionfactory";
        String eventReceiverURL = throttleConf.getJmsConnectionProviderUrl();
        Runnable runnable = () -> {
            try {
                Properties properties = new Properties();
                properties.put("java.naming.factory.initial", initialContextFactory);
                properties.put(connectionFactoryNamePrefix + connectionFactoryName, eventReceiverURL);
                InitialContext context = new InitialContext(properties);
                TopicConnectionFactory connFactory = (TopicConnectionFactory)context.lookup(connectionFactoryName);
                TopicConnection topicConnection = connFactory.createTopicConnection();
                topicConnection.start();
                TopicSession topicSession = topicConnection.createTopicSession(false, 1);
                Topic gatewayJmsTopic = topicSession.createTopic("throttleData");
                TopicSubscriber listener = topicSession.createSubscriber(gatewayJmsTopic);
                listener.setMessageListener(new ThrottleEventListener());
            }
            catch (JMSException | NamingException e) {
                log.error("Error while initiating jms connection...", (Throwable)e);
            }
        };
        Thread jmsThread = new Thread(runnable);
        jmsThread.start();
    }

    @Override
    public void onMessage(Message message) {
        if (message == null) {
            log.warn("Dropping the empty/null event received through jms receiver");
            return;
        }
        if (!(message instanceof MapMessage)) {
            log.warn("Event dropped due to unsupported message type " + message.getClass());
            return;
        }
        try {
            Topic jmsDestination = (Topic)message.getJMSDestination();
            MapMessage mapMessage = (MapMessage)message;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration enumeration = mapMessage.getMapNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                map.put(key, mapMessage.getObject(key));
            }
            if ("throttleData".equalsIgnoreCase(jmsDestination.getTopicName()) && map.get("throttleKey") != null) {
                this.handleThrottleUpdateMessage(map);
            }
        }
        catch (JMSException e) {
            log.error("Error occurred when processing the received message ", (Throwable)e);
        }
    }

    private void handleThrottleUpdateMessage(Map<String, Object> map) {
        String throttleKey = map.get("throttleKey").toString();
        String throttleState = map.get("isThrottled").toString();
        long timeStamp = Long.parseLong(map.get("expiryTimeStamp").toString());
        Object evaluatedConditionObject = map.get("evaluatedConditions");
        ThrottleDataHolder dataHolder = ThrottleDataHolder.getInstance();
        if (log.isDebugEnabled()) {
            log.debug("Received event -  throttleKey : " + throttleKey + ", isThrottled: " + throttleState + ", expiryTime: " + new Date(timeStamp).toString());
        }
        if ("true".equalsIgnoreCase(throttleState)) {
            dataHolder.addThrottleData(throttleKey, timeStamp);
            APICondition extractedKey = this.extractAPIorResourceKey(throttleKey);
            log.debug("Adding throttling key : {}", (Object)extractedKey);
            if (extractedKey != null && evaluatedConditionObject != null) {
                String conditionStr = (String)evaluatedConditionObject;
                List<ThrottleCondition> conditions = ThrottleUtils.extractThrottleCondition(conditionStr);
                dataHolder.addThrottledConditions(extractedKey.getResourceKey(), extractedKey.getName(), conditions);
            }
        } else {
            dataHolder.removeThrottleData(throttleKey);
            APICondition extractedKey = this.extractAPIorResourceKey(throttleKey);
            if (extractedKey != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing throttling key : " + extractedKey.getResourceKey());
                }
                dataHolder.removeThrottledConditions(extractedKey.getResourceKey(), extractedKey.getName());
            }
        }
    }

    private APICondition extractAPIorResourceKey(String throttleKey) {
        Matcher m3 = this.resourcePattern.matcher(throttleKey);
        if (m3.matches()) {
            if (m3.groupCount() == 4) {
                String condition = m3.group(3);
                String resourceKey = throttleKey.substring(0, throttleKey.indexOf("_" + condition));
                return new APICondition(resourceKey, condition);
            }
        } else {
            m3 = this.apiPattern.matcher(throttleKey);
            if (m3.matches() && m3.groupCount() == 3) {
                String condition = m3.group(2);
                String resourceKey = throttleKey.substring(0, throttleKey.indexOf("_" + condition));
                return new APICondition(resourceKey, condition);
            }
        }
        return null;
    }
}

