/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleCondition;

public class ThrottleUtils {
    public static List<ThrottleCondition> extractThrottleCondition(String base64EncodedString) {
        ArrayList<ThrottleCondition> conditionDtoList = new ArrayList<ThrottleCondition>();
        String base64Decoded = new String(Base64.decodeBase64(base64EncodedString));
        JSONTokener tokener = new JSONTokener(base64Decoded);
        JSONArray conditionJsonArray = new JSONArray(tokener);
        for (Object conditionJson : conditionJsonArray) {
            ThrottleCondition.IPCondition ipCondition;
            ThrottleCondition conditionDto = new ThrottleCondition();
            JSONObject conditionJsonObject = (JSONObject)conditionJson;
            if (conditionJsonObject.has("IPSpecific".toLowerCase())) {
                JSONObject ipSpecificCondition = (JSONObject)conditionJsonObject.get("IPSpecific".toLowerCase());
                ipCondition = new Gson().fromJson(ipSpecificCondition.toString(), ThrottleCondition.IPCondition.class);
                conditionDto.setIpCondition(ipCondition);
            } else if (conditionJsonObject.has("IPRange".toLowerCase())) {
                JSONObject ipRangeCondition = (JSONObject)conditionJsonObject.get("IPRange".toLowerCase());
                ipCondition = new Gson().fromJson(ipRangeCondition.toString(), ThrottleCondition.IPCondition.class);
                conditionDto.setIpRangeCondition(ipCondition);
            }
            if (conditionJsonObject.has("JWTClaims".toLowerCase())) {
                JSONObject jwtClaimConditions = (JSONObject)conditionJsonObject.get("JWTClaims".toLowerCase());
                ThrottleCondition.JWTClaimConditions jwtClaimCondition = new Gson().fromJson(jwtClaimConditions.toString(), ThrottleCondition.JWTClaimConditions.class);
                conditionDto.setJwtClaimConditions(jwtClaimCondition);
            }
            if (conditionJsonObject.has("Header".toLowerCase())) {
                JSONObject headerConditionJson = (JSONObject)conditionJsonObject.get("Header".toLowerCase());
                ThrottleCondition.HeaderConditions headerConditions = new Gson().fromJson(headerConditionJson.toString(), ThrottleCondition.HeaderConditions.class);
                conditionDto.setHeaderConditions(headerConditions);
            }
            if (conditionJsonObject.has("QueryParameterType".toLowerCase())) {
                JSONObject queryParamConditionJson = (JSONObject)conditionJsonObject.get("QueryParameterType".toLowerCase());
                ThrottleCondition.QueryParamConditions queryParamCondition = new Gson().fromJson(queryParamConditionJson.toString(), ThrottleCondition.QueryParamConditions.class);
                conditionDto.setQueryParameterConditions(queryParamCondition);
            }
            conditionDtoList.add(conditionDto);
        }
        conditionDtoList.sort((o1, o2) -> {
            if (o1.getIpCondition() != null && o2.getIpCondition() == null) {
                return -1;
            }
            if (o1.getIpCondition() == null && o2.getIpCondition() != null) {
                return 1;
            }
            if (o1.getIpRangeCondition() != null && o2.getIpRangeCondition() == null) {
                return -1;
            }
            if (o1.getIpRangeCondition() == null && o2.getIpRangeCondition() != null) {
                return 1;
            }
            if (o1.getHeaderConditions() != null && o2.getHeaderConditions() == null) {
                return -1;
            }
            if (o1.getHeaderConditions() == null && o2.getHeaderConditions() != null) {
                return 1;
            }
            if (o1.getQueryParameterConditions() != null && o2.getQueryParameterConditions() == null) {
                return -1;
            }
            if (o1.getQueryParameterConditions() == null && o2.getQueryParameterConditions() != null) {
                return 1;
            }
            if (o1.getJwtClaimConditions() != null && o2.getJwtClaimConditions() == null) {
                return -1;
            }
            if (o1.getJwtClaimConditions() == null && o2.getJwtClaimConditions() != null) {
                return 1;
            }
            return 0;
        });
        return conditionDtoList;
    }
}

