/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle.databridge.agent;

import java.util.ArrayList;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.DataPublisher;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.client.ClientPool;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.conf.AgentConfiguration;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint.DataEndpoint;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint.binary.BinaryClientPoolFactory;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint.binary.BinaryDataEndpoint;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint.binary.BinarySecureClientPoolFactory;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.exception.DataEndpointException;

public class DataEndpointAgent {
    private ArrayList<DataPublisher> dataPublishers = new ArrayList();
    private GenericKeyedObjectPool transportPool;
    private GenericKeyedObjectPool securedTransportPool;
    private AgentConfiguration agentConfiguration;

    public DataEndpointAgent(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        this.initialize();
    }

    private void initialize() {
        BinaryClientPoolFactory clientPoolFactory = new BinaryClientPoolFactory();
        BinarySecureClientPoolFactory secureClientPoolFactory = new BinarySecureClientPoolFactory(this.agentConfiguration.getTrustStore());
        ClientPool clientPool = new ClientPool();
        this.transportPool = clientPool.getClientPool(clientPoolFactory, this.agentConfiguration.getMaxTransportPoolSize(), this.agentConfiguration.getMaxIdleConnections(), true, (long)this.agentConfiguration.getEvictionTimePeriod(), (long)this.agentConfiguration.getMinIdleTimeInPool());
        this.securedTransportPool = clientPool.getClientPool(secureClientPoolFactory, this.agentConfiguration.getSecureMaxTransportPoolSize(), this.agentConfiguration.getSecureMaxIdleConnections(), true, (long)this.agentConfiguration.getSecureEvictionTimePeriod(), (long)this.agentConfiguration.getSecureMinIdleTimeInPool());
    }

    public void addDataPublisher(DataPublisher dataPublisher) {
        this.dataPublishers.add(dataPublisher);
    }

    public AgentConfiguration getAgentConfiguration() {
        return this.agentConfiguration;
    }

    public GenericKeyedObjectPool getTransportPool() {
        return this.transportPool;
    }

    public GenericKeyedObjectPool getSecuredTransportPool() {
        return this.securedTransportPool;
    }

    public synchronized void shutDown(DataPublisher dataPublisher) {
        this.dataPublishers.remove(dataPublisher);
    }

    public DataEndpoint getNewDataEndpoint() {
        return new BinaryDataEndpoint();
    }

    public synchronized void shutDown() throws DataEndpointException {
        for (DataPublisher dataPublisher : this.dataPublishers) {
            dataPublisher.shutdown();
        }
        try {
            this.transportPool.close();
            this.securedTransportPool.close();
        }
        catch (Exception e) {
            throw new DataEndpointException("Error while closing the transport pool", e);
        }
    }
}

