/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.utils.DataBridgeThreadFactory;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.DataEndpointAgent;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint.DataEndpoint;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint.DataEndpointFailureCallback;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint.WrappedEventFactory;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.exception.EventQueueFullException;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.util.DataPublisherUtil;

public class DataEndpointGroup
implements DataEndpointFailureCallback {
    private static final Logger log = LogManager.getLogger(DataEndpointGroup.class);
    private List<DataEndpoint> dataEndpoints;
    private HAType haType;
    private EventQueue eventQueue = null;
    private int reconnectionInterval;
    private final Integer startIndex = 0;
    private AtomicInteger currentDataPublisherIndex = new AtomicInteger(this.startIndex);
    private AtomicInteger maximumDataPublisherIndex = new AtomicInteger();
    private ScheduledExecutorService reconnectionService;
    private final String publishingStrategy;
    private boolean isShutdown = false;

    public DataEndpointGroup(HAType haType, DataEndpointAgent agent) {
        this.dataEndpoints = new ArrayList<DataEndpoint>();
        this.haType = haType;
        this.reconnectionService = Executors.newScheduledThreadPool(1, new DataBridgeThreadFactory("ReconnectionService"));
        this.reconnectionInterval = agent.getAgentConfiguration().getReconnectionInterval();
        this.publishingStrategy = agent.getAgentConfiguration().getPublishingStrategy();
        if (!this.publishingStrategy.equalsIgnoreCase("sync")) {
            this.eventQueue = new EventQueue(agent.getAgentConfiguration().getQueueSize());
        }
        this.reconnectionService.scheduleAtFixedRate(new ReconnectionTask(), this.reconnectionInterval, this.reconnectionInterval, TimeUnit.SECONDS);
        this.currentDataPublisherIndex.set(this.startIndex);
    }

    public void addDataEndpoint(DataEndpoint dataEndpoint) {
        this.dataEndpoints.add(dataEndpoint);
        dataEndpoint.registerDataEndpointFailureCallback(this);
        this.maximumDataPublisherIndex.incrementAndGet();
    }

    public void tryPublish(Event event) throws EventQueueFullException {
        if (this.eventQueue != null) {
            this.eventQueue.tryPut(event);
        } else if (!this.isShutdown) {
            this.trySyncPublish(event);
        }
    }

    public void publish(Event event) {
        if (this.eventQueue != null) {
            this.eventQueue.put(event);
        } else if (!this.isShutdown) {
            this.syncPublish(event);
        }
    }

    private void trySyncPublish(Event event) {
        try {
            DataEndpoint endpoint = this.getDataEndpoint(false);
            if (endpoint != null) {
                endpoint.syncSend(event);
            } else if (log.isDebugEnabled()) {
                log.debug("DataEndpoint not available, dropping event : " + event);
            }
        }
        catch (Throwable t) {
            log.error("Unexpected error: " + t.getMessage(), t);
        }
    }

    private void syncPublish(Event event) {
        try {
            DataEndpoint endpoint = this.getDataEndpoint(true);
            if (endpoint != null) {
                endpoint.syncSend(event);
            } else {
                log.error("Dropping event as DataPublisher is shutting down.");
                if (log.isDebugEnabled()) {
                    log.debug("Data publisher is shutting down, dropping event : " + event);
                }
            }
        }
        catch (Throwable t) {
            log.error("Unexpected error: " + t.getMessage(), t);
        }
    }

    private void flushAllDataEndpoints() {
        for (DataEndpoint dataEndpoint : this.dataEndpoints) {
            if (!dataEndpoint.getState().equals((Object)DataEndpoint.State.ACTIVE)) continue;
            dataEndpoint.flushEvents();
        }
    }

    private DataEndpoint getDataEndpoint(boolean isBusyWait) {
        return this.getDataEndpoint(isBusyWait, null);
    }

    private DataEndpoint getDataEndpoint(boolean isBusyWait, DataEndpoint failedEP) {
        int startIndex = this.haType.equals((Object)HAType.LOADBALANCE) ? this.getDataPublisherIndex() : this.startIndex.intValue();
        int index = startIndex;
        while (true) {
            DataEndpoint dataEndpoint;
            if ((dataEndpoint = this.dataEndpoints.get(index)).getState().equals((Object)DataEndpoint.State.ACTIVE) && dataEndpoint != failedEP) {
                return dataEndpoint;
            }
            if (this.haType.equals((Object)HAType.FAILOVER) && (dataEndpoint.getState().equals((Object)DataEndpoint.State.BUSY) || dataEndpoint.getState().equals((Object)DataEndpoint.State.INITIALIZING))) {
                this.busyWait(1L);
                continue;
            }
            if (++index > this.maximumDataPublisherIndex.get() - 1) {
                index = this.startIndex;
            }
            if (index != startIndex) continue;
            if (!isBusyWait) break;
            if (!this.reconnectionService.isShutdown()) {
                this.busyWait(1L);
                continue;
            }
            if (!this.isActiveDataEndpointExists()) {
                return null;
            }
            this.busyWait(1L);
        }
        return null;
    }

    private void busyWait(long timeInMilliSec) {
        try {
            Thread.sleep(timeInMilliSec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isActiveDataEndpointExists() {
        for (int index = this.startIndex.intValue(); index < this.maximumDataPublisherIndex.get(); ++index) {
            DataEndpoint dataEndpoint = this.dataEndpoints.get(index);
            if (dataEndpoint.getState() == DataEndpoint.State.UNAVAILABLE) continue;
            if (log.isDebugEnabled()) {
                log.debug("Available endpoint : " + dataEndpoint + " existing in state - " + dataEndpoint.getState());
            }
            return true;
        }
        return false;
    }

    private synchronized int getDataPublisherIndex() {
        int index = this.currentDataPublisherIndex.getAndIncrement();
        if (index == this.maximumDataPublisherIndex.get() - 1) {
            this.currentDataPublisherIndex.set(this.startIndex);
        }
        return index;
    }

    @Override
    public void tryResendEvents(List<Event> events, DataEndpoint dataEndpoint) {
        List<Event> unsuccessfulEvents = this.trySendActiveEndpoints(events, dataEndpoint);
        for (Event event : unsuccessfulEvents) {
            try {
                if (this.eventQueue != null) {
                    this.eventQueue.tryPut(event);
                    continue;
                }
                this.trySyncPublish(event);
            }
            catch (EventQueueFullException e) {
                log.error("Unable to put the event :" + event, (Throwable)e);
            }
        }
    }

    private List<Event> trySendActiveEndpoints(List<Event> events, DataEndpoint failedEP) {
        ArrayList<Event> unsuccessfulEvents = new ArrayList<Event>();
        for (Event event : events) {
            DataEndpoint endpoint = this.getDataEndpoint(false, failedEP);
            if (endpoint != null) {
                endpoint.collectAndSend(event);
                continue;
            }
            unsuccessfulEvents.add(event);
        }
        this.flushAllDataEndpoints();
        return unsuccessfulEvents;
    }

    public String toString() {
        StringBuilder group = new StringBuilder();
        group.append("[ ");
        for (int i = 0; i < this.dataEndpoints.size(); ++i) {
            DataEndpoint endpoint = this.dataEndpoints.get(i);
            group.append(endpoint.toString());
            if (i == this.dataEndpoints.size() - 1) {
                group.append(" ]");
                return group.toString();
            }
            if (this.haType == HAType.FAILOVER) {
                group.append("|");
                continue;
            }
            group.append(",");
        }
        return group.toString();
    }

    public void shutdown() {
        this.reconnectionService.shutdownNow();
        if (this.eventQueue != null) {
            this.eventQueue.shutdown();
        }
        this.isShutdown = true;
        for (DataEndpoint dataEndpoint : this.dataEndpoints) {
            dataEndpoint.shutdown();
        }
    }

    private class ReconnectionTask
    implements Runnable {
        String failedDataEndpoints = "";

        private ReconnectionTask() {
        }

        @Override
        public void run() {
            boolean isOneReceiverConnected = false;
            for (int i = DataEndpointGroup.this.startIndex.intValue(); i < DataEndpointGroup.this.maximumDataPublisherIndex.get(); ++i) {
                DataEndpoint dataEndpoint = DataEndpointGroup.this.dataEndpoints.get(i);
                if (!dataEndpoint.isConnected()) {
                    try {
                        dataEndpoint.connect();
                    }
                    catch (Exception ex) {
                        dataEndpoint.deactivate();
                    }
                } else {
                    try {
                        String[] urlElements = DataPublisherUtil.getProtocolHostPort(dataEndpoint.getDataEndpointConfiguration().getReceiverURL());
                        if (!this.isServerExists(urlElements[1], Integer.parseInt(urlElements[2]))) {
                            dataEndpoint.deactivate();
                        }
                    }
                    catch (DataEndpointConfigurationException exception) {
                        log.warn("Data Endpoint with receiver URL:" + dataEndpoint.getDataEndpointConfiguration().getReceiverURL() + " could not be deactivated", (Throwable)exception);
                    }
                }
                if (dataEndpoint.isConnected()) {
                    isOneReceiverConnected = true;
                    continue;
                }
                this.failedDataEndpoints = (dataEndpoint.getDataEndpointConfiguration() != null ? dataEndpoint.getDataEndpointConfiguration().getReceiverURL() : "Null") + ",";
            }
            if (!isOneReceiverConnected) {
                log.warn("Receiver is not reachable at reconnection for the endpoints: " + this.failedDataEndpoints + ", will try to reconnect every " + DataEndpointGroup.this.reconnectionInterval + " sec");
            }
        }

        private boolean isServerExists(String ip, int port) {
            try {
                Socket socket = new Socket(ip, port);
                socket.close();
                return true;
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    class EventQueueWorker
    implements EventHandler<WrappedEventFactory.WrappedEvent> {
        boolean isLastEventDropped = false;

        EventQueueWorker() {
        }

        @Override
        public void onEvent(WrappedEventFactory.WrappedEvent wrappedEvent, long sequence, boolean endOfBatch) {
            DataEndpoint endpoint = DataEndpointGroup.this.getDataEndpoint(true);
            Event event = wrappedEvent.getEvent();
            if (endpoint != null) {
                this.isLastEventDropped = false;
                endpoint.collectAndSend(event);
                if (endOfBatch) {
                    DataEndpointGroup.this.flushAllDataEndpoints();
                }
            } else {
                if (!this.isLastEventDropped) {
                    log.error("Dropping all events as DataPublisher is shutting down.");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Data publisher is shutting down, dropping event : " + event);
                }
                this.isLastEventDropped = true;
            }
        }
    }

    class EventQueue {
        private RingBuffer<WrappedEventFactory.WrappedEvent> ringBuffer = null;
        private Disruptor<WrappedEventFactory.WrappedEvent> eventQueueDisruptor = null;
        private ExecutorService eventQueuePool = Executors.newCachedThreadPool(new DataBridgeThreadFactory("EventQueue"));

        EventQueue(int queueSize) {
            this.eventQueueDisruptor = new Disruptor<WrappedEventFactory.WrappedEvent>(new WrappedEventFactory(), queueSize, this.eventQueuePool, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
            this.eventQueueDisruptor.handleEventsWith(new EventQueueWorker());
            this.ringBuffer = this.eventQueueDisruptor.start();
        }

        private void tryPut(Event event) throws EventQueueFullException {
            try {
                long sequence = this.ringBuffer.tryNext(1);
                WrappedEventFactory.WrappedEvent bufferedEvent = this.ringBuffer.get(sequence);
                bufferedEvent.setEvent(event);
                this.ringBuffer.publish(sequence);
            }
            catch (InsufficientCapacityException e) {
                throw new EventQueueFullException("Cannot send events because the event queue is full", e);
            }
        }

        private void put(Event event) {
            while (true) {
                try {
                    long sequence = this.ringBuffer.tryNext(1);
                    WrappedEventFactory.WrappedEvent bufferedEvent = this.ringBuffer.get(sequence);
                    bufferedEvent.setEvent(event);
                    this.ringBuffer.publish(sequence);
                    return;
                }
                catch (InsufficientCapacityException ex) {
                    try {
                        Thread.sleep(2L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (DataEndpointGroup.this.isActiveDataEndpointExists()) continue;
                    return;
                }
                break;
            }
        }

        private void shutdown() {
            this.eventQueuePool.shutdown();
            this.eventQueueDisruptor.shutdown();
        }
    }

    public static enum HAType {
        FAILOVER,
        LOADBALANCE;

    }
}

