/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle.databridge.publisher;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PublisherConfiguration {
    private static final Logger log = LogManager.getLogger(PublisherConfiguration.class);
    private int maxIdleDataPublishingAgents;
    private int initIdleObjectDataPublishingAgents;
    private int publisherThreadPoolCoreSize;
    private int publisherThreadPoolMaximumSize;
    private int publisherThreadPoolKeepAliveTime;
    private String receiverUrlGroup;
    private String authUrlGroup;
    private String userName;
    private char[] password;
    private static PublisherConfiguration instance = new PublisherConfiguration();

    private PublisherConfiguration() {
    }

    public void setMaxIdleDataPublishingAgents(int maxIdleDataPublishingAgents) {
        this.maxIdleDataPublishingAgents = maxIdleDataPublishingAgents;
    }

    public void setInitIdleObjectDataPublishingAgents(int initIdleObjectDataPublishingAgents) {
        this.initIdleObjectDataPublishingAgents = initIdleObjectDataPublishingAgents;
    }

    public void setPublisherThreadPoolCoreSize(int publisherThreadPoolCoreSize) {
        this.publisherThreadPoolCoreSize = publisherThreadPoolCoreSize;
    }

    public void setPublisherThreadPoolMaximumSize(int publisherThreadPoolMaximumSize) {
        this.publisherThreadPoolMaximumSize = publisherThreadPoolMaximumSize;
    }

    public void setPublisherThreadPoolKeepAliveTime(int publisherThreadPoolKeepAliveTime) {
        this.publisherThreadPoolKeepAliveTime = publisherThreadPoolKeepAliveTime;
    }

    public void setAuthUrlGroup(String authUrlGroup) {
        this.authUrlGroup = authUrlGroup;
    }

    public void setReceiverUrlGroup(String receiverUrlGroup) {
        this.receiverUrlGroup = receiverUrlGroup;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public int getMaxIdleDataPublishingAgents() {
        return this.maxIdleDataPublishingAgents;
    }

    public int getInitIdleObjectDataPublishingAgents() {
        return this.initIdleObjectDataPublishingAgents;
    }

    public int getPublisherThreadPoolCoreSize() {
        return this.publisherThreadPoolCoreSize;
    }

    public int getPublisherThreadPoolMaximumSize() {
        return this.publisherThreadPoolMaximumSize;
    }

    public int getPublisherThreadPoolKeepAliveTime() {
        return this.publisherThreadPoolKeepAliveTime;
    }

    public String getReceiverUrlGroup() {
        return this.receiverUrlGroup;
    }

    public String getAuthUrlGroup() {
        return this.authUrlGroup;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return String.valueOf(this.password);
    }

    public static PublisherConfiguration getInstance() {
        return instance;
    }

    public static synchronized void setInstance(PublisherConfiguration publisherConfiguration) {
        instance = publisherConfiguration;
    }

    public void setConfiguration(Map<String, Object> publisherConfiguration) {
        this.receiverUrlGroup = String.valueOf(publisherConfiguration.get("receiverURLGroup"));
        this.authUrlGroup = String.valueOf(publisherConfiguration.get("authURLGroup"));
        this.userName = String.valueOf(publisherConfiguration.get("username"));
        this.password = String.valueOf(publisherConfiguration.get("password")).toCharArray();
        try {
            this.maxIdleDataPublishingAgents = Math.toIntExact((Long)publisherConfiguration.get("maxIdle"));
            this.initIdleObjectDataPublishingAgents = Math.toIntExact((Long)publisherConfiguration.get("initIdleCapacity"));
            this.publisherThreadPoolCoreSize = Math.toIntExact((Long)publisherConfiguration.get("corePoolSize"));
            this.publisherThreadPoolMaximumSize = Math.toIntExact((Long)publisherConfiguration.get("maxPoolSize"));
            this.publisherThreadPoolKeepAliveTime = Math.toIntExact((Long)publisherConfiguration.get("keepAliveTime"));
        }
        catch (ArithmeticException e) {
            log.error("Error while processing the publisher configuration.", (Throwable)e);
        }
    }
}

