/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.util;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTInfoDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo;
import org.wso2.micro.gateway.enforcer.api.RequestContext;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.constants.APIConstants;
import org.wso2.micro.gateway.enforcer.constants.APISecurityConstants;
import org.wso2.micro.gateway.enforcer.dto.APIKeyValidationInfoDTO;
import org.wso2.micro.gateway.enforcer.exception.APISecurityException;
import org.wso2.micro.gateway.enforcer.exception.MGWException;
import org.wso2.micro.gateway.enforcer.security.AuthenticationContext;

public class FilterUtils {
    private static final Logger log = LogManager.getLogger(FilterUtils.class);
    public static final String HOST_NAME_VERIFIER = "httpclient.hostnameVerifier";
    public static final String STRICT = "Strict";
    public static final String ALLOW_ALL = "AllowAll";

    public static String getMaskedToken(String token) {
        if (token.length() >= 10) {
            return "XXXXX" + token.substring(token.length() - 10);
        }
        return "XXXXX" + token.substring(token.length() / 2);
    }

    public static HttpClient getHttpClient(String protocol) {
        String maxTotal = "100";
        String defaultMaxPerRoute = "10";
        PoolingHttpClientConnectionManager pool = null;
        try {
            pool = FilterUtils.getPoolingHttpClientConnectionManager(protocol);
        }
        catch (MGWException e) {
            log.error("Error while getting http client connection manager", (Throwable)e);
        }
        pool.setMaxTotal(Integer.parseInt(maxTotal));
        pool.setDefaultMaxPerRoute(Integer.parseInt(defaultMaxPerRoute));
        RequestConfig params = RequestConfig.custom().build();
        return HttpClients.custom().setConnectionManager(pool).setDefaultRequestConfig(params).build();
    }

    private static PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager(String protocol) throws MGWException {
        PoolingHttpClientConnectionManager poolManager;
        if ("https".equals(protocol)) {
            SSLConnectionSocketFactory socketFactory = FilterUtils.createSocketFactory();
            Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("https", socketFactory).build();
            poolManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        } else {
            poolManager = new PoolingHttpClientConnectionManager();
        }
        return poolManager;
    }

    private static SSLConnectionSocketFactory createSocketFactory() throws MGWException {
        try {
            KeyStore trustStore = ConfigHolder.getInstance().getTrustStore();
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore).build();
            String hostnameVerifierOption = System.getProperty(HOST_NAME_VERIFIER);
            X509HostnameVerifier hostnameVerifier = ALLOW_ALL.equalsIgnoreCase(hostnameVerifierOption) ? SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : (STRICT.equalsIgnoreCase(hostnameVerifierOption) ? SSLSocketFactory.STRICT_HOSTNAME_VERIFIER : SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            return new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        }
        catch (KeyStoreException e) {
            FilterUtils.handleException("Failed to read from Key Store", e);
        }
        catch (NoSuchAlgorithmException e) {
            FilterUtils.handleException("Failed to initialize sslContext. ", e);
        }
        catch (KeyManagementException e) {
            FilterUtils.handleException("Failed to initialize sslContext ", e);
        }
        return null;
    }

    public static void handleException(String msg, Throwable t) throws MGWException {
        log.error(msg, t);
        throw new MGWException(msg, t);
    }

    public static String getTenantDomainFromRequestURL(String requestURI) {
        String domain = null;
        if (requestURI.contains("/t/")) {
            int index = requestURI.indexOf("/t/");
            int endIndex = requestURI.indexOf("/", index + 3);
            domain = endIndex != -1 ? requestURI.substring(index + 3, endIndex) : requestURI.substring(index + 3);
        }
        return domain;
    }

    public static AuthenticationContext generateAuthenticationContext(RequestContext requestContext, String jti, JWTValidationInfo jwtValidationInfo, APIKeyValidationInfoDTO apiKeyValidationInfoDTO, String endUserToken, boolean isOauth) {
        AuthenticationContext authContext = requestContext.getAuthenticationContext();
        authContext.setAuthenticated(true);
        authContext.setApiKey(jti);
        authContext.setUsername(jwtValidationInfo.getUser());
        if (apiKeyValidationInfoDTO != null) {
            authContext.setApiTier(apiKeyValidationInfoDTO.getApiTier());
            authContext.setKeyType(apiKeyValidationInfoDTO.getType());
            authContext.setApplicationId(apiKeyValidationInfoDTO.getApplicationId());
            authContext.setApplicationName(apiKeyValidationInfoDTO.getApplicationName());
            authContext.setApplicationTier(apiKeyValidationInfoDTO.getApplicationTier());
            authContext.setSubscriber(apiKeyValidationInfoDTO.getSubscriber());
            authContext.setTier(apiKeyValidationInfoDTO.getTier());
            authContext.setSubscriberTenantDomain(apiKeyValidationInfoDTO.getSubscriberTenantDomain());
            authContext.setApiName(apiKeyValidationInfoDTO.getApiName());
            authContext.setApiPublisher(apiKeyValidationInfoDTO.getApiPublisher());
            authContext.setStopOnQuotaReach(apiKeyValidationInfoDTO.isStopOnQuotaReach());
            authContext.setSpikeArrestLimit(apiKeyValidationInfoDTO.getSpikeArrestLimit());
            authContext.setSpikeArrestUnit(apiKeyValidationInfoDTO.getSpikeArrestUnit());
            authContext.setConsumerKey(apiKeyValidationInfoDTO.getConsumerKey());
            authContext.setIsContentAware(apiKeyValidationInfoDTO.isContentAware());
        }
        if (isOauth) {
            authContext.setConsumerKey(jwtValidationInfo.getConsumerKey());
        }
        if (StringUtils.isNotEmpty(endUserToken)) {
            authContext.setCallerToken(endUserToken);
        }
        return authContext;
    }

    public static long ipToLong(String ipAddress) {
        long result = 0L;
        String[] ipAddressInArray = ipAddress.split("\\.");
        for (int i = 3; i >= 0; --i) {
            long ip = Long.parseLong(ipAddressInArray[3 - i]);
            result |= ip << i * 8;
        }
        return result;
    }

    public static BigInteger ipToBigInteger(String ipAddress) {
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            byte[] bytes = address.getAddress();
            return new BigInteger(1, bytes);
        }
        catch (UnknownHostException e) {
            log.error("Error while parsing host IP " + ipAddress, (Throwable)e);
            return BigInteger.ZERO;
        }
    }

    public static JWTInfoDto generateJWTInfoDto(JSONObject subscribedAPI, JWTValidationInfo jwtValidationInfo, APIKeyValidationInfoDTO apiKeyValidationInfoDTO, RequestContext requestContext) {
        JWTInfoDto jwtInfoDto = new JWTInfoDto();
        jwtInfoDto.setJwtValidationInfo(jwtValidationInfo);
        String apiContext = requestContext.getMathedAPI().getAPIConfig().getBasePath();
        String apiVersion = requestContext.getMathedAPI().getAPIConfig().getVersion();
        jwtInfoDto.setApicontext(apiContext);
        jwtInfoDto.setVersion(apiVersion);
        FilterUtils.constructJWTContent(subscribedAPI, apiKeyValidationInfoDTO, jwtInfoDto);
        return jwtInfoDto;
    }

    private static void constructJWTContent(JSONObject subscribedAPI, APIKeyValidationInfoDTO apiKeyValidationInfoDTO, JWTInfoDto jwtInfoDto) {
        if (apiKeyValidationInfoDTO != null) {
            jwtInfoDto.setApplicationid(apiKeyValidationInfoDTO.getApplicationId());
            jwtInfoDto.setApplicationname(apiKeyValidationInfoDTO.getApplicationName());
            jwtInfoDto.setApplicationtier(apiKeyValidationInfoDTO.getApplicationTier());
            jwtInfoDto.setKeytype(apiKeyValidationInfoDTO.getType());
            jwtInfoDto.setSubscriber(apiKeyValidationInfoDTO.getSubscriber());
            jwtInfoDto.setSubscriptionTier(apiKeyValidationInfoDTO.getTier());
            jwtInfoDto.setApiName(apiKeyValidationInfoDTO.getApiName());
            jwtInfoDto.setEndusertenantid(0);
            jwtInfoDto.setApplicationuuid(apiKeyValidationInfoDTO.getApplicationUUID());
            jwtInfoDto.setAppAttributes(apiKeyValidationInfoDTO.getAppAttributes());
        } else if (subscribedAPI != null) {
            String apiName = subscribedAPI.getAsString("name");
            jwtInfoDto.setApiName(apiName);
            String subscriptionTier = subscribedAPI.getAsString("subscriptionTier");
            String subscriptionTenantDomain = subscribedAPI.getAsString("subscriberTenantDomain");
            jwtInfoDto.setSubscriptionTier(subscriptionTier);
            jwtInfoDto.setEndusertenantid(0);
            Map<String, Object> claims = jwtInfoDto.getJwtValidationInfo().getClaims();
            if (claims.get("application") != null) {
                JSONObject applicationObj = (JSONObject)claims.get("application");
                jwtInfoDto.setApplicationid(String.valueOf(applicationObj.getAsNumber("id")));
                jwtInfoDto.setApplicationname(applicationObj.getAsString("name"));
                jwtInfoDto.setApplicationtier(applicationObj.getAsString("tier"));
                jwtInfoDto.setSubscriber(applicationObj.getAsString("owner"));
            }
        }
    }

    public static void setErrorToContext(RequestContext requestContext, APISecurityException e) {
        Map<String, Object> requestContextProperties = requestContext.getProperties();
        if (!requestContextProperties.containsKey("status_code")) {
            requestContext.getProperties().put("status_code", e.getStatusCode());
        }
        if (!requestContextProperties.containsKey("code")) {
            requestContext.getProperties().put("code", e.getErrorCode());
        }
        if (!requestContextProperties.containsKey("error_message")) {
            requestContext.getProperties().put("error_message", APISecurityConstants.getAuthenticationFailureMessage(e.getErrorCode()));
        }
        if (!requestContextProperties.containsKey("error_description")) {
            requestContext.getProperties().put("error_description", APISecurityConstants.getFailureMessageDetailDescription(e.getErrorCode(), e.getMessage()));
        }
    }

    public static void setUnauthenticatedErrorToContext(RequestContext requestContext) {
        requestContext.getProperties().put("status_code", APIConstants.StatusCodes.UNAUTHENTICATED.getCode());
        requestContext.getProperties().put("code", 900901);
        requestContext.getProperties().put("error_message", APISecurityConstants.getAuthenticationFailureMessage(900901));
        requestContext.getProperties().put("error_description", "Make sure you have provided the correct security credentials");
    }

    public static void setThrottleErrorToContext(RequestContext context, int errorCode, String msg, String desc) {
        context.getProperties().put("code", errorCode);
        context.getProperties().put("status_code", APIConstants.StatusCodes.THROTTLED.getCode());
        context.getProperties().put("error_message", msg);
        context.getProperties().put("error_description", desc);
    }
}

