/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.util.List;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TLSUtils {
    private static final Logger log = LogManager.getLogger(TLSUtils.class);
    private static final String X509 = "X.509";
    private static final String crtExtension = ".crt";
    private static final String pemExtension = ".pem";

    public static Certificate getCertificateFromFile(String filePath) throws java.security.cert.CertificateException, IOException {
        return TLSUtils.getCertsFromFile(filePath, true).get(0);
    }

    public static Certificate getCertificateFromString(String certificateContent) throws java.security.cert.CertificateException, IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateContent.getBytes());){
            CertificateFactory fact = CertificateFactory.getInstance(X509);
            Certificate certificate = fact.generateCertificate(inputStream);
            return certificate;
        }
    }

    public static void addCertsToTruststore(KeyStore trustStore, String filePath) throws IOException {
        if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            log.error("The provided certificates directory/file path does not exist. : " + filePath);
            return;
        }
        if (Files.isDirectory(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            log.debug("Provided Path is a directory: " + filePath);
            Files.walk(Paths.get(filePath, new String[0]), new FileVisitOption[0]).filter(path -> {
                Path fileName = path.getFileName();
                return fileName != null && (fileName.toString().endsWith(crtExtension) || fileName.toString().endsWith(pemExtension));
            }).forEach(path -> TLSUtils.updateTruststoreWithMutlipleCertPem(trustStore, path.toAbsolutePath().toString()));
        } else {
            log.debug("Provided Path is a regular File Path : " + filePath);
            TLSUtils.updateTruststoreWithMutlipleCertPem(trustStore, filePath);
        }
    }

    /*
     * Exception decompiling
     */
    private static List<Certificate> getCertsFromFile(String filepath, boolean restrictToOne) throws java.security.cert.CertificateException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void updateTruststoreWithMutlipleCertPem(KeyStore trustStore, String filePath) {
        try {
            List<Certificate> certificateList = TLSUtils.getCertsFromFile(filePath, false);
            certificateList.forEach(certificate -> {
                try {
                    trustStore.setCertificateEntry(RandomStringUtils.random(10, true, false), (Certificate)certificate);
                }
                catch (KeyStoreException e) {
                    log.error("Error while adding the trusted certificates to the trustStore.", (Throwable)e);
                }
            });
            log.debug("Certificate Added to the truststore : " + filePath);
        }
        catch (IOException | java.security.cert.CertificateException e) {
            log.error("Error while adding certificates to the truststore.", (Throwable)e);
        }
    }

    public static Certificate getCertificate(String filePath) throws java.security.cert.CertificateException, IOException {
        java.security.cert.X509Certificate cert;
        java.security.cert.X509Certificate certificate = null;
        CertificateFactory fact = CertificateFactory.getInstance(X509);
        FileInputStream is = new FileInputStream(filePath);
        certificate = cert = (java.security.cert.X509Certificate)fact.generateCertificate(is);
        return certificate;
    }

    public static javax.security.cert.Certificate convertCertificate(Certificate cert) {
        X509Certificate certificate = null;
        try {
            X509Certificate x509Certificate;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(cert.getEncoded());
            certificate = x509Certificate = X509Certificate.getInstance(inputStream);
            return certificate;
        }
        catch (CertificateEncodingException | CertificateException e) {
            log.debug("Error in loading certificate");
            return certificate;
        }
    }
}

