/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.common.support;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.wso2.org.apache.mina.common.ByteBuffer;

public abstract class BaseByteBuffer
extends ByteBuffer {
    private boolean autoExpand;
    private int mark = -1;

    protected BaseByteBuffer() {
    }

    @Override
    public boolean isDirect() {
        return this.buf().isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.buf().isReadOnly();
    }

    @Override
    public int capacity() {
        return this.buf().capacity();
    }

    @Override
    public ByteBuffer capacity(int newCapacity) {
        if (newCapacity > this.capacity()) {
            int pos = this.position();
            int limit = this.limit();
            ByteOrder bo = this.order();
            this.capacity0(newCapacity);
            this.buf().limit(limit);
            if (this.mark >= 0) {
                this.buf().position(this.mark);
                this.buf().mark();
            }
            this.buf().position(pos);
            this.buf().order(bo);
        }
        return this;
    }

    protected abstract void capacity0(int var1);

    @Override
    public boolean isAutoExpand() {
        return this.autoExpand;
    }

    @Override
    public ByteBuffer setAutoExpand(boolean autoExpand) {
        this.autoExpand = autoExpand;
        return this;
    }

    @Override
    public ByteBuffer expand(int pos, int expectedRemaining) {
        int end = pos + expectedRemaining;
        if (end > this.capacity()) {
            this.capacity(end);
        }
        if (end > this.limit()) {
            this.buf().limit(end);
        }
        return this;
    }

    @Override
    public int position() {
        return this.buf().position();
    }

    @Override
    public ByteBuffer position(int newPosition) {
        this.autoExpand(newPosition, 0);
        this.buf().position(newPosition);
        if (this.mark > newPosition) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.buf().limit();
    }

    @Override
    public ByteBuffer limit(int newLimit) {
        this.autoExpand(newLimit, 0);
        this.buf().limit(newLimit);
        if (this.mark > newLimit) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public ByteBuffer mark() {
        this.buf().mark();
        this.mark = this.position();
        return this;
    }

    @Override
    public int markValue() {
        return this.mark;
    }

    @Override
    public ByteBuffer reset() {
        this.buf().reset();
        return this;
    }

    @Override
    public ByteBuffer clear() {
        this.buf().clear();
        this.mark = -1;
        return this;
    }

    @Override
    public ByteBuffer flip() {
        this.buf().flip();
        this.mark = -1;
        return this;
    }

    @Override
    public ByteBuffer rewind() {
        this.buf().rewind();
        this.mark = -1;
        return this;
    }

    @Override
    public byte get() {
        return this.buf().get();
    }

    @Override
    public ByteBuffer put(byte b) {
        this.autoExpand(1);
        this.buf().put(b);
        return this;
    }

    @Override
    public byte get(int index) {
        return this.buf().get(index);
    }

    @Override
    public ByteBuffer put(int index, byte b) {
        this.autoExpand(index, 1);
        this.buf().put(index, b);
        return this;
    }

    @Override
    public ByteBuffer get(byte[] dst, int offset, int length) {
        this.buf().get(dst, offset, length);
        return this;
    }

    @Override
    public ByteBuffer put(java.nio.ByteBuffer src) {
        this.autoExpand(src.remaining());
        this.buf().put(src);
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        this.autoExpand(length);
        this.buf().put(src, offset, length);
        return this;
    }

    @Override
    public ByteBuffer compact() {
        this.buf().compact();
        this.mark = -1;
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.buf().order();
    }

    @Override
    public ByteBuffer order(ByteOrder bo) {
        this.buf().order(bo);
        return this;
    }

    @Override
    public char getChar() {
        return this.buf().getChar();
    }

    @Override
    public ByteBuffer putChar(char value) {
        this.autoExpand(2);
        this.buf().putChar(value);
        return this;
    }

    @Override
    public char getChar(int index) {
        return this.buf().getChar(index);
    }

    @Override
    public ByteBuffer putChar(int index, char value) {
        this.autoExpand(index, 2);
        this.buf().putChar(index, value);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        return this.buf().asCharBuffer();
    }

    @Override
    public short getShort() {
        return this.buf().getShort();
    }

    @Override
    public ByteBuffer putShort(short value) {
        this.autoExpand(2);
        this.buf().putShort(value);
        return this;
    }

    @Override
    public short getShort(int index) {
        return this.buf().getShort(index);
    }

    @Override
    public ByteBuffer putShort(int index, short value) {
        this.autoExpand(index, 2);
        this.buf().putShort(index, value);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        return this.buf().asShortBuffer();
    }

    @Override
    public int getInt() {
        return this.buf().getInt();
    }

    @Override
    public ByteBuffer putInt(int value) {
        this.autoExpand(4);
        this.buf().putInt(value);
        return this;
    }

    @Override
    public int getInt(int index) {
        return this.buf().getInt(index);
    }

    @Override
    public ByteBuffer putInt(int index, int value) {
        this.autoExpand(index, 4);
        this.buf().putInt(index, value);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        return this.buf().asIntBuffer();
    }

    @Override
    public long getLong() {
        return this.buf().getLong();
    }

    @Override
    public ByteBuffer putLong(long value) {
        this.autoExpand(8);
        this.buf().putLong(value);
        return this;
    }

    @Override
    public long getLong(int index) {
        return this.buf().getLong(index);
    }

    @Override
    public ByteBuffer putLong(int index, long value) {
        this.autoExpand(index, 8);
        this.buf().putLong(index, value);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        return this.buf().asLongBuffer();
    }

    @Override
    public float getFloat() {
        return this.buf().getFloat();
    }

    @Override
    public ByteBuffer putFloat(float value) {
        this.autoExpand(4);
        this.buf().putFloat(value);
        return this;
    }

    @Override
    public float getFloat(int index) {
        return this.buf().getFloat(index);
    }

    @Override
    public ByteBuffer putFloat(int index, float value) {
        this.autoExpand(index, 4);
        this.buf().putFloat(index, value);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        return this.buf().asFloatBuffer();
    }

    @Override
    public double getDouble() {
        return this.buf().getDouble();
    }

    @Override
    public ByteBuffer putDouble(double value) {
        this.autoExpand(8);
        this.buf().putDouble(value);
        return this;
    }

    @Override
    public double getDouble(int index) {
        return this.buf().getDouble(index);
    }

    @Override
    public ByteBuffer putDouble(int index, double value) {
        this.autoExpand(index, 8);
        this.buf().putDouble(index, value);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        return this.buf().asDoubleBuffer();
    }
}

