/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.filter.codec.textline;

import java.nio.charset.Charset;
import org.wso2.org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.wso2.org.apache.mina.filter.codec.ProtocolDecoder;
import org.wso2.org.apache.mina.filter.codec.ProtocolEncoder;
import org.wso2.org.apache.mina.filter.codec.textline.LineDelimiter;
import org.wso2.org.apache.mina.filter.codec.textline.TextLineDecoder;
import org.wso2.org.apache.mina.filter.codec.textline.TextLineEncoder;

public class TextLineCodecFactory
implements ProtocolCodecFactory {
    private final TextLineEncoder encoder;
    private final TextLineDecoder decoder;

    public TextLineCodecFactory() {
        this(Charset.defaultCharset());
    }

    public TextLineCodecFactory(Charset charset) {
        this.encoder = new TextLineEncoder(charset, LineDelimiter.UNIX);
        this.decoder = new TextLineDecoder(charset, LineDelimiter.AUTO);
    }

    @Override
    public ProtocolEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    public ProtocolDecoder getDecoder() {
        return this.decoder;
    }

    public int getEncoderMaxLineLength() {
        return this.encoder.getMaxLineLength();
    }

    public void setEncoderMaxLineLength(int maxLineLength) {
        this.encoder.setMaxLineLength(maxLineLength);
    }

    public int getDecoderMaxLineLength() {
        return this.decoder.getMaxLineLength();
    }

    public void setDecoderMaxLineLength(int maxLineLength) {
        this.decoder.setMaxLineLength(maxLineLength);
    }
}

