/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.ServerSocket;
import org.wso2.org.apache.mina.common.ExceptionMonitor;
import org.wso2.org.apache.mina.common.RuntimeIOException;
import org.wso2.org.apache.mina.common.support.BaseIoAcceptorConfig;
import org.wso2.org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.wso2.org.apache.mina.transport.socket.nio.SocketSessionConfigImpl;

public class SocketAcceptorConfig
extends BaseIoAcceptorConfig {
    private SocketSessionConfig sessionConfig = new SocketSessionConfigImpl();
    private int backlog = 50;
    private boolean reuseAddress;

    public SocketAcceptorConfig() {
        ServerSocket s2 = null;
        try {
            s2 = new ServerSocket();
            this.reuseAddress = s2.getReuseAddress();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failed to get the default configuration.", e);
        }
        finally {
            if (s2 != null) {
                try {
                    s2.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        this.sessionConfig.setReuseAddress(true);
    }

    @Override
    public SocketSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

