/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.util.Queue;
import org.wso2.org.apache.mina.common.ByteBuffer;
import org.wso2.org.apache.mina.common.IoFilter;
import org.wso2.org.apache.mina.common.IoSession;
import org.wso2.org.apache.mina.common.support.AbstractIoFilterChain;
import org.wso2.org.apache.mina.transport.socket.nio.SocketSessionImpl;

class SocketFilterChain
extends AbstractIoFilterChain {
    SocketFilterChain(IoSession parent) {
        super(parent);
    }

    @Override
    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        SocketSessionImpl s2 = (SocketSessionImpl)session;
        Queue<IoFilter.WriteRequest> writeRequestQueue = s2.getWriteRequestQueue();
        ByteBuffer buffer = (ByteBuffer)writeRequest.getMessage();
        buffer.mark();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            s2.increaseScheduledWriteRequests();
        } else {
            s2.increaseScheduledWriteBytes(buffer.remaining());
        }
        writeRequestQueue.add(writeRequest);
        if (session.getTrafficMask().isWritable()) {
            s2.getIoProcessor().flush(s2);
        }
    }

    @Override
    protected void doClose(IoSession session) throws IOException {
        SocketSessionImpl s2 = (SocketSessionImpl)session;
        s2.getIoProcessor().remove(s2);
    }
}

