/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.commons;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.XMLSecretResolver;

public class MiscellaneousUtil {
    private static Log log = LogFactory.getLog(MiscellaneousUtil.class);
    private static final String SECURED_PROPERTY_PREFIX = "$secret{";
    private static final char SECURED_PROPERTY_SUFFIX = '}';

    private MiscellaneousUtil() {
    }

    public static String getProperty(Properties properties, String name, String defaultValue) {
        String result = properties.getProperty(name);
        if ((result == null || result.length() == 0) && defaultValue != null) {
            if (log.isDebugEnabled()) {
                log.debug("The name with ' " + name + " ' cannot be found. Using default value " + defaultValue);
            }
            result = defaultValue;
        }
        if (result != null) {
            return result.trim();
        }
        return defaultValue;
    }

    public static <T> T getProperty(Properties properties, String name, T defaultValue, Class<? extends T> type) {
        String result = properties.getProperty(name);
        if (result == null && defaultValue != null) {
            if (log.isDebugEnabled()) {
                log.debug("The name with ' " + name + " ' cannot be found. Using default value " + defaultValue);
            }
            return defaultValue;
        }
        if (result == null || type == null) {
            return null;
        }
        if (String.class.equals(type)) {
            return (T)result;
        }
        if (Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(result));
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(Integer.parseInt(result));
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(Long.parseLong(result));
        }
        MiscellaneousUtil.handleException("Unsupported type: " + type);
        return null;
    }

    public static Properties loadProperties(String filePath) {
        Properties properties = new Properties();
        String carbonHome = System.getProperty("carbon.home");
        filePath = carbonHome + File.separator + filePath;
        File configFile = new File(filePath);
        if (!configFile.exists()) {
            return properties;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            properties.load(in);
        }
        catch (IOException e) {
            String msg = "Error loading properties from a file at :" + filePath;
            log.error(msg, e);
            throw new SecureVaultException(msg, e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignored) {
                    log.error("Error while closing input stream");
                }
            }
        }
        return properties;
    }

    public static byte[] asBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new SecureVaultException("Error during converting a inputstream into a bytearray ", e, log);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }

    private static void handleException(String msg) {
        log.error(msg);
        throw new SecureVaultException(msg);
    }

    public static String getProtectedToken(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        String protectedToken = null;
        String start = SECURED_PROPERTY_PREFIX;
        while (indexOfStartingChars < text.indexOf(start) && (indexOfStartingChars = text.indexOf(start)) != -1 && (indexOfClosingBrace = text.indexOf(125)) != -1) {
            protectedToken = text.substring(indexOfStartingChars + start.length(), indexOfClosingBrace);
        }
        return protectedToken;
    }

    public static boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    public static String resolve(OMElement omElement, SecretResolver secretResolver) {
        String resolvedValue;
        if (secretResolver == null || !secretResolver.isInitialized()) {
            return omElement.getText();
        }
        if (!(secretResolver instanceof XMLSecretResolver)) {
            throw new SecureVaultException("Secret resolver type mismatch. Require: " + XMLSecretResolver.class + " found: " + secretResolver.getClass());
        }
        XMLSecretResolver xmlSecretResolver = (XMLSecretResolver)secretResolver;
        OMAttribute attribute = omElement.getAttribute(new QName(xmlSecretResolver.getSecureVaultNamespace(), xmlSecretResolver.getSecureVaultAlias()));
        if (attribute != null && attribute.getAttributeValue() != null && !attribute.getAttributeValue().isEmpty()) {
            resolvedValue = secretResolver.isTokenProtected(attribute.getAttributeValue()) ? MiscellaneousUtil.resolve(attribute, (SecretResolver)xmlSecretResolver) : omElement.getText();
        } else {
            String value = omElement.getText();
            resolvedValue = MiscellaneousUtil.resolve(value, (SecretResolver)xmlSecretResolver);
        }
        return resolvedValue;
    }

    public static String resolve(String inputText, SecretResolver secretResolver) {
        if (secretResolver == null || !secretResolver.isInitialized()) {
            return inputText;
        }
        List<ProtectedToken> tokenList = MiscellaneousUtil.extractProtectedTokens(inputText);
        if (tokenList.isEmpty()) {
            if (secretResolver.isTokenProtected(inputText)) {
                return secretResolver.resolve(inputText);
            }
            return inputText;
        }
        StringBuilder resolvedValueBuilder = new StringBuilder(inputText);
        for (int i = tokenList.size() - 1; i > -1; --i) {
            ProtectedToken token = tokenList.get(i);
            if (!secretResolver.isTokenProtected(token.getValue())) continue;
            String decryptedValue = secretResolver.resolve(token.getValue());
            resolvedValueBuilder.replace(token.getStartIndex(), token.getEndIndex() + 1, decryptedValue);
        }
        String resolvedValue = resolvedValueBuilder.toString();
        return resolvedValue;
    }

    public static String resolve(OMAttribute attribute, SecretResolver secretResolver) {
        String value = attribute.getAttributeValue();
        return MiscellaneousUtil.resolve(value, secretResolver);
    }

    static List<ProtectedToken> extractProtectedTokens(String text) {
        int startsWithIdx;
        ArrayList<ProtectedToken> tokenList = new ArrayList<ProtectedToken>();
        int idx = 0;
        while (idx < text.length() && (startsWithIdx = text.indexOf(SECURED_PROPERTY_PREFIX, idx)) != -1) {
            int endIdx = text.indexOf(125, startsWithIdx);
            int tokenStartIdx = startsWithIdx + SECURED_PROPERTY_PREFIX.length();
            String token = text.substring(tokenStartIdx, endIdx);
            ProtectedToken protectedToken = new ProtectedToken(startsWithIdx, endIdx, token);
            tokenList.add(protectedToken);
            idx = endIdx + 1;
        }
        return tokenList;
    }

    static class ProtectedToken {
        private int startIndex;
        private int endIndex;
        private String value;

        ProtectedToken(int startIndex, int endIndex, String value) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.value = value;
        }

        int getStartIndex() {
            return this.startIndex;
        }

        String getValue() {
            return this.value;
        }

        int getEndIndex() {
            return this.endIndex;
        }
    }
}

