/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InternalFluxOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.util.annotation.Nullable;

final class FluxSwitchOnFirst<T, R>
extends InternalFluxOperator<T, R> {
    final BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer;
    final boolean cancelSourceOnComplete;

    FluxSwitchOnFirst(Flux<? extends T> source, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer, boolean cancelSourceOnComplete) {
        super(source);
        this.transformer = Objects.requireNonNull(transformer, "transformer");
        this.cancelSourceOnComplete = cancelSourceOnComplete;
    }

    @Override
    public int getPrefetch() {
        return 1;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            return new SwitchOnFirstConditionalMain<T, R>((Fuseable.ConditionalSubscriber)actual, this.transformer, this.cancelSourceOnComplete);
        }
        return new SwitchOnFirstMain<T, R>(actual, this.transformer, this.cancelSourceOnComplete);
    }

    static interface ControlSubscriber<T>
    extends CoreSubscriber<T> {
        public void sendSubscription();
    }

    static final class SwitchOnFirstConditionalControlSubscriber<T>
    extends Operators.DeferredSubscription
    implements InnerOperator<T, T>,
    ControlSubscriber<T>,
    Fuseable.ConditionalSubscriber<T> {
        final AbstractSwitchOnFirstMain<?, T> parent;
        final Fuseable.ConditionalSubscriber<? super T> delegate;
        final boolean terminateUpstreamOnComplete;

        SwitchOnFirstConditionalControlSubscriber(AbstractSwitchOnFirstMain<?, T> parent, Fuseable.ConditionalSubscriber<? super T> delegate, boolean terminateUpstreamOnComplete) {
            this.parent = parent;
            this.delegate = delegate;
            this.terminateUpstreamOnComplete = terminateUpstreamOnComplete;
        }

        @Override
        public void sendSubscription() {
            this.delegate.onSubscribe(this);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.set(s2);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.delegate;
        }

        @Override
        public void onNext(T t) {
            this.delegate.onNext(t);
        }

        @Override
        public boolean tryOnNext(T t) {
            return this.delegate.tryOnNext(t);
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.requested == -2L) {
                Operators.onErrorDropped(throwable, this.currentContext());
                return;
            }
            AbstractSwitchOnFirstMain<?, T> parent = this.parent;
            if (!parent.done) {
                parent.cancel();
            }
            this.delegate.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.requested == -2L) {
                return;
            }
            AbstractSwitchOnFirstMain<?, T> parent = this.parent;
            if (!parent.done && this.terminateUpstreamOnComplete) {
                parent.cancel();
            }
            this.delegate.onComplete();
        }

        @Override
        public void cancel() {
            long state = REQUESTED.getAndSet(this, -2L);
            if (state == -2L) {
                return;
            }
            if (state == -1L) {
                this.s.cancel();
            }
            this.parent.cancel();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.delegate;
            }
            return null;
        }
    }

    static final class SwitchOnFirstControlSubscriber<T>
    extends Operators.DeferredSubscription
    implements InnerOperator<T, T>,
    ControlSubscriber<T> {
        final AbstractSwitchOnFirstMain<?, T> parent;
        final CoreSubscriber<? super T> delegate;
        final boolean cancelSourceOnComplete;

        SwitchOnFirstControlSubscriber(AbstractSwitchOnFirstMain<?, T> parent, CoreSubscriber<? super T> delegate, boolean cancelSourceOnComplete) {
            this.parent = parent;
            this.delegate = delegate;
            this.cancelSourceOnComplete = cancelSourceOnComplete;
        }

        @Override
        public void sendSubscription() {
            this.delegate.onSubscribe(this);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.set(s2);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.delegate;
        }

        @Override
        public void onNext(T t) {
            this.delegate.onNext(t);
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.requested == -2L) {
                Operators.onErrorDropped(throwable, this.currentContext());
                return;
            }
            AbstractSwitchOnFirstMain<?, T> parent = this.parent;
            if (!parent.done) {
                parent.cancel();
            }
            this.delegate.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.requested == -2L) {
                return;
            }
            AbstractSwitchOnFirstMain<?, T> parent = this.parent;
            if (!parent.done && this.cancelSourceOnComplete) {
                parent.cancel();
            }
            this.delegate.onComplete();
        }

        @Override
        public void cancel() {
            long state = REQUESTED.getAndSet(this, -2L);
            if (state == -2L) {
                return;
            }
            if (state == -1L) {
                this.s.cancel();
            }
            this.parent.cancel();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.delegate;
            }
            return null;
        }
    }

    static final class SwitchOnFirstConditionalMain<T, R>
    extends AbstractSwitchOnFirstMain<T, R>
    implements Fuseable.ConditionalSubscriber<T> {
        SwitchOnFirstConditionalMain(Fuseable.ConditionalSubscriber<? super R> outer, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer, boolean cancelSourceOnComplete) {
            super(outer, transformer, cancelSourceOnComplete);
        }

        @Override
        public void subscribe(CoreSubscriber<? super T> actual) {
            if (this.inner == null && INNER.compareAndSet(this, null, Operators.toConditionalSubscriber(actual))) {
                if (this.first == null && this.done) {
                    Throwable t = this.throwable;
                    if (t != null) {
                        Operators.error(actual, t);
                    } else {
                        Operators.complete(actual);
                    }
                    return;
                }
                actual.onSubscribe(this);
            } else if (this.inner != Operators.EMPTY_SUBSCRIBER) {
                Operators.error(actual, new IllegalStateException("FluxSwitchOnFirst allows only one Subscriber"));
            } else {
                Operators.error(actual, new CancellationException("FluxSwitchOnFirst has already been cancelled"));
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            Fuseable.ConditionalSubscriber i = (Fuseable.ConditionalSubscriber)this.inner;
            if (this.done || i == Operators.EMPTY_SUBSCRIBER) {
                Operators.onNextDropped(t, this.currentContext());
                return false;
            }
            if (i == null) {
                Publisher result;
                ControlSubscriber o = this.outer;
                try {
                    result = (Publisher)Objects.requireNonNull(this.transformer.apply(Signal.next(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return false;
                }
                this.first = t;
                result.subscribe(o);
                return true;
            }
            return i.tryOnNext(t);
        }

        @Override
        boolean tryOnNext(CoreSubscriber<? super T> actual, T t) {
            return ((Fuseable.ConditionalSubscriber)actual).tryOnNext(t);
        }
    }

    static final class SwitchOnFirstMain<T, R>
    extends AbstractSwitchOnFirstMain<T, R> {
        SwitchOnFirstMain(CoreSubscriber<? super R> outer, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer, boolean cancelSourceOnComplete) {
            super(outer, transformer, cancelSourceOnComplete);
        }

        @Override
        public void subscribe(CoreSubscriber<? super T> actual) {
            if (this.inner == null && INNER.compareAndSet(this, null, actual)) {
                if (this.first == null && this.done) {
                    Throwable t = this.throwable;
                    if (t != null) {
                        Operators.error(actual, t);
                    } else {
                        Operators.complete(actual);
                    }
                    return;
                }
                actual.onSubscribe(this);
            } else if (this.inner != Operators.EMPTY_SUBSCRIBER) {
                Operators.error(actual, new IllegalStateException("FluxSwitchOnFirst allows only one Subscriber"));
            } else {
                Operators.error(actual, new CancellationException("FluxSwitchOnFirst has already been cancelled"));
            }
        }

        @Override
        boolean tryOnNext(CoreSubscriber<? super T> actual, T t) {
            actual.onNext(t);
            return true;
        }
    }

    static abstract class AbstractSwitchOnFirstMain<T, R>
    extends Flux<T>
    implements InnerOperator<T, R> {
        final ControlSubscriber<? super R> outer;
        final BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer;
        Subscription s;
        Throwable throwable;
        T first;
        boolean requestedOnce;
        boolean done;
        volatile CoreSubscriber<? super T> inner;
        static final AtomicReferenceFieldUpdater<AbstractSwitchOnFirstMain, CoreSubscriber> INNER = AtomicReferenceFieldUpdater.newUpdater(AbstractSwitchOnFirstMain.class, CoreSubscriber.class, "inner");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<AbstractSwitchOnFirstMain> WIP = AtomicIntegerFieldUpdater.newUpdater(AbstractSwitchOnFirstMain.class, "wip");

        AbstractSwitchOnFirstMain(CoreSubscriber<? super R> outer, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer, boolean cancelSourceOnComplete) {
            this.outer = outer instanceof Fuseable.ConditionalSubscriber ? new SwitchOnFirstConditionalControlSubscriber(this, (Fuseable.ConditionalSubscriber)outer, cancelSourceOnComplete) : new SwitchOnFirstControlSubscriber<R>(this, outer, cancelSourceOnComplete);
            this.transformer = transformer;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            boolean isCancelled;
            boolean bl = isCancelled = this.inner == Operators.EMPTY_SUBSCRIBER;
            if (key == Scannable.Attr.CANCELLED) {
                return isCancelled && !this.done;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done || isCancelled;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.outer;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                this.s = s2;
                this.outer.sendSubscription();
                if (this.inner != Operators.EMPTY_SUBSCRIBER) {
                    s2.request(1L);
                }
            }
        }

        @Override
        public void onNext(T t) {
            CoreSubscriber<T> i = this.inner;
            if (this.done || i == Operators.EMPTY_SUBSCRIBER) {
                Operators.onNextDropped(t, this.currentContext());
                return;
            }
            if (i == null) {
                Publisher<R> result;
                ControlSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.next(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return;
                }
                this.first = t;
                result.subscribe(o);
                return;
            }
            i.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            T f = this.first;
            CoreSubscriber<? super T> i = this.inner;
            if (this.done || i == Operators.EMPTY_SUBSCRIBER) {
                Operators.onErrorDropped(t, this.currentContext());
                return;
            }
            this.throwable = t;
            this.done = true;
            if (f == null && i == null) {
                Publisher<R> result;
                ControlSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.error(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return;
                }
                result.subscribe(o);
                return;
            }
            this.drain();
        }

        @Override
        public void onComplete() {
            T f = this.first;
            CoreSubscriber<? super T> i = this.inner;
            if (this.done || i == Operators.EMPTY_SUBSCRIBER) {
                return;
            }
            this.done = true;
            if (f == null && i == null) {
                Publisher<R> result;
                ControlSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.complete(o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, null, o.currentContext()));
                    return;
                }
                result.subscribe(o);
                return;
            }
            this.drain();
        }

        @Override
        public void cancel() {
            T f;
            if (INNER.getAndSet(this, Operators.EMPTY_SUBSCRIBER) == Operators.EMPTY_SUBSCRIBER) {
                return;
            }
            this.s.cancel();
            if (WIP.getAndIncrement(this) == 0 && (f = this.first) != null) {
                this.first = null;
                Operators.onDiscard(f, this.currentContext());
            }
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.first != null) {
                    this.requestedOnce = true;
                    if (this.drain() && n != Long.MAX_VALUE) {
                        if (--n > 0L) {
                            this.s.request(n);
                            return;
                        }
                        return;
                    }
                }
                this.s.request(n);
            }
        }

        boolean drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return false;
            }
            T f = this.first;
            int m3 = 1;
            boolean sent = false;
            do {
                CoreSubscriber<T> a;
                if ((a = this.inner) == null) continue;
                if (f != null && this.requestedOnce) {
                    this.first = null;
                    if (a == Operators.EMPTY_SUBSCRIBER) {
                        Operators.onDiscard(f, this.currentContext());
                        return false;
                    }
                    sent = this.tryOnNext(a, f);
                    f = null;
                    a = this.inner;
                }
                if (a == Operators.EMPTY_SUBSCRIBER) {
                    return false;
                }
                if (!this.done || f != null) continue;
                Throwable t = this.throwable;
                if (t != null) {
                    a.onError(t);
                } else {
                    a.onComplete();
                }
                INNER.lazySet(this, Operators.EMPTY_SUBSCRIBER);
                return sent;
            } while ((m3 = WIP.addAndGet(this, -m3)) != 0);
            return sent;
        }

        abstract boolean tryOnNext(CoreSubscriber<? super T> var1, T var2);
    }
}

