/*
 * Decompiled with CFR 0.152.
 */
package ua_parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ua_parser.OS;

public class OSParser {
    private final List<OSPattern> patterns;

    public OSParser(List<OSPattern> patterns) {
        this.patterns = patterns;
    }

    public static OSParser fromList(List<Map<String, String>> configList) {
        ArrayList<OSPattern> configPatterns = new ArrayList<OSPattern>();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(OSParser.patternFromMap(configMap));
        }
        return new OSParser(configPatterns);
    }

    public OS parse(String agentString) {
        if (agentString == null) {
            return null;
        }
        for (OSPattern p : this.patterns) {
            OS os = p.match(agentString);
            if (os == null) continue;
            return os;
        }
        return new OS("Other", null, null, null, null);
    }

    protected static OSPattern patternFromMap(Map<String, String> configMap) {
        String regex = configMap.get("regex");
        if (regex == null) {
            throw new IllegalArgumentException("OS is missing regex");
        }
        return new OSPattern(Pattern.compile(regex), configMap.get("os_replacement"), configMap.get("os_v1_replacement"), configMap.get("os_v2_replacement"));
    }

    protected static class OSPattern {
        private final Pattern pattern;
        private final String osReplacement;
        private final String v1Replacement;
        private final String v2Replacement;

        public OSPattern(Pattern pattern, String osReplacement, String v1Replacement, String v2Replacement) {
            this.pattern = pattern;
            this.osReplacement = osReplacement;
            this.v1Replacement = v1Replacement;
            this.v2Replacement = v2Replacement;
        }

        public OS match(String agentString) {
            String family = null;
            String v1 = null;
            String v2 = null;
            String v3 = null;
            String v4 = null;
            Matcher matcher = this.pattern.matcher(agentString);
            if (!matcher.find()) {
                return null;
            }
            int groupCount = matcher.groupCount();
            if (this.osReplacement != null) {
                family = this.osReplacement;
            } else if (groupCount >= 1) {
                family = matcher.group(1);
            }
            if (this.v1Replacement != null) {
                v1 = this.v1Replacement;
            } else if (groupCount >= 2) {
                v1 = matcher.group(2);
            }
            if (this.v2Replacement != null) {
                v2 = this.v2Replacement;
            } else if (groupCount >= 3) {
                v2 = matcher.group(3);
            }
            if (groupCount >= 4) {
                v3 = matcher.group(4);
                if (groupCount >= 5) {
                    v4 = matcher.group(5);
                }
            }
            return family == null ? null : new OS(family, v1, v2, v3, v4);
        }
    }
}

