/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.exception;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.util.CoreUtils;
import java.util.Locale;

public class SessionErrorContext
extends AmqpErrorContext {
    private static final long serialVersionUID = -6595933736672371232L;
    private final String entityPath;

    public SessionErrorContext(String namespace, String entityPath) {
        super(namespace);
        if (CoreUtils.isNullOrEmpty(entityPath)) {
            throw new IllegalArgumentException("'entityPath' cannot be null or empty");
        }
        this.entityPath = entityPath;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    @Override
    public String toString() {
        return String.join((CharSequence)", ", super.toString(), String.format(Locale.US, "PATH: %s", this.getEntityPath()));
    }
}

