/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.ReactorDispatcher;
import com.azure.core.amqp.implementation.handler.CustomIOHandler;
import com.azure.core.amqp.implementation.handler.ReactorHandler;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.util.Objects;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.ReactorOptions;

public class ReactorProvider {
    private final ClientLogger logger = new ClientLogger(ReactorProvider.class);
    private final Object lock = new Object();
    private Reactor reactor;
    private ReactorDispatcher reactorDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reactor getReactor() {
        Object object = this.lock;
        synchronized (object) {
            return this.reactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReactorDispatcher getReactorDispatcher() {
        Object object = this.lock;
        synchronized (object) {
            return this.reactorDispatcher;
        }
    }

    public Reactor createReactor(String connectionId, int maxFrameSize) throws IOException {
        CustomIOHandler globalHandler = new CustomIOHandler(connectionId);
        ReactorHandler reactorHandler = new ReactorHandler(connectionId);
        return this.createReactor(maxFrameSize, globalHandler, reactorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reactor createReactor(int maxFrameSize, Handler globalHandler, BaseHandler ... baseHandlers) throws IOException {
        Objects.requireNonNull(baseHandlers);
        Objects.requireNonNull(globalHandler);
        if (maxFrameSize <= 0) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'maxFrameSize' must be a positive number."));
        }
        ReactorOptions reactorOptions = new ReactorOptions();
        reactorOptions.setMaxFrameSize(maxFrameSize);
        reactorOptions.setEnableSaslByDefault(true);
        Reactor reactor = Proton.reactor(reactorOptions, (Handler[])baseHandlers);
        reactor.setGlobalHandler(globalHandler);
        ReactorDispatcher dispatcher = new ReactorDispatcher(reactor);
        Object object = this.lock;
        synchronized (object) {
            this.reactor = reactor;
            this.reactorDispatcher = dispatcher;
        }
        return this.reactor;
    }
}

