/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.UnixTime;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.ItemPage;
import com.azure.core.implementation.serializer.MalformedValueException;
import com.azure.core.util.Base64Url;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import reactor.core.publisher.Mono;

final class HttpResponseBodyDecoder {
    HttpResponseBodyDecoder() {
    }

    static Mono<Object> decode(String body, HttpResponse httpResponse, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        return HttpResponseBodyDecoder.decodeByteArray(body == null ? null : body.getBytes(StandardCharsets.UTF_8), httpResponse, serializer, decodeData);
    }

    static Mono<Object> decodeByteArray(byte[] body, HttpResponse httpResponse, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        ClientLogger logger = new ClientLogger(HttpResponseBodyDecoder.class);
        return Mono.defer(() -> {
            if (HttpResponseBodyDecoder.isErrorStatus(httpResponse, decodeData)) {
                Mono<byte[]> bodyMono = body == null ? httpResponse.getBodyAsByteArray() : Mono.just(body);
                return bodyMono.flatMap(bodyAsByteArray -> {
                    try {
                        Object decodedErrorEntity = HttpResponseBodyDecoder.deserializeBody(bodyAsByteArray, decodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType(), null, serializer, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
                        return Mono.justOrEmpty(decodedErrorEntity);
                    }
                    catch (MalformedValueException | IOException ex) {
                        logger.warning("Failed to deserialize the error entity.", ex);
                        return Mono.empty();
                    }
                });
            }
            if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
                return Mono.empty();
            }
            if (!HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData.getReturnType())) {
                return Mono.empty();
            }
            Mono<byte[]> bodyMono = body == null ? httpResponse.getBodyAsByteArray() : Mono.just(body);
            return bodyMono.flatMap(bodyAsByteArray -> {
                try {
                    Object decodedSuccessEntity = HttpResponseBodyDecoder.deserializeBody(bodyAsByteArray, HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData), decodeData.getReturnValueWireType(), serializer, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
                    return Mono.justOrEmpty(decodedSuccessEntity);
                }
                catch (MalformedValueException e) {
                    return Mono.error(new HttpResponseException("HTTP response has a malformed body.", httpResponse, e));
                }
                catch (IOException e) {
                    return Mono.error(new HttpResponseException("Deserialization Failed.", httpResponse, e));
                }
            });
        });
    }

    static Type decodedType(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse, decodeData)) {
            return decodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType();
        }
        if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        return HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData.getReturnType()) ? HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData) : null;
    }

    static boolean isErrorStatus(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        return !decodeData.isExpectedResponseStatusCode(httpResponse.getStatusCode());
    }

    private static Object deserializeBody(byte[] value, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        ByteArrayInputStream inputStream;
        ByteArrayInputStream byteArrayInputStream = inputStream = value == null || value.length == 0 ? null : new ByteArrayInputStream(value);
        if (wireType == null) {
            return serializer.deserialize(inputStream, resultType, encoding);
        }
        if (TypeUtil.isTypeOrSubTypeOf(wireType, Page.class)) {
            return HttpResponseBodyDecoder.deserializePage(inputStream, resultType, wireType, serializer, encoding);
        }
        Type wireResponseType = HttpResponseBodyDecoder.constructWireResponseType(resultType, wireType);
        Object wireResponse = serializer.deserialize(inputStream, wireResponseType, encoding);
        return HttpResponseBodyDecoder.convertToResultType(wireResponse, resultType, wireType);
    }

    private static Type constructWireResponseType(Type resultType, Type wireType) {
        Objects.requireNonNull(wireType);
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                return Base64Url.class;
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                return DateTimeRfc1123.class;
            }
            if (wireType == UnixTime.class) {
                return UnixTime.class;
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                Type wireResponseElementType = HttpResponseBodyDecoder.constructWireResponseType(resultElementType, wireType);
                return TypeUtil.createParameterizedType(((ParameterizedType)resultType).getRawType(), wireResponseElementType);
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type[] typeArguments = TypeUtil.getTypeArguments(resultType);
                Type resultValueType = typeArguments[1];
                Type wireResponseValueType = HttpResponseBodyDecoder.constructWireResponseType(resultValueType, wireType);
                return TypeUtil.createParameterizedType(((ParameterizedType)resultType).getRawType(), typeArguments[0], wireResponseValueType);
            }
        }
        return resultType;
    }

    private static Object deserializePage(InputStream inputStream, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        Type wireResponseType = wireType == Page.class ? TypeUtil.createParameterizedType(ItemPage.class, new Type[]{resultType}) : wireType;
        return serializer.deserialize(inputStream, wireResponseType, encoding);
    }

    private static Object convertToResultType(Object wireResponse, Type resultType, Type wireType) {
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                return ((Base64Url)wireResponse).decodedBytes();
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                return ((DateTimeRfc1123)wireResponse).getDateTime();
            }
            if (wireType == UnixTime.class) {
                return ((UnixTime)wireResponse).getDateTime();
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                List wireResponseList = (List)wireResponse;
                int wireResponseListSize = wireResponseList.size();
                for (int i = 0; i < wireResponseListSize; ++i) {
                    Object resultElement;
                    Object wireResponseElement = wireResponseList.get(i);
                    if (wireResponseElement == (resultElement = HttpResponseBodyDecoder.convertToResultType(wireResponseElement, resultElementType, wireType))) continue;
                    wireResponseList.set(i, resultElement);
                }
                return wireResponseList;
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type resultValueType = TypeUtil.getTypeArguments(resultType)[1];
                Map wireResponseMap = (Map)wireResponse;
                Set wireResponseEntries = wireResponseMap.entrySet();
                for (Map.Entry wireResponseEntry : wireResponseEntries) {
                    Object resultValue;
                    Object wireResponseValue = wireResponseEntry.getValue();
                    if (wireResponseValue == (resultValue = HttpResponseBodyDecoder.convertToResultType(wireResponseValue, resultValueType, wireType))) continue;
                    wireResponseMap.put((String)wireResponseEntry.getKey(), resultValue);
                }
                return wireResponseMap;
            }
        }
        return wireResponse;
    }

    private static Type extractEntityTypeFromReturnType(HttpResponseDecodeData decodeData) {
        Type token = decodeData.getReturnType();
        if (TypeUtil.isTypeOrSubTypeOf(token, Mono.class)) {
            token = TypeUtil.getTypeArgument(token);
        }
        if (TypeUtil.isTypeOrSubTypeOf(token, Response.class)) {
            token = TypeUtil.getRestResponseBodyType(token);
        }
        return token;
    }

    private static boolean isReturnTypeDecodable(Type returnType) {
        ParameterizedType parameterizedType;
        if (returnType == null) {
            return false;
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            returnType = TypeUtil.getTypeArgument(returnType);
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, ResponseBase.class) && (parameterizedType = (ParameterizedType)TypeUtil.getSuperType(returnType, ResponseBase.class)).getActualTypeArguments().length == 2) {
            returnType = parameterizedType.getActualTypeArguments()[1];
        }
        return !FluxUtil.isFluxByteBuffer(returnType) && !TypeUtil.isTypeOrSubTypeOf(returnType, byte[].class) && !TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) && !TypeUtil.isTypeOrSubTypeOf(returnType, Void.class);
    }

    private static void ensureRequestSet(HttpResponse httpResponse) {
        Objects.requireNonNull(httpResponse.getRequest());
        Objects.requireNonNull(httpResponse.getRequest().getHttpMethod());
    }
}

