/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.exception.AzureException;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.Messages;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.models.LastEnqueuedEventProperties;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

class EventHubMessageSerializer
implements MessageSerializer {
    private final ClientLogger logger = new ClientLogger(EventHubMessageSerializer.class);
    private static final Symbol LAST_ENQUEUED_SEQUENCE_NUMBER = Symbol.getSymbol("last_enqueued_sequence_number");
    private static final Symbol LAST_ENQUEUED_OFFSET = Symbol.getSymbol("last_enqueued_offset");
    private static final Symbol LAST_ENQUEUED_TIME_UTC = Symbol.getSymbol("last_enqueued_time_utc");
    private static final Symbol RETRIEVAL_TIME_UTC = Symbol.getSymbol("runtime_info_retrieval_time_utc");

    EventHubMessageSerializer() {
    }

    @Override
    public int getSize(Message amqpMessage) {
        int size;
        Map<CharSequence, Object> map;
        if (amqpMessage == null) {
            return 0;
        }
        int payloadSize = EventHubMessageSerializer.getPayloadSize(amqpMessage);
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations();
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        int annotationsSize = 0;
        int applicationPropertiesSize = 0;
        if (messageAnnotations != null) {
            map = messageAnnotations.getValue();
            for (Map.Entry<CharSequence, Object> entry : map.entrySet()) {
                size = EventHubMessageSerializer.sizeof(entry.getKey()) + EventHubMessageSerializer.sizeof(entry.getValue());
                annotationsSize += size;
            }
        }
        if (applicationProperties != null) {
            map = applicationProperties.getValue();
            for (Map.Entry<CharSequence, Object> entry : map.entrySet()) {
                size = EventHubMessageSerializer.sizeof(entry.getKey()) + EventHubMessageSerializer.sizeof(entry.getValue());
                applicationPropertiesSize += size;
            }
        }
        return annotationsSize + applicationPropertiesSize + payloadSize;
    }

    @Override
    public <T> Message serialize(T object) {
        Objects.requireNonNull(object, "'object' to serialize cannot be null.");
        if (!(object instanceof EventData)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Cannot serialize object that is not EventData. Clazz: " + object.getClass()));
        }
        EventData eventData = (EventData)object;
        Message message = Proton.message();
        if (eventData.getProperties() != null && !eventData.getProperties().isEmpty()) {
            message.setApplicationProperties(new ApplicationProperties(eventData.getProperties()));
        }
        EventHubMessageSerializer.setSystemProperties(eventData, message);
        message.setBody(new Data(new Binary(eventData.getBody())));
        return message;
    }

    @Override
    public <T> T deserialize(Message message, Class<T> clazz) {
        Objects.requireNonNull(message, "'message' cannot be null.");
        Objects.requireNonNull(clazz, "'clazz' cannot be null.");
        if (clazz == PartitionProperties.class || clazz == EventHubProperties.class) {
            return this.deserializeManagementResponse(message, clazz);
        }
        if (clazz == EventData.class) {
            return (T)this.deserializeEventData(message);
        }
        if (clazz == LastEnqueuedEventProperties.class) {
            return (T)this.deserializeEnqueuedEventProperties(message);
        }
        throw this.logger.logExceptionAsError(new IllegalArgumentException("Deserialization only supports EventData, PartitionProperties, or EventHubProperties."));
    }

    @Override
    public <T> List<T> deserializeList(Message message, Class<T> clazz) {
        return Collections.singletonList(this.deserialize(message, clazz));
    }

    private <T> T deserializeManagementResponse(Message message, Class<T> deserializedType) {
        if (!(message.getBody() instanceof AmqpValue)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Expected message.getBody() to be AmqpValue, but is: " + message.getBody()));
        }
        AmqpValue body = (AmqpValue)message.getBody();
        if (!(body.getValue() instanceof Map)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Expected message.getBody().getValue() to be of type Map"));
        }
        Map amqpBody = (Map)body.getValue();
        if (deserializedType == PartitionProperties.class) {
            return (T)this.toPartitionProperties(amqpBody);
        }
        if (deserializedType == EventHubProperties.class) {
            return (T)this.toEventHubProperties(amqpBody);
        }
        throw this.logger.logExceptionAsError(new IllegalArgumentException(String.format(Messages.CLASS_NOT_A_SUPPORTED_TYPE, deserializedType)));
    }

    private LastEnqueuedEventProperties deserializeEnqueuedEventProperties(Message message) {
        DeliveryAnnotations annotations = message.getDeliveryAnnotations();
        if (annotations == null || annotations.getValue() == null) {
            return null;
        }
        Map<Symbol, Object> deliveryAnnotations = annotations.getValue();
        Long lastSequenceNumber = this.getValue(deliveryAnnotations, LAST_ENQUEUED_SEQUENCE_NUMBER, Long.class);
        String lastEnqueuedOffset = this.getValue(deliveryAnnotations, LAST_ENQUEUED_OFFSET, String.class);
        Instant lastEnqueuedTime = this.getValue(deliveryAnnotations, LAST_ENQUEUED_TIME_UTC, Date.class).toInstant();
        Instant retrievalTime = this.getValue(deliveryAnnotations, RETRIEVAL_TIME_UTC, Date.class).toInstant();
        return new LastEnqueuedEventProperties(lastSequenceNumber, Long.valueOf(lastEnqueuedOffset), lastEnqueuedTime, retrievalTime);
    }

    private EventData deserializeEventData(Message message) {
        byte[] body;
        Section bodySection;
        Map<Symbol, Object> messageAnnotations = message.getMessageAnnotations().getValue();
        HashMap<String, Object> receiveProperties = new HashMap<String, Object>();
        for (Map.Entry<Symbol, Object> annotation : messageAnnotations.entrySet()) {
            receiveProperties.put(annotation.getKey().toString(), annotation.getValue());
        }
        if (message.getProperties() != null) {
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.MESSAGE_ID, message.getMessageId());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.USER_ID, message.getUserId());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.TO, message.getAddress());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.SUBJECT, message.getSubject());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.REPLY_TO, message.getReplyTo());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.CORRELATION_ID, message.getCorrelationId());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.CONTENT_TYPE, message.getContentType());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.CONTENT_ENCODING, message.getContentEncoding());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.ABSOLUTE_EXPIRY_TIME, message.getExpiryTime());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.CREATION_TIME, message.getCreationTime());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.GROUP_ID, message.getGroupId());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.GROUP_SEQUENCE, message.getGroupSequence());
            EventHubMessageSerializer.addMapEntry(receiveProperties, AmqpMessageConstant.REPLY_TO_GROUP_ID, message.getReplyToGroupId());
        }
        if ((bodySection = message.getBody()) instanceof Data) {
            Data bodyData = (Data)bodySection;
            body = bodyData.getValue().getArray();
        } else {
            this.logger.warning(String.format(Messages.MESSAGE_NOT_OF_TYPE, bodySection != null ? bodySection.getType() : "null"));
            body = new byte[]{};
        }
        EventData.SystemProperties systemProperties = new EventData.SystemProperties((Map<String, Object>)receiveProperties);
        EventData eventData = new EventData(body, systemProperties, Context.NONE);
        Map<Object, Object> properties = message.getApplicationProperties() == null ? new HashMap() : message.getApplicationProperties().getValue();
        properties.forEach((key, value) -> eventData.getProperties().put((String)key, value));
        message.clear();
        return eventData;
    }

    private EventHubProperties toEventHubProperties(Map<?, ?> amqpBody) {
        return new EventHubProperties(this.getValue(amqpBody, "name", String.class), this.getDate(amqpBody, "created_at"), this.getValue(amqpBody, "partition_ids", String[].class));
    }

    private PartitionProperties toPartitionProperties(Map<?, ?> amqpBody) {
        return new PartitionProperties(this.getValue(amqpBody, "name", String.class), this.getValue(amqpBody, "partition", String.class), this.getValue(amqpBody, "begin_sequence_number", Long.class), this.getValue(amqpBody, "last_enqueued_sequence_number", Long.class), this.getValue(amqpBody, "last_enqueued_offset", String.class), this.getDate(amqpBody, "last_enqueued_time_utc"), this.getValue(amqpBody, "is_partition_empty", Boolean.class));
    }

    private <T> T getValue(Map<?, ?> amqpBody, String key, Class<T> clazz) {
        if (!amqpBody.containsKey(key)) {
            throw this.logger.logExceptionAsError(new AzureException(String.format("AMQP body did not contain expected field '%s'.", key)));
        }
        return this.getValue(amqpBody.get(key), (Object)key, clazz);
    }

    private <T> T getValue(Map<Symbol, Object> amqpBody, Symbol key, Class<T> clazz) {
        if (!amqpBody.containsKey(key)) {
            throw this.logger.logExceptionAsError(new AzureException(String.format("AMQP body did not contain expected field '%s'.", key)));
        }
        return this.getValue(amqpBody.get(key), (Object)key, clazz);
    }

    private <T> T getValue(Object value, Object key, Class<T> clazz) {
        if (value == null) {
            throw this.logger.logExceptionAsError(new AzureException(String.format("AMQP body did not contain a value for key '%s'.", key)));
        }
        if (value.getClass() != clazz) {
            throw this.logger.logExceptionAsError(new AzureException(String.format("AMQP body did not contain correct value for key '%s'. Expected class: '%s'. Actual: '%s'", key, clazz, value.getClass())));
        }
        return (T)value;
    }

    private Instant getDate(Map<?, ?> amqpBody, String key) {
        Date value = this.getValue(amqpBody, key, Date.class);
        return value.toInstant();
    }

    private static void setSystemProperties(EventData eventData, Message message) {
        if (eventData.getSystemProperties() == null || eventData.getSystemProperties().isEmpty()) {
            return;
        }
        eventData.getSystemProperties().forEach((key, value) -> {
            block17: {
                block16: {
                    if (EventData.RESERVED_SYSTEM_PROPERTIES.contains(key)) {
                        return;
                    }
                    AmqpMessageConstant constant = AmqpMessageConstant.fromString(key);
                    if (constant == null) break block16;
                    switch (constant) {
                        case MESSAGE_ID: {
                            message.setMessageId(value);
                            break block17;
                        }
                        case USER_ID: {
                            message.setUserId((byte[])value);
                            break block17;
                        }
                        case TO: {
                            message.setAddress((String)value);
                            break block17;
                        }
                        case SUBJECT: {
                            message.setSubject((String)value);
                            break block17;
                        }
                        case REPLY_TO: {
                            message.setReplyTo((String)value);
                            break block17;
                        }
                        case CORRELATION_ID: {
                            message.setCorrelationId(value);
                            break block17;
                        }
                        case CONTENT_TYPE: {
                            message.setContentType((String)value);
                            break block17;
                        }
                        case CONTENT_ENCODING: {
                            message.setContentEncoding((String)value);
                            break block17;
                        }
                        case ABSOLUTE_EXPIRY_TIME: {
                            message.setExpiryTime((Long)value);
                            break block17;
                        }
                        case CREATION_TIME: {
                            message.setCreationTime((Long)value);
                            break block17;
                        }
                        case GROUP_ID: {
                            message.setGroupId((String)value);
                            break block17;
                        }
                        case GROUP_SEQUENCE: {
                            message.setGroupSequence((Long)value);
                            break block17;
                        }
                        case REPLY_TO_GROUP_ID: {
                            message.setReplyToGroupId((String)value);
                            break block17;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Property is not a recognized reserved property name: %s", key));
                        }
                    }
                }
                MessageAnnotations messageAnnotations = message.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap<Symbol, Object>()) : message.getMessageAnnotations();
                messageAnnotations.getValue().put(Symbol.getSymbol(key), value);
                message.setMessageAnnotations(messageAnnotations);
            }
        });
    }

    private static int getPayloadSize(Message msg) {
        if (msg == null || msg.getBody() == null) {
            return 0;
        }
        if (msg.getBody() instanceof Data) {
            Data payloadSection = (Data)msg.getBody();
            if (payloadSection == null) {
                return 0;
            }
            Binary payloadBytes = payloadSection.getValue();
            if (payloadBytes == null) {
                return 0;
            }
            return payloadBytes.getLength();
        }
        if (msg.getBody() instanceof AmqpValue) {
            AmqpValue amqpValue = (AmqpValue)msg.getBody();
            if (amqpValue == null) {
                return 0;
            }
            return amqpValue.getValue().toString().length() * 2;
        }
        return 0;
    }

    private static int sizeof(Object obj) {
        if (obj instanceof String) {
            return obj.toString().length() << 1;
        }
        if (obj instanceof Symbol) {
            return ((Symbol)obj).length() << 1;
        }
        if (obj instanceof Integer) {
            return 4;
        }
        if (obj instanceof Long) {
            return 8;
        }
        if (obj instanceof Short) {
            return 2;
        }
        if (obj instanceof Character) {
            return 2;
        }
        if (obj instanceof Float) {
            return 4;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof Date) {
            return 32;
        }
        throw new IllegalArgumentException(String.format(Messages.ENCODING_TYPE_NOT_SUPPORTED, obj.getClass()));
    }

    private static void addMapEntry(Map<String, Object> map, AmqpMessageConstant key, Object content) {
        if (content == null) {
            return;
        }
        map.put(key.getValue(), content);
    }
}

