/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.Context;
import com.moandjiezana.toml.Results;
import com.moandjiezana.toml.ValueReader;
import java.util.concurrent.atomic.AtomicInteger;

class LiteralStringValueReader
implements ValueReader {
    static final LiteralStringValueReader LITERAL_STRING_VALUE_READER = new LiteralStringValueReader();

    @Override
    public boolean canRead(String s2) {
        return s2.startsWith("'");
    }

    @Override
    public Object read(String s2, AtomicInteger index, Context context) {
        int startLine = context.line.get();
        boolean terminated = false;
        int startIndex = index.incrementAndGet();
        int i = index.get();
        while (i < s2.length()) {
            char c = s2.charAt(i);
            if (c == '\'') {
                terminated = true;
                break;
            }
            i = index.incrementAndGet();
        }
        if (!terminated) {
            Results.Errors errors = new Results.Errors();
            errors.unterminated(context.identifier.getName(), s2.substring(startIndex), startLine);
            return errors;
        }
        String substring = s2.substring(startIndex, index.get());
        return substring;
    }

    private LiteralStringValueReader() {
    }
}

