/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.Context;
import com.moandjiezana.toml.Results;
import com.moandjiezana.toml.StringValueReaderWriter;
import com.moandjiezana.toml.ValueReader;
import java.util.concurrent.atomic.AtomicInteger;

class MultilineStringValueReader
implements ValueReader {
    static final MultilineStringValueReader MULTILINE_STRING_VALUE_READER = new MultilineStringValueReader();

    @Override
    public boolean canRead(String s2) {
        return s2.startsWith("\"\"\"");
    }

    @Override
    public Object read(String s2, AtomicInteger index, Context context) {
        AtomicInteger line = context.line;
        int startLine = line.get();
        int originalStartIndex = index.get();
        int startIndex = index.addAndGet(3);
        int endIndex = -1;
        if (s2.charAt(startIndex) == '\n') {
            startIndex = index.incrementAndGet();
            line.incrementAndGet();
        }
        int i = startIndex;
        while (i < s2.length()) {
            char c = s2.charAt(i);
            if (c == '\n') {
                line.incrementAndGet();
            } else if (c == '\"' && s2.length() > i + 2 && s2.charAt(i + 1) == '\"' && s2.charAt(i + 2) == '\"') {
                endIndex = i;
                index.addAndGet(2);
                break;
            }
            i = index.incrementAndGet();
        }
        if (endIndex == -1) {
            Results.Errors errors = new Results.Errors();
            errors.unterminated(context.identifier.getName(), s2.substring(originalStartIndex), startLine);
            return errors;
        }
        s2 = s2.substring(startIndex, endIndex);
        s2 = s2.replaceAll("\\\\\\s+", "");
        s2 = StringValueReaderWriter.STRING_VALUE_READER_WRITER.replaceUnicodeCharacters(s2);
        s2 = StringValueReaderWriter.STRING_VALUE_READER_WRITER.replaceSpecialCharacters(s2);
        return s2;
    }

    private MultilineStringValueReader() {
    }
}

