/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Iterables;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.AbstractModelConverter;
import io.swagger.jackson.JAXBAnnotationsHelper;
import io.swagger.jackson.TypeNameResolver;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Xml;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.util.AllowableValues;
import io.swagger.util.AllowableValuesUtils;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.PrimitiveType;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelResolver
extends AbstractModelConverter
implements ModelConverter {
    Logger LOGGER = LoggerFactory.getLogger(ModelResolver.class);

    public ModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    public ModelResolver(ObjectMapper mapper, TypeNameResolver typeNameResolver) {
        super(mapper, typeNameResolver);
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    protected boolean shouldIgnoreClass(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.getName().equals("javax.ws.rs.Response")) {
                return true;
            }
        } else if (type instanceof ResolvedType) {
            ResolvedType rt = (ResolvedType)((Object)type);
            this.LOGGER.debug("Can't check class {}, {}", type, (Object)rt.getRawClass().getName());
            if (rt.getRawClass().equals(Class.class)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolveProperty(this._mapper.constructType(type), context, annotations, next);
    }

    public Property resolveProperty(JavaType propType, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        this.LOGGER.debug("resolveProperty {}", propType);
        Property property = null;
        if (propType.isContainerType()) {
            JavaType keyType = propType.getKeyType();
            JavaType valueType = propType.getContentType();
            if (keyType != null && valueType != null) {
                property = new MapProperty().additionalProperties(context.resolveProperty(valueType, new Annotation[0]));
            } else if (valueType != null) {
                Property items = context.resolveProperty(valueType, new Annotation[0]);
                if (annotations != null && annotations.length > 0) {
                    for (Annotation annotation : annotations) {
                        XmlElement xmlElement;
                        if (!(annotation instanceof XmlElement) || (xmlElement = (XmlElement)annotation) == null || xmlElement.name() == null || "".equals(xmlElement.name()) || "##default".equals(xmlElement.name())) continue;
                        Xml xml = items.getXml() != null ? items.getXml() : new Xml();
                        xml.setName(xmlElement.name());
                        items.setXml(xml);
                    }
                }
                ArrayProperty arrayProperty = new ArrayProperty().items(items);
                if (this._isSetType(propType.getRawClass())) {
                    arrayProperty.setUniqueItems(true);
                }
                property = arrayProperty;
            }
        } else {
            property = PrimitiveType.createProperty(propType);
        }
        if (property == null) {
            if (propType.isEnumType()) {
                property = new StringProperty();
                this._addEnumProps(propType.getRawClass(), (StringProperty)property);
            } else if (this._isOptionalType(propType)) {
                property = context.resolveProperty(propType.containedType(0), null);
            } else {
                Model innerModel = context.resolve(propType);
                if (innerModel instanceof ComposedModel) {
                    innerModel = ((ComposedModel)innerModel).getChild();
                }
                if (innerModel instanceof ModelImpl) {
                    ModelImpl mi = (ModelImpl)innerModel;
                    property = StringUtils.isNotEmpty(mi.getReference()) ? new RefProperty(mi.getReference()) : new RefProperty(mi.getName(), RefFormat.INTERNAL);
                }
            }
        }
        return property;
    }

    private boolean _isOptionalType(JavaType propType) {
        return Arrays.asList("com.google.common.base.Optional", "java.util.Optional").contains(propType.getRawClass().getCanonicalName());
    }

    @Override
    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolve(this._mapper.constructType(type), context, next);
    }

    protected void _addEnumProps(Class<?> propClass, StringProperty property) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : en.name());
            property._enum(n);
        }
        if (!useIndex && !useToString) {
            property._enum(Arrays.asList(this._intr.findEnumValues(propClass, (Enum[])enumClass.getEnumConstants(), property.getEnum().toArray(new String[0]))));
        }
    }

    public Model resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> next) {
        Class<?> parentClass;
        JsonTypeInfo typeInfo;
        String disc;
        XmlRootElement rootAnnotation;
        if (type.isEnumType() || PrimitiveType.fromType(type) != null) {
            return null;
        }
        Object beanDesc = this._mapper.getSerializationConfig().introspect(type);
        String name = this._typeName(type, (BeanDescription)beanDesc);
        if ("Object".equals(name)) {
            return new ModelImpl();
        }
        name = this.decorateModelName(context, name);
        Model resolvedModel = context.resolve(type.getRawClass());
        if (resolvedModel != null) {
            Model childModel;
            if (!(resolvedModel instanceof ModelImpl) && !(resolvedModel instanceof ComposedModel) || resolvedModel instanceof ModelImpl && ((ModelImpl)resolvedModel).getName().equals(name)) {
                return resolvedModel;
            }
            if (resolvedModel instanceof ComposedModel && (childModel = ((ComposedModel)resolvedModel).getChild()) != null && (!(childModel instanceof ModelImpl) || ((ModelImpl)childModel).getName().equals(name))) {
                return resolvedModel;
            }
        }
        ModelImpl model = new ModelImpl().type("object").name(name).description(this._description(((BeanDescription)beanDesc).getClassInfo()));
        if (!type.isContainerType()) {
            context.defineModel(name, model, type, null);
        }
        if (type.isContainerType()) {
            context.resolve(type.getContentType());
            return null;
        }
        ApiModel apiModel = ((BeanDescription)beanDesc).getClassAnnotations().get(ApiModel.class);
        if (apiModel != null && StringUtils.isNotEmpty(apiModel.reference())) {
            model.setReference(apiModel.reference());
        }
        if ((rootAnnotation = ((BeanDescription)beanDesc).getClassAnnotations().get(XmlRootElement.class)) != null && !"".equals(rootAnnotation.name()) && !"##default".equals(rootAnnotation.name())) {
            this.LOGGER.debug("{}", rootAnnotation);
            Xml xml = new Xml().name(rootAnnotation.name());
            if (rootAnnotation.namespace() != null && !"".equals(rootAnnotation.namespace()) && !"##default".equals(rootAnnotation.namespace())) {
                xml.namespace(rootAnnotation.namespace());
            } else {
                XmlSchema xmlSchma;
                Package pkg = type.getRawClass().getPackage();
                if (pkg != null && (xmlSchma = pkg.getAnnotation(XmlSchema.class)) != null) {
                    xml.namespace(xmlSchma.namespace());
                }
            }
            model.xml(xml);
        }
        XmlAccessorType xmlAccessorTypeAnnotation = ((BeanDescription)beanDesc).getClassAnnotations().get(XmlAccessorType.class);
        JsonSerialize jasonSerialize = ((BeanDescription)beanDesc).getClassAnnotations().get(JsonSerialize.class);
        if (jasonSerialize != null && jasonSerialize.as() != null) {
            JavaType asType = this._mapper.constructType(jasonSerialize.as());
            beanDesc = this._mapper.getSerializationConfig().introspect(asType);
        }
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        JsonIgnoreProperties ignoreProperties = ((BeanDescription)beanDesc).getClassAnnotations().get(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            propertiesToIgnore.addAll(Arrays.asList(ignoreProperties.value()));
        }
        String string = disc = apiModel == null ? "" : apiModel.discriminator();
        if (disc.isEmpty() && (typeInfo = ((BeanDescription)beanDesc).getClassAnnotations().get(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            model.setDiscriminator(disc);
        }
        ArrayList<Property> props = new ArrayList<Property>();
        for (BeanPropertyDefinition beanPropertyDefinition : ((BeanDescription)beanDesc).findProperties()) {
            AllowableValues allowableValues;
            Boolean readOnlyFromAccessMode;
            Integer index;
            String description;
            Boolean required;
            JsonProperty pd;
            Property property = null;
            String propName = beanPropertyDefinition.getName();
            Annotation[] annotations = null;
            if (beanPropertyDefinition.getPrimaryMember() != null) {
                String altName;
                Member member = beanPropertyDefinition.getPrimaryMember().getMember();
                JsonProperty jsonPropertyAnn = beanPropertyDefinition.getPrimaryMember().getAnnotation(JsonProperty.class);
                if (!(jsonPropertyAnn != null && jsonPropertyAnn.value().equals(propName) || member == null || (altName = member.getName()) == null)) {
                    int length = altName.length();
                    for (String prefix : Arrays.asList("get", "is")) {
                        int offset = prefix.length();
                        if (!altName.startsWith(prefix) || length <= offset || Character.isUpperCase(altName.charAt(offset))) continue;
                        propName = altName;
                        break;
                    }
                }
            }
            PropertyMetadata md = beanPropertyDefinition.getMetadata();
            boolean hasSetter = false;
            boolean hasGetter = false;
            try {
                hasSetter = beanPropertyDefinition.getSetter() != null;
            }
            catch (IllegalArgumentException e) {
                hasSetter = true;
            }
            if (beanPropertyDefinition.getGetter() != null && (pd = beanPropertyDefinition.getGetter().getAnnotation(JsonProperty.class)) != null) {
                hasGetter = true;
            }
            Boolean isReadOnly = null;
            isReadOnly = !hasSetter & hasGetter ? Boolean.TRUE : Boolean.FALSE;
            AnnotatedMember member = beanPropertyDefinition.getPrimaryMember();
            Boolean allowEmptyValue = null;
            if (member == null || this.ignore(member, xmlAccessorTypeAnnotation, propName, propertiesToIgnore)) continue;
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Annotation a : member.annotations()) {
                annotationList.add(a);
            }
            annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            if (this.hiddenByJsonView(annotations, context)) continue;
            ApiModelProperty mp = member.getAnnotation(ApiModelProperty.class);
            if (mp != null && mp.readOnly()) {
                isReadOnly = mp.readOnly();
            }
            allowEmptyValue = mp != null && mp.allowEmptyValue() ? Boolean.valueOf(mp.allowEmptyValue()) : null;
            JavaType propType = member.getType(((BeanDescription)beanDesc).bindingsForBeanType());
            if (mp != null && !mp.name().isEmpty()) {
                propName = mp.name();
            }
            if (mp != null && !mp.dataType().isEmpty()) {
                String or = mp.dataType();
                JavaType innerJavaType = null;
                this.LOGGER.debug("overriding datatype from {} to {}", propType, (Object)or);
                if (or.toLowerCase().startsWith("list[")) {
                    String innerType = or.substring(5, or.length() - 1);
                    ArrayProperty p = new ArrayProperty();
                    Property primitiveProperty = PrimitiveType.createProperty(innerType);
                    if (primitiveProperty != null) {
                        p.setItems(primitiveProperty);
                    } else {
                        innerJavaType = this.getInnerType(innerType);
                        p.setItems(context.resolveProperty(innerJavaType, annotations));
                    }
                    property = p;
                } else if (or.toLowerCase().startsWith("map[")) {
                    int pos = or.indexOf(",");
                    if (pos > 0) {
                        String innerType = or.substring(pos + 1, or.length() - 1);
                        MapProperty p = new MapProperty();
                        Property primitiveProperty = PrimitiveType.createProperty(innerType);
                        if (primitiveProperty != null) {
                            p.setAdditionalProperties(primitiveProperty);
                        } else {
                            innerJavaType = this.getInnerType(innerType);
                            p.setAdditionalProperties(context.resolveProperty(innerJavaType, annotations));
                        }
                        property = p;
                    }
                } else {
                    Property primitiveProperty = PrimitiveType.createProperty(or);
                    if (primitiveProperty != null) {
                        property = primitiveProperty;
                    } else {
                        innerJavaType = this.getInnerType(or);
                        property = context.resolveProperty(innerJavaType, annotations);
                    }
                }
                if (innerJavaType != null) {
                    context.resolve(innerJavaType);
                }
            }
            if (property == null) {
                if (mp != null && StringUtils.isNotEmpty(mp.reference())) {
                    property = new RefProperty(mp.reference());
                } else if (member.getAnnotation(JsonIdentityInfo.class) != null) {
                    property = GeneratorWrapper.processJsonIdentity(propType, context, this._mapper, member.getAnnotation(JsonIdentityInfo.class), member.getAnnotation(JsonIdentityReference.class));
                }
                if (property == null) {
                    JsonUnwrapped uw = member.getAnnotation(JsonUnwrapped.class);
                    if (uw != null && uw.enabled()) {
                        this.handleUnwrapped(props, context.resolve(propType), uw.prefix(), uw.suffix());
                    } else {
                        property = context.resolveProperty(propType, annotations);
                    }
                }
            }
            if (property == null) continue;
            property.setName(propName);
            if (mp != null && !mp.access().isEmpty()) {
                property.setAccess(mp.access());
            }
            if ((required = md.getRequired()) != null) {
                property.setRequired(required);
            }
            if ((description = this._intr.findPropertyDescription(member)) != null && !"".equals(description)) {
                property.setDescription(description);
            }
            if ((index = this._intr.findPropertyIndex(member)) != null) {
                property.setPosition(index);
            }
            property.setDefault(this._findDefaultValue(member));
            property.setExample(this._findExampleValue(member));
            property.setReadOnly(this._findReadOnly(member));
            if (allowEmptyValue != null) {
                property.setAllowEmptyValue(allowEmptyValue);
            }
            if (property.getReadOnly() == null && isReadOnly.booleanValue()) {
                property.setReadOnly(isReadOnly);
            }
            if ((readOnlyFromAccessMode = this._findReadOnlyFromAccessMode(member)) != null) {
                property.setReadOnly(readOnlyFromAccessMode);
            }
            if (mp != null && (allowableValues = AllowableValuesUtils.create(mp.allowableValues())) != null) {
                Map<PropertyBuilder.PropertyId, Object> args = allowableValues.asPropertyArguments();
                PropertyBuilder.merge(property, args);
            }
            if (mp != null && mp.extensions() != null) {
                property.getVendorExtensions().clear();
                property.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions(mp.extensions()));
            }
            JAXBAnnotationsHelper.apply(member, property);
            this.applyBeanValidatorAnnotations(property, annotations);
            props.add(property);
        }
        Collections.sort(props, ModelResolver.getPropertyComparator());
        LinkedHashMap<String, Property> modelProps = new LinkedHashMap<String, Property>();
        for (Property prop : props) {
            modelProps.put(prop.getName(), prop);
        }
        model.setProperties(modelProps);
        Class<?> clazz = type.getRawClass();
        context.defineModel(name, model, clazz, null);
        if (!this.resolveSubtypes(model, (BeanDescription)beanDesc, context)) {
            model.setDiscriminator(null);
        }
        if (apiModel != null && (parentClass = apiModel.parent()) != null && !parentClass.equals(Void.class) && !this.shouldIgnoreClass(parentClass)) {
            Class<?>[] apiModelSubTypes;
            JavaType parentType = this._mapper.constructType(parentClass);
            Object parentBeanDesc = this._mapper.getSerializationConfig().introspect(parentType);
            boolean currentTypeIsParentSubType = false;
            List<NamedType> subTypes = this._intr.findSubtypes(((BeanDescription)parentBeanDesc).getClassInfo());
            if (subTypes != null) {
                for (NamedType subType : subTypes) {
                    if (!subType.getType().equals(clazz)) continue;
                    currentTypeIsParentSubType = true;
                    break;
                }
            }
            boolean currentTypeIsParentApiModelSubType = false;
            ApiModel parentApiModel = ((BeanDescription)parentBeanDesc).getClassAnnotations().get(ApiModel.class);
            if (parentApiModel != null && (apiModelSubTypes = parentApiModel.subTypes()) != null) {
                for (Class<?> subType : apiModelSubTypes) {
                    if (!subType.equals(clazz)) continue;
                    currentTypeIsParentApiModelSubType = true;
                    break;
                }
            }
            if (currentTypeIsParentSubType && currentTypeIsParentApiModelSubType) {
                context.resolve(parentClass);
                return context.resolve(clazz);
            }
        }
        return model;
    }

    protected String decorateModelName(ModelConverterContext context, String originalName) {
        String name = originalName;
        if (context.getJsonView() != null && context.getJsonView().value().length > 0) {
            String COMBINER = "-or-";
            StringBuffer sb = new StringBuffer();
            for (Class<?> view : context.getJsonView().value()) {
                sb.append(view.getSimpleName()).append(COMBINER);
            }
            String suffix = sb.toString().substring(0, sb.length() - COMBINER.length());
            name = originalName + "_" + suffix;
        }
        return name;
    }

    private boolean hiddenByJsonView(Annotation[] annotations, ModelConverterContext context) {
        JsonView jsonView = context.getJsonView();
        if (jsonView == null) {
            return false;
        }
        Class<?>[] filters = jsonView.value();
        boolean containsJsonViewAnnotation = false;
        for (Annotation ant : annotations) {
            if (!(ant instanceof JsonView)) continue;
            containsJsonViewAnnotation = true;
            Class<?>[] views = ((JsonView)ant).value();
            for (Class<?> f : filters) {
                for (Class<?> v : views) {
                    if (v != f && !v.isAssignableFrom(f)) continue;
                    return false;
                }
            }
        }
        return containsJsonViewAnnotation;
    }

    protected boolean ignore(Annotated member, XmlAccessorType xmlAccessorTypeAnnotation, String propName, Set<String> propertiesToIgnore) {
        if (propertiesToIgnore.contains(propName)) {
            return true;
        }
        if (member.hasAnnotation(JsonIgnore.class)) {
            return true;
        }
        if (xmlAccessorTypeAnnotation == null) {
            return false;
        }
        return xmlAccessorTypeAnnotation.value().equals((Object)XmlAccessType.NONE) && !member.hasAnnotation(XmlElement.class) && !member.hasAnnotation(XmlAttribute.class) && !member.hasAnnotation(XmlElementRef.class) && !member.hasAnnotation(XmlElementRefs.class) && !member.hasAnnotation(JsonProperty.class);
    }

    private void handleUnwrapped(List<Property> props, Model innerModel, String prefix, String suffix) {
        if (StringUtils.isBlank(suffix) && StringUtils.isBlank(prefix)) {
            Map<String, Property> innerProps;
            if (innerModel != null && (innerProps = innerModel.getProperties()) != null) {
                props.addAll(innerProps.values());
            }
        } else {
            if (prefix == null) {
                prefix = "";
            }
            if (suffix == null) {
                suffix = "";
            }
            for (Property prop : innerModel.getProperties().values()) {
                props.add(prop.rename(prefix + prop.getName() + suffix));
            }
        }
    }

    protected void applyBeanValidatorAnnotations(Property property, Annotation[] annotations) {
        Annotation max;
        Annotation min2;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                annos.put(anno.annotationType().getName(), anno);
            }
        }
        if (annos.containsKey("javax.validation.constraints.NotNull")) {
            property.setRequired(true);
        }
        if (annos.containsKey("javax.validation.constraints.Min") && property instanceof AbstractNumericProperty) {
            min2 = (Min)annos.get("javax.validation.constraints.Min");
            AbstractNumericProperty ap = (AbstractNumericProperty)property;
            ap.setMinimum(new BigDecimal(min2.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Max") && property instanceof AbstractNumericProperty) {
            max = (Max)annos.get("javax.validation.constraints.Max");
            AbstractNumericProperty ap = (AbstractNumericProperty)property;
            ap.setMaximum(new BigDecimal(max.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Size")) {
            Size size = (Size)annos.get("javax.validation.constraints.Size");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                ap.setMinimum(new BigDecimal(size.min()));
                ap.setMaximum(new BigDecimal(size.max()));
            } else if (property instanceof StringProperty) {
                StringProperty sp = (StringProperty)property;
                sp.minLength(new Integer(size.min()));
                sp.maxLength(new Integer(size.max()));
            } else if (property instanceof ArrayProperty) {
                ArrayProperty sp = (ArrayProperty)property;
                sp.setMinItems(size.min());
                sp.setMaxItems(size.max());
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMin")) {
            min2 = (DecimalMin)annos.get("javax.validation.constraints.DecimalMin");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                ap.setMinimum(new BigDecimal(min2.value()));
                ap.setExclusiveMinimum(!min2.inclusive());
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMax")) {
            max = (DecimalMax)annos.get("javax.validation.constraints.DecimalMax");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                ap.setMaximum(new BigDecimal(max.value()));
                ap.setExclusiveMaximum(!max.inclusive());
            }
        }
        if (annos.containsKey("javax.validation.constraints.Pattern")) {
            Pattern pattern = (Pattern)annos.get("javax.validation.constraints.Pattern");
            if (property instanceof StringProperty) {
                StringProperty ap = (StringProperty)property;
                ap.setPattern(pattern.regexp());
            }
        }
    }

    protected JavaType getInnerType(String innerType) {
        try {
            Class<?> innerClass = ReflectionUtils.loadClassByName(innerType);
            if (innerClass != null) {
                TypeFactory tf = this._mapper.getTypeFactory();
                return tf.constructType(innerClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean resolveSubtypes(ModelImpl model, BeanDescription bean, ModelConverterContext context) {
        List<NamedType> types = this._intr.findSubtypes(bean.getClassInfo());
        if (types == null) {
            return false;
        }
        this.removeSuperClassAndInterfaceSubTypes(types, bean);
        int count = 0;
        AnnotatedElement beanClass = bean.getClassInfo().getAnnotated();
        for (NamedType subtype : types) {
            Model subtypeModel;
            Class<?> subtypeType = subtype.getType();
            if (!((Class)beanClass).isAssignableFrom(subtypeType) || !((subtypeModel = context.resolve(subtypeType)) instanceof ModelImpl)) continue;
            ModelImpl impl = (ModelImpl)subtypeModel;
            if (impl.getName().equals(model.getName())) {
                impl.setName(this._typeNameResolver.nameForType(this._mapper.constructType(subtypeType), TypeNameResolver.Options.SKIP_API_MODEL));
            }
            Map<String, Property> baseProps = model.getProperties();
            Map<String, Property> subtypeProps = impl.getProperties();
            if (baseProps != null && subtypeProps != null) {
                for (Map.Entry<String, Property> entry : baseProps.entrySet()) {
                    if (!entry.getValue().equals(subtypeProps.get(entry.getKey()))) continue;
                    subtypeProps.remove(entry.getKey());
                }
            }
            impl.setDiscriminator(null);
            ComposedModel child = new ComposedModel().parent(new RefModel(model.getName(), RefFormat.INTERNAL)).child(impl);
            context.defineModel(impl.getName(), child, subtypeType, null);
            ++count;
        }
        return count != 0;
    }

    private void removeSuperClassAndInterfaceSubTypes(List<NamedType> types, BeanDescription bean) {
        Class<?> beanClass = bean.getType().getRawClass();
        Class<?> superClass = beanClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.removeSuperSubTypes(types, superClass);
        }
        if (!types.isEmpty()) {
            Class<?>[] superInterfaces;
            for (Class<?> superInterface : superInterfaces = beanClass.getInterfaces()) {
                this.removeSuperSubTypes(types, superInterface);
                if (types.isEmpty()) break;
            }
        }
    }

    private void removeSuperSubTypes(List<NamedType> resultTypes, Class<?> superClass) {
        JavaType superType = this._mapper.constructType(superClass);
        Object superBean = this._mapper.getSerializationConfig().introspect(superType);
        List<NamedType> superTypes = this._intr.findSubtypes(((BeanDescription)superBean).getClassInfo());
        if (superTypes != null) {
            resultTypes.removeAll(superTypes);
        }
    }

    private static enum GeneratorWrapper {
        PROPERTY(ObjectIdGenerators.PropertyGenerator.class){

            @Override
            protected Property processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected Property processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                Object beanDesc = mapper.getSerializationConfig().introspect(type);
                for (BeanPropertyDefinition def : ((BeanDescription)beanDesc).findProperties()) {
                    String name = def.getName();
                    if (name == null || !name.equals(propertyName)) continue;
                    AnnotatedMember propMember = def.getPrimaryMember();
                    JavaType propType = propMember.getType(((BeanDescription)beanDesc).bindingsForBeanType());
                    if (PrimitiveType.fromType(propType) != null) {
                        return PrimitiveType.createProperty(propType);
                    }
                    return context.resolveProperty(propType, Iterables.toArray(propMember.annotations(), Annotation.class));
                }
                return null;
            }
        }
        ,
        INT(ObjectIdGenerators.IntSequenceGenerator.class){

            @Override
            protected Property processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                IntegerProperty id = new IntegerProperty();
                return GeneratorWrapper.process(id, propertyName, type, context);
            }

            @Override
            protected Property processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return new IntegerProperty();
            }
        }
        ,
        UUID(ObjectIdGenerators.UUIDGenerator.class){

            @Override
            protected Property processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                UUIDProperty id = new UUIDProperty();
                return GeneratorWrapper.process(id, propertyName, type, context);
            }

            @Override
            protected Property processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return new UUIDProperty();
            }
        }
        ,
        NONE(ObjectIdGenerators.None.class){

            @Override
            protected Property processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected Property processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }
        };

        private final Class<? extends ObjectIdGenerator> generator;

        private GeneratorWrapper(Class<? extends ObjectIdGenerator> generator) {
            this.generator = generator;
        }

        protected abstract Property processAsProperty(String var1, JavaType var2, ModelConverterContext var3, ObjectMapper var4);

        protected abstract Property processAsId(String var1, JavaType var2, ModelConverterContext var3, ObjectMapper var4);

        public static Property processJsonIdentity(JavaType type, ModelConverterContext context, ObjectMapper mapper, JsonIdentityInfo identityInfo, JsonIdentityReference identityReference) {
            GeneratorWrapper wrapper;
            GeneratorWrapper generatorWrapper = wrapper = identityInfo != null ? GeneratorWrapper.getWrapper(identityInfo.generator()) : null;
            if (wrapper == null) {
                return null;
            }
            if (identityReference != null && identityReference.alwaysAsId()) {
                return wrapper.processAsId(identityInfo.property(), type, context, mapper);
            }
            return wrapper.processAsProperty(identityInfo.property(), type, context, mapper);
        }

        private static GeneratorWrapper getWrapper(Class<?> generator) {
            for (GeneratorWrapper value : GeneratorWrapper.values()) {
                if (!value.generator.isAssignableFrom(generator)) continue;
                return value;
            }
            return null;
        }

        private static Property process(Property id, String propertyName, JavaType type, ModelConverterContext context) {
            id.setName(propertyName);
            Model model = context.resolve(type);
            if (model instanceof ComposedModel) {
                model = ((ComposedModel)model).getChild();
            }
            if (model instanceof ModelImpl) {
                ModelImpl mi = (ModelImpl)model;
                mi.getProperties().put(propertyName, id);
                return new RefProperty(StringUtils.isNotEmpty(mi.getReference()) ? mi.getReference() : mi.getName());
            }
            return null;
        }
    }
}

