/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class DroppingWritableBuffer
implements WritableBuffer {
    private int _pos = 0;

    @Override
    public boolean hasRemaining() {
        return true;
    }

    @Override
    public void put(byte b) {
        ++this._pos;
    }

    @Override
    public void putFloat(float f) {
        this._pos += 4;
    }

    @Override
    public void putDouble(double d) {
        this._pos += 8;
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        this._pos += length;
    }

    @Override
    public void putShort(short s2) {
        this._pos += 2;
    }

    @Override
    public void putInt(int i) {
        this._pos += 4;
    }

    @Override
    public void putLong(long l) {
        this._pos += 8;
    }

    @Override
    public int remaining() {
        return Integer.MAX_VALUE - this._pos;
    }

    @Override
    public int position() {
        return this._pos;
    }

    @Override
    public void position(int position) {
        this._pos = position;
    }

    @Override
    public void put(ByteBuffer payload) {
        this._pos += payload.remaining();
        payload.position(payload.limit());
    }

    @Override
    public int limit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void put(ReadableBuffer payload) {
        this._pos += payload.remaining();
        payload.position(payload.limit());
    }

    @Override
    public void put(String value) {
        this._pos += value.getBytes(StandardCharsets.UTF_8).length;
    }
}

