/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.BigIntegerType;
import org.apache.qpid.proton.codec.BinaryType;
import org.apache.qpid.proton.codec.BooleanType;
import org.apache.qpid.proton.codec.ByteBufferEncoder;
import org.apache.qpid.proton.codec.ByteType;
import org.apache.qpid.proton.codec.CharacterType;
import org.apache.qpid.proton.codec.Decimal128Type;
import org.apache.qpid.proton.codec.Decimal32Type;
import org.apache.qpid.proton.codec.Decimal64Type;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.DoubleType;
import org.apache.qpid.proton.codec.DynamicDescribedType;
import org.apache.qpid.proton.codec.FloatType;
import org.apache.qpid.proton.codec.IntegerType;
import org.apache.qpid.proton.codec.ListType;
import org.apache.qpid.proton.codec.LongType;
import org.apache.qpid.proton.codec.MapType;
import org.apache.qpid.proton.codec.NullType;
import org.apache.qpid.proton.codec.ShortType;
import org.apache.qpid.proton.codec.StringType;
import org.apache.qpid.proton.codec.SymbolType;
import org.apache.qpid.proton.codec.TimestampType;
import org.apache.qpid.proton.codec.UUIDType;
import org.apache.qpid.proton.codec.UnsignedByteType;
import org.apache.qpid.proton.codec.UnsignedIntegerType;
import org.apache.qpid.proton.codec.UnsignedLongType;
import org.apache.qpid.proton.codec.UnsignedShortType;
import org.apache.qpid.proton.codec.WritableBuffer;

public final class EncoderImpl
implements ByteBufferEncoder {
    private static final byte DESCRIBED_TYPE_OP = 0;
    private WritableBuffer _buffer;
    private final DecoderImpl _decoder;
    private final Map<Class, AMQPType> _typeRegistry = new HashMap<Class, AMQPType>();
    private Map<Object, AMQPType> _describedDescriptorRegistry = new HashMap<Object, AMQPType>();
    private Map<Class, AMQPType> _describedTypesClassRegistry = new HashMap<Class, AMQPType>();
    private final NullType _nullType;
    private final BooleanType _booleanType;
    private final ByteType _byteType;
    private final UnsignedByteType _unsignedByteType;
    private final ShortType _shortType;
    private final UnsignedShortType _unsignedShortType;
    private final IntegerType _integerType;
    private final UnsignedIntegerType _unsignedIntegerType;
    private final LongType _longType;
    private final UnsignedLongType _unsignedLongType;
    private final BigIntegerType _bigIntegerType;
    private final CharacterType _characterType;
    private final FloatType _floatType;
    private final DoubleType _doubleType;
    private final TimestampType _timestampType;
    private final UUIDType _uuidType;
    private final Decimal32Type _decimal32Type;
    private final Decimal64Type _decimal64Type;
    private final Decimal128Type _decimal128Type;
    private final BinaryType _binaryType;
    private final SymbolType _symbolType;
    private final StringType _stringType;
    private final ListType _listType;
    private final MapType _mapType;
    private final ArrayType _arrayType;

    public EncoderImpl(DecoderImpl decoder) {
        this._decoder = decoder;
        this._nullType = new NullType(this, decoder);
        this._booleanType = new BooleanType(this, decoder);
        this._byteType = new ByteType(this, decoder);
        this._unsignedByteType = new UnsignedByteType(this, decoder);
        this._shortType = new ShortType(this, decoder);
        this._unsignedShortType = new UnsignedShortType(this, decoder);
        this._integerType = new IntegerType(this, decoder);
        this._unsignedIntegerType = new UnsignedIntegerType(this, decoder);
        this._longType = new LongType(this, decoder);
        this._unsignedLongType = new UnsignedLongType(this, decoder);
        this._bigIntegerType = new BigIntegerType(this, decoder);
        this._characterType = new CharacterType(this, decoder);
        this._floatType = new FloatType(this, decoder);
        this._doubleType = new DoubleType(this, decoder);
        this._timestampType = new TimestampType(this, decoder);
        this._uuidType = new UUIDType(this, decoder);
        this._decimal32Type = new Decimal32Type(this, decoder);
        this._decimal64Type = new Decimal64Type(this, decoder);
        this._decimal128Type = new Decimal128Type(this, decoder);
        this._binaryType = new BinaryType(this, decoder);
        this._symbolType = new SymbolType(this, decoder);
        this._stringType = new StringType(this, decoder);
        this._listType = new ListType(this, decoder);
        this._mapType = new MapType(this, decoder);
        this._arrayType = new ArrayType(this, decoder, this._booleanType, this._byteType, this._shortType, this._integerType, this._longType, this._floatType, this._doubleType, this._characterType);
    }

    @Override
    public void setByteBuffer(ByteBuffer buf) {
        this._buffer = new WritableBuffer.ByteBufferWrapper(buf);
    }

    public void setByteBuffer(WritableBuffer buf) {
        this._buffer = buf;
    }

    public WritableBuffer getBuffer() {
        return this._buffer;
    }

    public DecoderImpl getDecoder() {
        return this._decoder;
    }

    @Override
    public AMQPType getType(Object element) {
        return this.getTypeFromClass(element == null ? Void.class : element.getClass(), element);
    }

    public AMQPType getTypeFromClass(Class clazz) {
        return this.getTypeFromClass(clazz, null);
    }

    private AMQPType<?> getTypeFromClass(Class<?> clazz, Object instance) {
        AMQPType<?> amqpType = this._typeRegistry.get(clazz);
        if (amqpType == null) {
            amqpType = this.deduceTypeFromClass(clazz, instance);
        }
        return amqpType;
    }

    private AMQPType<?> deduceTypeFromClass(Class<?> clazz, Object instance) {
        AMQPType<Object[]> amqpType = null;
        if (clazz.isArray()) {
            amqpType = this._arrayType;
        } else if (List.class.isAssignableFrom(clazz)) {
            amqpType = this._listType;
        } else if (Map.class.isAssignableFrom(clazz)) {
            amqpType = this._mapType;
        } else if (DescribedType.class.isAssignableFrom(clazz)) {
            Object descriptor;
            amqpType = this._describedTypesClassRegistry.get(clazz);
            if (amqpType == null && instance != null && (amqpType = this._describedDescriptorRegistry.get(descriptor = ((DescribedType)instance).getDescriptor())) == null) {
                amqpType = new DynamicDescribedType(this, descriptor);
                this._describedDescriptorRegistry.put(descriptor, amqpType);
            }
            return amqpType;
        }
        this._typeRegistry.put(clazz, amqpType);
        return amqpType;
    }

    @Override
    public <V> void register(AMQPType<V> type) {
        this.register(type.getTypeClass(), type);
    }

    <T> void register(Class<T> clazz, AMQPType<T> type) {
        this._typeRegistry.put(clazz, type);
    }

    public void registerDescribedType(Class clazz, Object descriptor) {
        AMQPType type = this._describedDescriptorRegistry.get(descriptor);
        if (type == null) {
            type = new DynamicDescribedType(this, descriptor);
            this._describedDescriptorRegistry.put(descriptor, type);
        }
        this._describedTypesClassRegistry.put(clazz, type);
    }

    @Override
    public void writeNull() {
        this._buffer.put((byte)64);
    }

    @Override
    public void writeBoolean(boolean bool) {
        if (bool) {
            this._buffer.put((byte)65);
        } else {
            this._buffer.put((byte)66);
        }
    }

    @Override
    public void writeBoolean(Boolean bool) {
        if (bool == null) {
            this.writeNull();
        } else if (Boolean.TRUE.equals(bool)) {
            this._buffer.put((byte)65);
        } else {
            this._buffer.put((byte)66);
        }
    }

    @Override
    public void writeUnsignedByte(UnsignedByte ubyte) {
        if (ubyte == null) {
            this.writeNull();
        } else {
            this._unsignedByteType.fastWrite(this, ubyte);
        }
    }

    @Override
    public void writeUnsignedShort(UnsignedShort ushort) {
        if (ushort == null) {
            this.writeNull();
        } else {
            this._unsignedShortType.fastWrite(this, ushort);
        }
    }

    @Override
    public void writeUnsignedInteger(UnsignedInteger uint) {
        if (uint == null) {
            this.writeNull();
        } else {
            this._unsignedIntegerType.fastWrite(this, uint);
        }
    }

    @Override
    public void writeUnsignedLong(UnsignedLong ulong) {
        if (ulong == null) {
            this.writeNull();
        } else {
            this._unsignedLongType.fastWrite(this, ulong);
        }
    }

    @Override
    public void writeByte(byte b) {
        this._byteType.write(b);
    }

    @Override
    public void writeByte(Byte b) {
        if (b == null) {
            this.writeNull();
        } else {
            this.writeByte((byte)b);
        }
    }

    @Override
    public void writeShort(short s2) {
        this._shortType.write(s2);
    }

    @Override
    public void writeShort(Short s2) {
        if (s2 == null) {
            this.writeNull();
        } else {
            this.writeShort((short)s2);
        }
    }

    @Override
    public void writeInteger(int i) {
        this._integerType.write(i);
    }

    @Override
    public void writeInteger(Integer i) {
        if (i == null) {
            this.writeNull();
        } else {
            this.writeInteger((int)i);
        }
    }

    @Override
    public void writeLong(long l) {
        this._longType.write(l);
    }

    @Override
    public void writeLong(Long l) {
        if (l == null) {
            this.writeNull();
        } else {
            this.writeLong((long)l);
        }
    }

    @Override
    public void writeFloat(float f) {
        this._floatType.write(f);
    }

    @Override
    public void writeFloat(Float f) {
        if (f == null) {
            this.writeNull();
        } else {
            this.writeFloat(f.floatValue());
        }
    }

    @Override
    public void writeDouble(double d) {
        this._doubleType.write(d);
    }

    @Override
    public void writeDouble(Double d) {
        if (d == null) {
            this.writeNull();
        } else {
            this.writeDouble((double)d);
        }
    }

    @Override
    public void writeDecimal32(Decimal32 d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._decimal32Type.write(d);
        }
    }

    @Override
    public void writeDecimal64(Decimal64 d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._decimal64Type.write(d);
        }
    }

    @Override
    public void writeDecimal128(Decimal128 d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._decimal128Type.write(d);
        }
    }

    @Override
    public void writeCharacter(char c) {
        this._characterType.write(c);
    }

    @Override
    public void writeCharacter(Character c) {
        if (c == null) {
            this.writeNull();
        } else {
            this.writeCharacter(c.charValue());
        }
    }

    @Override
    public void writeTimestamp(long timestamp) {
        this._timestampType.fastWrite(this, timestamp);
    }

    @Override
    public void writeTimestamp(Date d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._timestampType.fastWrite(this, d.getTime());
        }
    }

    @Override
    public void writeUUID(UUID uuid) {
        if (uuid == null) {
            this.writeNull();
        } else {
            this._uuidType.fastWrite(this, uuid);
        }
    }

    @Override
    public void writeBinary(Binary b) {
        if (b == null) {
            this.writeNull();
        } else {
            this._binaryType.fastWrite(this, b);
        }
    }

    @Override
    public void writeString(String s2) {
        if (s2 == null) {
            this.writeNull();
        } else {
            this._stringType.write(s2);
        }
    }

    @Override
    public void writeSymbol(Symbol s2) {
        if (s2 == null) {
            this.writeNull();
        } else {
            this._symbolType.fastWrite(this, s2);
        }
    }

    @Override
    public void writeList(List l) {
        if (l == null) {
            this.writeNull();
        } else {
            this._listType.write(l);
        }
    }

    @Override
    public void writeMap(Map m3) {
        if (m3 == null) {
            this.writeNull();
        } else {
            this._mapType.write(m3);
        }
    }

    @Override
    public void writeDescribedType(DescribedType d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._buffer.put((byte)0);
            this.writeObject(d.getDescriptor());
            this.writeObject(d.getDescribed());
        }
    }

    @Override
    public void writeArray(boolean[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(byte[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(short[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(int[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(long[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(float[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(double[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(char[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(Object[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeObject(Object o) {
        if (o != null) {
            AMQPType type = this._typeRegistry.get(o.getClass());
            if (type != null) {
                type.write(o);
            } else {
                this.writeUnregisteredType(o);
            }
        } else {
            this._buffer.put((byte)64);
        }
    }

    private void writeUnregisteredType(Object o) {
        if (o.getClass().isArray()) {
            this.writeArrayType(o);
        } else if (o instanceof List) {
            this.writeList((List)o);
        } else if (o instanceof Map) {
            this.writeMap((Map)o);
        } else if (o instanceof DescribedType) {
            this.writeDescribedType((DescribedType)o);
        } else {
            throw new IllegalArgumentException("Do not know how to write Objects of class " + o.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArrayType(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            if (componentType == Boolean.TYPE) {
                this.writeArray((boolean[])array);
                return;
            } else if (componentType == Byte.TYPE) {
                this.writeArray((byte[])array);
                return;
            } else if (componentType == Short.TYPE) {
                this.writeArray((short[])array);
                return;
            } else if (componentType == Integer.TYPE) {
                this.writeArray((int[])array);
                return;
            } else if (componentType == Long.TYPE) {
                this.writeArray((long[])array);
                return;
            } else if (componentType == Float.TYPE) {
                this.writeArray((float[])array);
                return;
            } else if (componentType == Double.TYPE) {
                this.writeArray((double[])array);
                return;
            } else {
                if (componentType != Character.TYPE) throw new IllegalArgumentException("Cannot write arrays of type " + componentType.getName());
                this.writeArray((char[])array);
            }
            return;
        } else {
            this.writeArray((Object[])array);
        }
    }

    public void writeRaw(byte b) {
        this._buffer.put(b);
    }

    void writeRaw(short s2) {
        this._buffer.putShort(s2);
    }

    void writeRaw(int i) {
        this._buffer.putInt(i);
    }

    void writeRaw(long l) {
        this._buffer.putLong(l);
    }

    void writeRaw(float f) {
        this._buffer.putFloat(f);
    }

    void writeRaw(double d) {
        this._buffer.putDouble(d);
    }

    void writeRaw(byte[] src, int offset, int length) {
        this._buffer.put(src, offset, length);
    }

    void writeRaw(String string) {
        this._buffer.put(string);
    }

    AMQPType<?> getNullTypeEncoder() {
        return this._nullType;
    }
}

