/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class ShortElement
extends AtomicElement<Short> {
    private final short _value;

    ShortElement(Element parent, Element prev, short s2) {
        super(parent, prev);
        this._value = s2;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 2 : 3;
    }

    @Override
    public Short getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.SHORT;
    }

    @Override
    public int encode(ByteBuffer b) {
        if (this.isElementOfArray()) {
            if (b.remaining() >= 2) {
                b.putShort(this._value);
                return 2;
            }
        } else if (b.remaining() >= 3) {
            b.put((byte)97);
            b.putShort(this._value);
            return 3;
        }
        return 0;
    }
}

